<?php
namespace App\Controllers;
use App\Models\ReportsModel;
use App\Models\ClientsModel;
use App\Models\CompanyModel;
use App\Models\CurrencyModel;
use App\Models\FyearModel;
use App\Models\PriorityModel;
use App\Models\SalesmanModel;


class Reports extends BaseController
{
	public function __construct()
	{
		$this->is_redirect_to_login();
		$this->reports = new ReportsModel();
		$this->client = new ClientsModel();
	    $this->company = new CompanyModel();
	    $this->currency = new CurrencyModel();
	    $this->finance = new FyearModel();
        $this->level = new PriorityModel();
        $this->salesman = new SalesmanModel();

	}
	
	public function index(){
	    $this->data['title'] = lang('Text.report_admin_title');
	    echo view('admin/parts/report-list-header', $this->data);
        echo view('admin/parts/nav', $this->data);
        echo view('admin/reports/list', $this->data);
        echo view('admin/parts/report-list-footer-dash');
	}

	public function clients()
	{
	    $access = getUserPrivilegeById($this->user_id, 14);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    		$this->data['title'] = lang('Text.report_client_statementsn_title');
    		$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['country_list'] = $this->client->list_country();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/clients', $this->data);
            echo view('admin/parts/report-list-footer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman()
	{
	    $access = getUserPrivilegeById($this->user_id, 15);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    		$this->data['title'] = lang('Text.report_salesman_statementsn_title');
    		$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['country_list'] = $this->client->list_country();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/salesman', $this->data);
            echo view('admin/parts/report-list-footer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}

	public function clients_ajax()
	{
		$postData = $_POST;
		$fdata = $this->reports->getClientsStatements($postData,$this->fyear);
		echo json_encode($fdata);
	}
	
	public function salesman_ajax()
	{
		$postData = $_POST;
		$fdata = $this->reports->getSalesmanStatements($postData,$this->fyear);
		echo json_encode($fdata);
	}
	
	public function aging_invoice_date_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 16);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_aging_invoice_date_fc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		 $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
    		//$this->data['country_list'] = $this->client->list_country();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/aging-invoice-date-fc', $this->data);
            echo view('admin/parts/report-list-footer', $this->data);
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function aging_invoice_date_fc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getAgingInvoicedateFcStatements($postData,$this->fyear);
		echo json_encode($fdata);
	}
	
	public function aging_invoice_date_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 17);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['fc_currency'] = $this->fc_currency;
    	    $this->data['title'] = lang('Text.report_aging_invoice_date_mc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		//$this->data['country_list'] = $this->client->list_country();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/aging-invoice-date-mc', $this->data);
            echo view('admin/parts/report-list-footer', $this->data);
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function aging_invoice_date_mc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getAgingInvoicedateMcStatements($postData,$this->fyear, $this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function aging_due_date_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 18);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    //$this->data['fc_currency'] = $this->fc_currency;
    	    $this->data['title'] = lang('Text.report_aging_due_date_fc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		//$this->data['country_list'] = $this->client->list_country();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/aging-due-date-fc', $this->data);
            echo view('admin/parts/report-list-footer', $this->data);
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function aging_due_date_fc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getAgingDuedateFcStatements($postData,$this->fyear);
		echo json_encode($fdata);
	}
	
	public function aging_due_date_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 19);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['fc_currency'] = $this->fc_currency;
    	    $this->data['title'] = lang('Text.report_aging_due_date_mc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		//$this->data['country_list'] = $this->client->list_country();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/aging-due-date-mc', $this->data);
            echo view('admin/parts/report-list-footer', $this->data);
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function aging_due_date_mc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getAgingDuedateMcStatements($postData,$this->fyear, $this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function invoice_details_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 20);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_invoice_details_mc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/invoice-details-mc', $this->data);
            echo view('admin/parts/report-list-footer-invoice');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman_wise_sales_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 44);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_salesman_wise_sales_mc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/salesman-wise-sales-mc', $this->data);
            echo view('admin/parts/report-list-footer-invoice');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function invoice_details_mc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getInvoiceDetailsMC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function salesman_wise_sales_mc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getInvoiceDetailsSalesmanMC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function invoice_details_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 21);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_invoice_details_fc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/invoice-details-fc', $this->data);
            echo view('admin/parts/report-list-footer-invoice');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function invoice_details_fc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getInvoiceDetailsFC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function salesman_wise_sales_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 43);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_salesman_wise_sales_fc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/salesman-wise-sales-fc', $this->data);
            echo view('admin/parts/report-list-footer-invoice');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman_wise_sales_fc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getInvoiceDetailsSalesmanFC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function followup_details_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 22);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_followup_details_mc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/followup-details-mc', $this->data);
            echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_details_mc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getFollowupDetailsMC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function followup_details_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 23);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_followup_details_fc_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/followup-details-fc', $this->data);
            echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_details_fc_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getFollowupDetailsFC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
	public function followup_history()
	{
	    $access = getUserPrivilegeById($this->user_id, 24);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_followup_history_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['headcomp'] = $this->company->where('parent', 1)->first();
            $this->data['priority_list'] =  $this->level->findAll();
            $this->data['active_period'] = $this->reports->active_period();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/followup-history', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_history_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    /*switch ($this->user_role) {
	        case 1:*/
	            $fdata = $this->reports->getFollowupHistory($postData,$this->fyear);
	            /*break;
	        case 2:
	            $fdata = $this->followup->getFollowupsByCreators($postData,$this->fyear, $this->user_id);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";*/
	    //}
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	
	public function followup_summary()
	{
	    $access = getUserPrivilegeById($this->user_id, 25);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_followup_summary_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/followup-summary', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_summary_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    /*switch ($this->user_role) {
	        case 1:*/
	            $fdata = $this->reports->getFollowupSummary($postData,$this->fyear);
	            /*break;
	        case 2:
	            $fdata = $this->followup->getFollowupsByCreators($postData,$this->fyear, $this->user_id);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";*/
	    //}
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	
	public function followup_analysis()
	{
	    $access = getUserPrivilegeById($this->user_id, 26);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_followup_analysis_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/followup-analysis', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_analysis_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getFollowupAnalysis($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	public function missing_followup_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 27);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_missing_followup_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/missing-followup-fc', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_missing_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getFollowupMissingFc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	public function missing_followup_mc()
	{
	     $access = getUserPrivilegeById($this->user_id, 28);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_missing_followup_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/missing-followup-mc', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function followup_missing_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getFollowupMissingMc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function next_followup_report_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 29);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_next_followup_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/next-followup-fc', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_next_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getFollowupNextFc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function next_followup_report_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 30);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_next_followup_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/next-followup-mc', $this->data);
    		echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function followup_next_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getFollowupNextMc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function collection_details_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 31);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_collection_details_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/collection-details-fc', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman_wise_collection_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 45);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_salesman_wise_collection_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/salesman-wise-collection-fc', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function collection_details_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionDetailsFc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function salesman_wise_collection_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionDetailsSalesmanFc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function collection_details_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 32);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_collection_details_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['headcomp'] = $this->company->where('parent', 1)->first();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/collection-details-mc', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman_wise_collection_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 46);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_salesman_wise_collection_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['headcomp'] = $this->company->where('parent', 1)->first();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/salesman-wise-collection-mc', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function collection_details_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionDetailsMc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function salesman_wise_collection_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionDetailsSalesmanMc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function customer_soa_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 33);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_customer_soa_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/customer-soa-fc', $this->data);
    		echo view('admin/parts/report-list-footer-customer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function customer_soa_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCustomerSoaFc($postData,$this->fyear);
	    echo json_encode($fdata);
	}
	
	public function customer_soa_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 34);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_customer_soa_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/customer-soa-mc', $this->data);
    		echo view('admin/parts/report-list-footer-customer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function customer_soa_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCustomerSoaMc($postData,$this->fyear,$this->fc_currency);
	    echo json_encode($fdata);
	}
	
	public function customer_analysis()
	{
	    $access = getUserPrivilegeById($this->user_id, 35);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_customer_analysis_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/customer-analysis', $this->data);
    		echo view('admin/parts/report-list-footer-customer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function customer_analysis_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCustomerAnalysis($postData,$this->fyear,$this->fc_currency);
	    echo json_encode($fdata);
	}
	public function customer_analysis_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 36);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_customer_analysis_fc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/customer-analysis-fc', $this->data);
    		echo view('admin/parts/report-list-footer-customer');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function customer_analysis_fc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCustomerAnalysisFC($postData,$this->fyear,$this->fc_currency);
	    echo json_encode($fdata);
	}
	public function collection_summary()
	{
	    $access = getUserPrivilegeById($this->user_id, 37);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_collection_summary_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/collection-summary', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function collection_summary_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionSummary($postData,$this->fyear,$this->fc_currency);
	    echo json_encode($fdata);
	}
	
	public function collection_summary_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 38);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	     $this->data['title'] = lang('Text.report_collection_summary_mc_title');
                    
            $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
            $this->data['company_list'] = $this->company->where('status', 1)->findAll();
            $this->data['fyear_list'] = $this->finance->findAll();
            $this->data['priority_list'] =  $this->level->findAll();
    		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
            echo view('admin/parts/report-list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/reports/collection-summary-mc', $this->data);
    		echo view('admin/parts/report-list-footer-collection');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function collection_summary_mc_ajax()
	{
	    $postData = $_POST;
	    $fdata = $this->reports->getCollectionSummaryMC($postData,$this->fyear,$this->fc_currency);
	    echo json_encode($fdata);
	}
	
	public function invoice_summary_fc()
	{
	    $access = getUserPrivilegeById($this->user_id, 39);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        echo "On Hold";
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function invoice_summary_mc()
	{
	    $access = getUserPrivilegeById($this->user_id, 40);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        echo "On Hold";
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function collection_receipt()
	{
	    $access = getUserPrivilegeById($this->user_id, 41);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        echo "On Hold";
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function expected_collection_by_followup()
	{
	    $access = getUserPrivilegeById($this->user_id, 42);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_expected_collections_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/expected-collection-by-followup', $this->data);
            echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}


	
	public function expected_collection_by_followup_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getFollowupCollectionFC($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}

	public function expected_collection_summary()
	{
	    $access = getUserPrivilegeById($this->user_id, 48);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.report_expected_collections_title');
    		//$this->data['collection_centre'] = $this->client->where('is_same_parent', 1)->findAll();
    		$this->data['company_list'] = $this->company->where('status', 1)->findAll();
    		$this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
    		$this->data['fyear_list'] = $this->finance->findAll();
    		$this->data['active_period'] = $this->reports->active_period();
    		$this->data['headcomp'] = $this->company->where('parent', 1)->first();
    		//$this->data['country_list'] = $this->client->list_country();
    		echo view('admin/parts/report-list-header', $this->data);
            echo view('admin/parts/nav', $this->data);
            echo view('admin/reports/expected-collection-summary', $this->data);
            echo view('admin/parts/report-list-footer-followup');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}

	public function expected_collection_summary_ajax()
	{
	    $postData = $_POST;
		$fdata = $this->reports->getFollowupCollectionSummary($postData,$this->fyear,$this->fc_currency);
		echo json_encode($fdata);
	}
	
}
 