
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminLTE 3 | Recover Password (v2)</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- toastr bootstrap -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/toastr/toastr.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/dist/css/adminlte.min.css">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="<?php echo base_url() ?>" class="h1"><b>Admin</b>RMS</a>
    </div>
    <div class="card-body">
      <p class="login-box-msg">You are only one step a way from your new password, recover your password now.</p>
      <form id="resetForm" action="<?php echo base_url() ?>/home/reset_password_process" method="post">
        <div class="input-group mb-3">
          <input type="password" class="form-control" placeholder="Password" name="password" id="password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" class="form-control" placeholder="Confirm Password" name="cpassword" id="cpassword">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
              <input type="hidden" name="token" id="token" value="<?=$token?>">
            <button type="submit" class="btn btn-primary btn-block" id="btn-login">Change password</button>
          </div>
          <!-- /.col -->
        </div>
      </form>

      <p class="mt-3 mb-1">
        <a href="<?php echo base_url() ?>">Login</a>
      </p>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo base_url() ?>/public/plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo base_url() ?>/public/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- jquery-validation -->
<script src="<?php echo base_url() ?>/public/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="<?php echo base_url() ?>/public/plugins/jquery-validation/additional-methods.min.js"></script>
<!-- toastr modal -->
<script src="<?php echo base_url() ?>/public/plugins/toastr/toastr.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url() ?>/public/dist/js/adminlte.min.js"></script>
<script>
$(function () {
    
    function login_submit() {
       // $('#btn-login i').addClass('fa-refresh fa-spin');
       $('#btn-login').prop('disabled', true);
       $.post("<?php echo base_url('home/reset_password_process') ?>", $('#resetForm').serialize(), function (data) {
           $('#btn-login').prop('disabled', false);
           if (data.type == 'success'){
                    toastr.success(data.message);
	  				location.href = '<?php echo base_url('/') ?>';
	  			} else {
	  				
	  				toastr.error(data.message);
	  				//$('#btn-login i').removeClass('fa-refresh fa-spin');
	  			}
       }, 'json')
    }
  $.validator.setDefaults({
    submitHandler: function () {
      login_submit();
    }
  });
  $('#resetForm').validate({
    rules: {
      password: {
        required: true,
        minlength: 5
      },
      cpassword : {
          minlength : 5,
          equalTo : "#password"
       }
      /*terms: {
        required: true
      },*/
    },
    messages: {
      password: {
        required: "Please provide a password",
        minlength: "Your password must be at least 5 characters long"
      }/*,
      terms: "Please accept our terms"*/
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.input-group').append(error);
    },
    highlight: function (element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
</body>
</html>
