<?php
namespace App\Controllers;
use App\Models\CollectionModel;
use App\Models\InvoiceModel;
use App\Models\ClientsModel;
use App\Models\CurrencyModel;
use App\Models\CompanyModel;
use App\Models\PriorityModel;
use App\Models\TemplateModel;

class Collections extends BaseController
{
    public function __construct()
	{
	    $this->is_redirect_to_login();
	    $this->collection = new CollectionModel();
	    $this->invoice = new InvoiceModel();
	    $this->client = new ClientsModel();
	    $this->currency = new CurrencyModel();
	    $this->company = new CompanyModel();
	    $this->level = new PriorityModel();
      $this->template = new TemplateModel();
	}
	public function index()
	{
    $this->data['templates'] = $this->template->where('mailgroup', 'collection')->find();
	    switch ($this->user_role) {
            case 1:
               $this->data['title'] = lang('Text.collections_admin_title');
                
                $this->data['invoices_list'] = $this->invoice->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/collections/list', $this->data);
        		echo view('admin/parts/collections-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.collections_admin_title');
                $this->data['invoices_list'] = $this->invoice->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/collections/list', $this->data);
        		echo view('admin/parts/collections-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	
	//collections_ajax
	public function collections_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    switch ($this->user_role) {
	        case 1:
	            $fdata = $this->collection->getCollections($postData,$this->fyear);
	            break;
	        case 2:
	            $fdata = $this->collection->getCollectionsByCreators($postData,$this->fyear,$this->user_id);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";
	    }
	    
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	
	public function collections_invoice_search_ajax()
	{
	      if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		/*$input = $this->validate([
            'client' => 'required'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }*/
        $clients = [];
        $parent_client = $this->request->getPost('client');
        if(!empty($parent_client)){
            $clients[] =  $parent_client;
            
            $client_data = $this->client->where('Parent_client', $parent_client)->findAll();
            foreach($client_data as $key => $data){
                $clients[] = $data['client_id'];
            }
        }
        
        $invoice_id = $this->request->getPost('invoice');
        
        $invoicedate = $this->request->getPost('invoicedate');
        
        $priority = $this->request->getPost('critical_level');
        $company = $this->request->getPost('sel_company');
        //print_r($invoicedate);exit;
        
        //get all followups 
        $followups = $this->collection->fetch_invoice_followup($clients, $invoice_id, $invoicedate, $priority, $company, $this->fyear);
        echo json_encode(array('type'=>'search', 'data' => $followups, 'datacount'=>count($followups)));
		    exit;
	}
	
	public function collections_crud_ajax()
	{
	    //print_r($_POST);exit;
	    $operation = $this->request->getPost('operation');
	    $refNo = (isset($_POST['ref_no']) && !empty($_POST['ref_no'])) ? $_POST['ref_no'] : '';
        if (!empty($refNo)){
            $dataref = $this->collection->where('ref_no',$refNo)->find();
            $countref = count($dataref);
            if ($countref > 0){
              echo json_encode(array('type'=>'exist', 'message' => 'REF. No is already exist!'));
              exit;
            }
        }
        if($operation == 'Add'){
           $check = $this->request->getPost('check');
           $followup_id = $this->request->getPost('followup_id');
           //echo count($check);exit;
           $collections = array();
           $dynamicref = time();
           if (count($check) > 0){
               $loop = count($followup_id);
               $received_date = $_POST['received_date'];
               $ref_no = (isset($_POST['ref_no']) && !empty($_POST['ref_no'])) ? $_POST['ref_no'] : $dynamicref;
               for ($i = 0; $i < $loop; $i++ ){
                   //echo $i;
                   $chkitem = $_POST['chkitem'][$i];
                   if (!empty($chkitem)){
                       //echo $i;
                       $fid = $_POST['followup_id'][$i];
                       $selclient = $_POST['selclient'][$i];
                       $invoice_no = $_POST['invoice_no'][$i];
                       $invoice_date = $_POST['invoice_date'][$i];
                       $selCurrency = $_POST['selCurrency'][$i];
                       $invoice_amount = $_POST['invoice_amount'][$i];
                       $adjustment = $_POST['adjustment'][$i];
                       $received_amount = $_POST['received_amount'][$i];
                       $payType = $_POST['payType'][$i];
                       $payMode = $_POST['payMode'][$i];
                       $balance = $_POST['balance'][$i];
                       
                       $invoice_status = 'O';
                       if($balance == 0 || $balance == 1){
                          $invoice_status = 'C'; 
                       }
                       
                       $functional_currency_id = $this->fc_currency;
                       $curr_data = $this->currency->where('currency_id', $selCurrency)->findAll();
                       $fc_rate = $curr_data[0]['rate'];
                       $fc_rate = (!empty($fc_rate)) ? $fc_rate : 1;
                       $fc_date = $curr_data[0]['rateDate'];
                       
                       $balance_fc_amount = 0;
                       $received_amount_in_fc = 0;
                       if($selCurrency == $functional_currency_id){
                           $balance_fc_amount = $balance;
                           $received_amount_in_fc = $received_amount;
                       } else {
                           $balance_fc_amount = (float)$balance * (float)$fc_rate;
                           $received_amount_in_fc = (float)$received_amount * (float)$fc_rate;
                       }
                       
                           
                   
                       $collections[] = array(
                           'followup_id' => $fid,
                           'financialYear_id' =>  $this->fyear,
                           'received_amount' => $received_amount,
                           'received_amount_in_fc' => $received_amount_in_fc,
                           'payment_mode' => $payMode,
                           'payment_type' => $payType,
                           'received_date' => (!empty($received_date)) ? date('Y-m-d',strtotime($received_date)) : date('Y-m-d'),
                           'ref_no'=> $ref_no,
                           'adjustment' => (!empty($adjustment)) ? $adjustment : 0,
                           'balance' => $balance,
                           'balance_amount_in_fc' => $balance_fc_amount,
                           'Invoice_status'=> $invoice_status,
                           'status'=> 'A',
                           'createdBy' => $this->user_id,
                           'updatedBy' => 0,
    				       'updatedDate' => '0000-00-00 00:00:00'
                        );
                        
                        //update invoice table , status, based on fid
                        $data = [
                            'balance' => $balance,
                            'balance_amount_in_fc' => $balance_fc_amount,
                            'invoice_status'=> $invoice_status,
                            ];
                            
                        $this->collection->update_invoice_data($data,$fid);
                        
                        //take record of fid and insert it with received date to followup history
                        $rowfdta = $this->collection->row_followup($fid);
                        $fdatacopy = array(
                            "followup_id" => $rowfdta->followup_id,
                            "client_id" => $rowfdta->client_id,
                            "invoice_id" => $rowfdta->invoice_id,
                            "financial_year_id" => $rowfdta->financial_year_id,
                            "company_id" => $rowfdta->company_id,
                            'salesman_id'=> $rowfdta->salesman_id,
                            "Invoice_date" => date('Y-m-d', strtotime($rowfdta->Invoice_date)),
                            "payment_terms" => $rowfdta->payment_terms,
                            "due_date" => date('Y-m-d', strtotime($rowfdta->due_date)),
                            "currency_id" => $rowfdta->currency_id,
                            "invoice_amount" => $rowfdta->invoice_amount,
                            "balance" => $balance,
                            "fc_currency_rate" => $rowfdta->fc_currency_rate,
                            "fc_currency_date" => date('Y-m-d', strtotime( $rowfdta->fc_currency_date)),
    		                    "invoice_amount_in_fc" => $rowfdta->invoice_amount_in_fc,
    		                    "balance_amount_in_fc" => $balance_fc_amount,
    		                    "received_date" => (!empty($received_date)) ? date('Y-m-d',strtotime($received_date)) : date('Y-m-d'),
    		                    "cust_ref_no"=> $rowfdta->cust_ref_no,
            				        "invoice_status" => $invoice_status,
                            "status" =>'A',
                            "createdBy" => $this->user_id,
                            "updatedBy" => 0,
    		                    "updatedDate" => '0000-00-00 00:00:00'
                          );
                        
                        $this->collection->insert_followup_data_copy($fdatacopy);
                        //chck record exist update statusus to inactive
                            
                        $checkRecord = $this->collection->where('followup_id',$fid)->countAllResults();
                       if ($checkRecord > 0){
                           //update status to inactive
                           $this->collection->update($fid, ['status' => 'I']);
                       }
                   }
               
               }
               //print_r($collections);exit;
               $status = $this->collection->save_all_collections($collections);
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Collection Batch Inserted Successfully!', 'redirect'=> 'collections', 'printrefno'=> $ref_no));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Collection Batch Not Inserted Successfully!', 'redirect'=> 'collections'));
		           exit; 
                }
           }
        }
        exit;
	}


	
	public function print($refno = null)
	{
	    //echo $refno;
	    //echo "print";
	    $this->data['refno'] = $refno;
	    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
	    $this->data['printdata'] = $this->collection->getPrintData($refno);
	    $this->data['printsum'] = $this->collection->getPrintSum($refno);
	    $this->data['headcomp'] = $this->company->where('parent', 1)->first();
	    echo view('admin/collections/print', $this->data);
	}
	
	public function get_invoices()
	{
	    $client_id = $this->request->getPost('client_id');
	    echo $this->collection->get_invoice_options($client_id);
	}
	
    public function add()
    {
        $access = getUserPrivilegeById($this->user_id, 13);
        $this->data['templates'] = $this->template->where('mailgroup', 'collection')->find();
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
            $x_search_client = $this->session->get('search_client');
            $x_search_invoice = $this->session->get('search_invoice');
            //$this->fc_currency
            switch ($this->user_role) {
                case 1:
                    $this->data['search_client'] = !empty($x_search_client) ? $x_search_client : 0;
                    $this->data['search_invoice'] = !empty($x_search_invoice) ? $x_search_invoice : 0;
                    $this->data['title'] = lang('Text.collections_add_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['invoices_list'] = $this->invoice->findAll(25, 0);
                    /*$this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();*/
                    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                    //print_r($this->data['curr_data']);
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['priority_list'] =  $this->level->findAll();
    		        $this->data['company_list'] = $this->client->list_company();
    		        
                    echo view('admin/parts/collections-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/collections/add', $this->data);
            		echo view('admin/parts/collections-form-footer');
            		echo view('admin/collections/script');
                    break;
                case 2:
                    $this->data['search_client'] = !empty($x_search_client) ? $x_search_client : 0;
                    $this->data['search_invoice'] = !empty($x_search_invoice) ? $x_search_invoice : 0;
                    $this->data['title'] = lang('Text.collections_add_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['invoices_list'] = $this->invoice->findAll();
                    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                    //print_r($this->data['curr_data']);
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['priority_list'] =  $this->level->findAll();
    		        $this->data['company_list'] = $this->client->list_company();
    		        
                    echo view('admin/parts/collections-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/collections/add', $this->data);
            		echo view('admin/parts/collections-form-footer');
            		echo view('admin/collections/script');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   echo "i is not equal to 0, 1 or 2";
            }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function send_email_add()
    {
        if (!$this->request->isAJAX()) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            return;
        }
        $check = $this->request->getPost('check');
        $followup_id = $this->request->getPost('followup_id');
        if (count($check) > 0){
          $loop = count($followup_id);
          $received_date = $_POST['received_date'];
          $fcurr = $_POST['fcurr'];
          $tablehtml = '<style>
                  table {
                    font-family: arial, sans-serif;
                    border-collapse: collapse;
                    width: 100%;
                  }

                  td, th {
                    border: 1px solid #dddddd;
                    text-align: left;
                    padding: 8px;
                  }

                  tr:nth-child(even) {
                    background-color: #dddddd;
                  }
                  </style>';
          $tablehtml .= '<table width="100%"><tr><th>Inv No</th><th>Cur</th><th>Inv Amount</th><th>Previous Balance</th><th>Receipt</th><th>Balance</th></tr>';
          $tablehtml .= '<tbody>';
          $received_amount_sum = $_POST['expTotal'];
          for ($i = 0; $i < $loop; $i++ ){
            $chkitem = $_POST['chkitem'][$i];
            if (!empty($chkitem)){
              $invoice_no = $_POST['invoice_no'][$i];
              $selCurrency = $_POST['selCurrency'][$i];
              $currency = get_currency($selCurrency);
              $invoice_amount = $_POST['invoice_amount'][$i];
              $prev_bal = $_POST['balance_pay_amount'][$i];
              $received_amount = $_POST['received_amount'][$i];
              $balance = $_POST['balance'][$i];
              
              $tablehtml .= '<tr>';
              $tablehtml .= '<td>'.$invoice_no.'</td>';
              $tablehtml .= '<td>'.$currency.'</td>';
              $tablehtml .= '<td>'.$invoice_amount.'</td>';
              $tablehtml .= '<td>'.$prev_bal.'</td>';
              $tablehtml .= '<td>'.$received_amount.'</td>';
              $tablehtml .= '<td>'.$balance.'</td>';
              $tablehtml .= '</tr>';
            }
          }
          $tablehtml .= '</tbody>';
          $tablehtml .= '</table>';
        }

        $email = $this->request->getPost('email');
        $name = $this->request->getPost('name');
        $template = $this->request->getPost('template');
        
        //$headcomp = $this->company->where('parent', 1)->first();
        //$companyName = $headcomp['companyName'];

        $template_info = $this->template->where('slug', $template)->first();
        $subject = (isset($template_info['subject']) && !empty($template_info['subject'])) ? $template_info['subject'] : 'Customer  Payment Acknowledgement';
        $image = (isset($template_info['image']) && !empty($template_info['image'])) ? base_url().$template_info['image'] :'';
        $message = str_replace('%CLIENT%', $name, $template_info['template']);
        $message = str_replace('%RECEIVEDDATE%', date('d-m-Y', strtotime($received_date)), $message);
        $message = str_replace('%RECEIVEDAMT%', $received_amount_sum , $message);
        $message = str_replace('%CURRENCY%', $fcurr , $message);
        //$f = new \NumberFormatter("en", NumberFormatter::SPELLOUT);
        //$amt_in_words = ucfirst($f->format($received_amount_sum));
        $amt_in_words = '';
        $message = str_replace('%RECEIVEDAMTTXT%', $amt_in_words , $message);

        $message_foot = $template_info['signature'];

        $messagebody = $message.'<br>'.$tablehtml.'<br>'.$message_foot;
        $template = $this->template_register($messagebody, $image);
        $to = $email;
        if($this->send_email_rms($to, $subject, $template, $image)){
            $type    = 'success';
            $message = 'Email sent';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        } else {
            $type    = 'error';
            $message = 'Something wrong!! Email not sent.';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        }
        exit;
        
    }

  public function send_email()
    {
        if (!$this->request->isAJAX()) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            return;
        }

        $email = $this->request->getPost('email');
        $name = $this->request->getPost('name');
        $template = $this->request->getPost('template');
        $refno = $this->request->getPost('refno');

        $curr_data = $this->currency->where('currency_id', $this->fc_currency)->first();
        $printdata = $this->collection->getPrintData($refno);
        $printsum = $this->collection->getPrintSum($refno);
        $tablehtml = '';
        
        //print_r($printdata);
        if(!empty($printdata)){
          $received_date = date('d-m-Y',strtotime($printdata[0]['received_date']));
          $received_amount_sum = $printsum[0]['total'];
          $fcurr = $curr_data['code'];
          $tablehtml .= '<table width="100%"><tr><th>Inv No</th><th>Cur</th><th>Inv Amount</th><th>Previous Balance</th><th>Receipt</th><th>Balance</th></tr>';
          $tablehtml .= '<tbody>';
          foreach ($printdata as $key => $data) {
            $invoice_no = get_invoice($data['invoice_id']);
            $currency = get_currency($data['currency_id']);
            $invoice_amount = $data['invoice_amount'];
            $received_amount = $data['received_amount'];
            $balance = $data['balance'];
            $prev_bal = $received_amount + $balance;

            $tablehtml .= '<tr>';
            $tablehtml .= '<td>'.$invoice_no.'</td>';
            $tablehtml .= '<td>'.$currency.'</td>';
            $tablehtml .= '<td>'.$invoice_amount.'</td>';
            $tablehtml .= '<td>'.$prev_bal.'</td>';
            $tablehtml .= '<td>'.$received_amount.'</td>';
            $tablehtml .= '<td>'.$balance.'</td>';
            $tablehtml .= '</tr>';
          }
          $tablehtml .= '</tbody>';
          $tablehtml .= '</table>';
        }
//echo $tablehtml;
        $template_info = $this->template->where('slug', $template)->first();
        $subject = (isset($template_info['subject']) && !empty($template_info['subject'])) ? $template_info['subject'] : 'Customer  Payment Acknowledgement';
        $image = (isset($template_info['image']) && !empty($template_info['image'])) ? base_url().$template_info['image'] :'';
        $message = str_replace('%CLIENT%', $name, $template_info['template']);
        $message = str_replace('%RECEIVEDDATE%', date('d-m-Y', strtotime($received_date)), $message);
        $message = str_replace('%RECEIVEDAMT%', $received_amount_sum , $message);
        $message = str_replace('%CURRENCY%', $fcurr , $message);
        //$f = new \NumberFormatter("en", NumberFormatter::SPELLOUT);
        //$amt_in_words = ucfirst($f->format($received_amount_sum));
        $amt_in_words = '';
        $message = str_replace('%RECEIVEDAMTTXT%', $amt_in_words , $message);

        $message_foot = $template_info['signature'];

        $messagebody = $message.'<br>'.$tablehtml.'<br>'.$message_foot;
        $template = $this->template_register($messagebody, $image);
        $to = $email;
        if($this->send_email_rms($to, $subject, $template, $image)){
            $type    = 'success';
            $message = 'Email sent';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        } else {
            $type    = 'error';
            $message = 'Something wrong!! Email not sent.';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        }

    }
    
    public function receipt_details()
    {
      if (!$this->request->isAJAX()) {
          throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
          return;
      }

      $refNo = $this->request->getPost('refno');
      $curr_data = $this->currency->where('currency_id', $this->fc_currency)->first();
      $printdata = $this->collection->getPrintData($refNo);
      $printsum = $this->collection->getPrintSum($refNo);

      $table = '<div class="col-8"><div class="table-responsive">
          <table class="table"><tr><td style="border: none;font-size: 15.5px !important;">Client : '.get_client($printdata[0]['client_id']).'</td></tr></table></div></div><div class="col-4">Received Date : '.date('d-m-Y', strtotime($printdata[0]['received_date'])).'</div>';
      $table .= '<div class="clear" style="height:10px"></div>';
      $table .= '<table class="table table-bordered table-striped">';
      $table .= '<tr><th>Invoice</th><th>Cur</th><th>Inv. Amt</th><th>Inv. Amt in '.$curr_data['code'].'</th><th>Rcpt. Amt</th> <th>Rcpt. Amt in '.$curr_data['code'].'</th><th>Balance</th><th>Balance in '.$curr_data['code'].'</th><th>Invoice Status</th></tr>';
      foreach ($printdata as $key => $data) {
        $invoice_id = get_invoice($data['invoice_id']);
        $currency = get_currency($data['currency_id']);
        $rcpt_amt = $data['received_amount'];
        $inv_amt = $data['invoice_amount'];
        $inv_amt_fc = $data['invoice_amount_in_fc'];
        $rcpt_amt_fc = $data['received_amount_in_fc'];
        $bal = $data['balance'];
        $bal_fc = $data['balance_amount_in_fc'];
        $status = '';
        if($data['Invoice_status'] == 'O'){
            $status = '<span class="rmsopen">Open</span>';
        }else if($data['Invoice_status'] == 'C'){
            $status = '<span class="rmsclosed">Closed</span>';
        }
        $table .= '<tr><td>'.$invoice_id.'</td><td>'.$currency.'</td><td>'.$inv_amt.'</td><td>'.$inv_amt_fc.'</td><td>'.$rcpt_amt.'</td><td>'.$rcpt_amt_fc.'</td><td>'.$bal.'</td><td>'.$bal_fc.'</td><td>'.$status.'</td></tr>';
      }
      $table .= '<tfoot><tr><td colspan="5"></td><td>'.$printsum[0]['total'].'</td></tr></tfoot>';
      $table .= '</table>';
      //echo $table;
      echo json_encode(array('type'=>'success', 'message' => $table));
            exit;

    }

}