<?php

namespace App\Models;

use CodeIgniter\Model;

class RemindersModel extends Model
{
    protected $table = 'tbl_reminder_m';

	protected $primaryKey = 'reminder_id';

	protected $allowedFields = ['subject', 'scheduled_date','createdBy', 'updatedBy', 'updatedDate', 'status', 'completed_date', 'priority', 'financialYear_id'];
	
	public function row_reminder($id = null)
    {
        $reminder_id = base64_decode($id);
        $query = $this->db->query("SELECT reminder_id,subject,scheduled_date,createdBy,createdDate,updatedBy,updatedDate,status,completed_date,priority FROM tbl_reminder_m WHERE reminder_id = '$reminder_id'");
        $row = $query->getRow();
        return $row;
    }

    public function getReminders($postData=null, $fyear = 0, $user_id = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc

        $searchSdate = $postData['searchSdate'];
        $searchPriority = $postData['searchPriority'];
        $searchStatus = $postData['searchStatus'];

        $builder = $this->db->table('tbl_reminder_m');
        $builder->where('financialYear_id', $fyear);
        $totalRecords = $builder->countAllResults();

        $builder->select('*');
        $builder->where('financialYear_id', $fyear);
        if(!empty($searchSdate)){
            //explode
            
            $schdates = explode("-",$searchSdate);
            $date1 = date('Y-m-d', strtotime($schdates[0]));
            $date2 = date('Y-m-d', strtotime($schdates[1]));
            $builder->where('scheduled_date >=', $date1);
            $builder->where('scheduled_date <=', $date2);
            
           
        }

        if(!empty($searchPriority)){
            $builder->where('priority', $searchPriority);
        }
        if(!empty($searchStatus)){
            $builder->where('status', $searchStatus);
        }
        $totalRecordwithFilter = $builder->countAllResults();

        $builder->select('*');
        $builder->where('financialYear_id', $fyear);
        if(!empty($searchSdate)){
            //explode
            
            $schdates = explode("-",$searchSdate);
            $date1 = date('Y-m-d', strtotime($schdates[0]));
            $date2 = date('Y-m-d', strtotime($schdates[1]));
            $builder->where('scheduled_date >=', $date1);
            $builder->where('scheduled_date <=', $date2);
            
           
        }
        if(!empty($searchPriority)){
            $builder->where('priority', $searchPriority);
        }
        if(!empty($searchStatus)){
            $builder->where('status', $searchStatus);
        }
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();

        $data = array();
         foreach($records as $record ){
            $status = '';
            if($record->status == 'C'){
                $status = '<span class="rmsopen">Completed</span>';
            }else if($record->status == 'P'){
                $status = '<span class="Pending">Pending</span>';
            }

            $access = getUserPrivilegeById($user_id, 47); 
            $button = '';

            if($user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {

                 $button .= '<a href="'. base_url() .'/reminders/edit/'. base64_encode($record->reminder_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Edit"><i class="fas fa-pencil-alt"></i></a>';
            }
            if($user_id == 1 || (isset($access->deleteStatus) && $access->deleteStatus == 1)) {

                 $button .= '<button class="btn btn-danger btn-sm btn-flat btn-reminder-delete btn-rms" data-id="'.$record->reminder_id.'" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button>';
            }

            $data[] = array( 
             "subject"=>$record->subject,
             "schedate"=>date('d-m-Y', strtotime($record->scheduled_date)),
             "status"=>$status,
             "createddate"=>date('d-m-Y', strtotime($record->createdDate)),
             "compdate"=>date('d-m-Y', strtotime($record->completed_date)),
             "createdby"=>get_user($record->createdBy),
             "action"=>$button,
           );
         }

         ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response;
    }

    public function getRemindersByCreators($postData=null, $fyear = 0, $user_id = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc

        $searchSdate = $postData['searchSdate'];
        $searchPriority = $postData['searchPriority'];

        $builder = $this->db->table('tbl_reminder_m');
        $builder->where('financialYear_id', $fyear);
        $builder->where('createdBy', $user_id);
        $totalRecords = $builder->countAllResults();

        $builder->select('*');
        $builder->where('financialYear_id', $fyear);
        $builder->where('createdBy', $user_id);
        if(!empty($searchSdate)){
            //explode
            
            $schdates = explode("-",$searchSdate);
            $date1 = date('Y-m-d', strtotime($schdates[0]));
            $date2 = date('Y-m-d', strtotime($schdates[1]));
            $builder->where('scheduled_date >=', $date1);
            $builder->where('scheduled_date <=', $date2);
            
           
        }

        if(!empty($searchPriority)){
            $builder->where('priority', $searchPriority);
        }
        $totalRecordwithFilter = $builder->countAllResults();

        $builder->select('*');
        $builder->where('financialYear_id', $fyear);
        $builder->where('createdBy', $user_id);
        if(!empty($searchSdate)){
            //explode
            
            $schdates = explode("-",$searchSdate);
            $date1 = date('Y-m-d', strtotime($schdates[0]));
            $date2 = date('Y-m-d', strtotime($schdates[1]));
            $builder->where('scheduled_date >=', $date1);
            $builder->where('scheduled_date <=', $date2);
            
           
        }

        if(!empty($searchPriority)){
            $builder->where('priority', $searchPriority);
        }
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();

        $data = array();

        foreach($records as $record ){
            $status = '';
            if($record->status == 'C'){
                $status = '<span class="rmsopen">Completed</span>';
            }else if($record->status == 'P'){
                $status = '<span class="Pending">Closed</span>';
            }

            $access = getUserPrivilegeById($user_id, 47); 
            $button = '';

            if($user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {

                 $button .= '<a href="'. base_url() .'/reminders/edit/'. base64_encode($record->reminder_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Edit"><i class="fas fa-pencil-alt"></i></a>';
            }
            if($user_id == 1 || (isset($access->deleteStatus) && $access->deleteStatus == 1)) {

                 $button .= '<button class="btn btn-danger btn-sm btn-flat btn-reminder-delete btn-rms" data-id="'.$record->reminder_id.'" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button>';
            }

            $data[] = array( 
             "subject"=>$record->subject,
             "schedate"=>date('d-m-Y', strtotime($record->scheduled_date)),
             "status"=>$status,
             "createddate"=>date('d-m-Y', strtotime($record->createdDate)),
             "createdby"=>get_user($record->createdBy),
             "action"=>$button,
           );
        }

        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response;
    }
    
}