<?php
namespace App\Controllers;
use App\Models\ClientsModel;
use CodeIgniter\HTTP\RequestInterface;

class Clients extends BaseController
{
    public function __construct()
	{
	    $this->is_redirect_to_login();
	    $this->client = new ClientsModel();
	}
	public function index()
	{
	    //echo $this->user_role;
	    switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.client_admin_title');
                $this->data['clients_list'] = $this->client->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/list', $this->data);
        		echo view('admin/parts/client-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.client_admin_title');
                $this->data['clients_list'] = $this->client->where('createdBy', (int)$this->user_id)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/list', $this->data);
        		echo view('admin/parts/client-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
                $this->data['title'] = lang('Text.client_admin_title');
                $this->data['clients_list'] = $this->client->where('createdBy', (int)$this->user_id)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/list', $this->data);
        		echo view('admin/parts/client-list-footer');
        }
	}
	
	public function add()
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.client_add_admin_title');
                $this->data['country_list'] = $this->client->list_country();
                //$this->data['company_list'] = $this->client->list_company();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script');
                break;
            case 2:
                $this->data['title'] = lang('Text.client_add_admin_title');
                $this->data['country_list'] = $this->client->list_country();
                //$this->data['company_list'] = $this->client->list_company();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               //echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function edit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	   $this->data['client_id'] =  $id;
    	   //$clientid = base64_decode($id);
    	   switch ($this->user_role) {
                case 1:
                    $this->data['title'] = lang('Text.client_edit_admin_title');
                    $this->data['country_list'] = $this->client->list_country();
                    //$this->data['company_list'] = $this->client->list_company();
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['client_row'] = $this->client->row_client($id);
                    echo view('admin/parts/client-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/clients/edit', $this->data);
            		echo view('admin/parts/client-form-footer');
            		echo view('admin/clients/script');
                    break;
                case 2:
                    $this->data['title'] = lang('Text.client_edit_admin_title');
                    $this->data['country_list'] = $this->client->list_country();
                    //$this->data['company_list'] = $this->client->list_company();
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['client_row'] = $this->client->row_client($id);
                    echo view('admin/parts/client-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/clients/edit', $this->data);
            		echo view('admin/parts/client-form-footer');
            		echo view('admin/clients/script');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   //echo "i is not equal to 0, 1 or 2";
            } 
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function clients_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'country' => 'required',
            //'code' => 'required|is_unique[tbl_client_m.code,id,{id}]',
            'name' => 'required|alpha_space|max_length[30]',
            'address'=> 'required|max_length[255]',
            'phone'=> 'required|numeric|max_length[15]',
            /*'company'=> 'required',*/
            'email' => 'required|valid_email|max_length[30]',
            'whatsapp'=> 'required|numeric|max_length[15]',
            'payment_term'=> 'permit_empty|numeric',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        $is_same_parent = $this->request->getPost('is_same_parent');
        $parent = $this->request->getPost('parent');
        $status = $this->request->getPost('status');
        $term = $this->request->getPost('payment_term');
        if($operation == 'Add'){
            
            $this->client->save([
				'country_id'	=>	$this->request->getPost('country'),
				/*'company_id'	=>	$this->request->getPost('company'),*/
				'code'	=>	$this->request->getPost('code'),
				'name'	   =>	$this->request->getPost('name'),
				'address'	   =>	$this->request->getPost('address'),
				'phone'	   =>	$this->request->getPost('phone'),
				'Phone2'	   =>	$this->request->getPost('phone2'),
				'email' =>	$this->request->getPost('email'),
				'whatsAppNo' =>	$this->request->getPost('whatsapp'),
				'is_same_parent' =>	(!empty($is_same_parent)) ? $is_same_parent : 0,
				'Parent_client' =>	(!empty($parent)) ? $parent : '',
				'payment_term'   => (!empty($term)) ? $term : 0,
				'status' =>	(!empty($status)) ? $status : 0,
				'createdBy' => $this->user_id,
				'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);
			echo json_encode(array('type'=>'success', 'message' => 'Client Added Suceesfully!', 'redirect'=> 'clients'));
		    exit;
            
        } else if($operation == 'Edit'){
            $clientID = $this->request->getPost('clientID');
		    $clientID = base64_decode($clientID);
		    
            
		    $data = [
	            'country_id'	=>	$this->request->getPost('country'),
	            /*'company_id'	=>	$this->request->getPost('company'),*/
				'code'	=>	$this->request->getPost('code'),
				'name'	   =>	$this->request->getPost('name'),
				'address'	   =>	$this->request->getPost('address'),
				'phone'	   =>	$this->request->getPost('phone'),
				'Phone2'	   =>	$this->request->getPost('phone2'),
				'email' =>	$this->request->getPost('email'),
				'whatsAppNo' =>	$this->request->getPost('whatsapp'),
				'is_same_parent' =>	(!empty($is_same_parent)) ? $is_same_parent : 0,
				'Parent_client' =>	(!empty($parent)) ? $parent : '',
				'payment_term'   => (!empty($term)) ? $term : 0,
				'status' =>	(!empty($status)) ? $status : 0,
				//'createdBy' => $this->user_id,
				'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$this->client->update($clientID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Client Updated Suceesfully!', 'redirect'=> 'clients'));
		    exit;
        }
	}
	
	public function delete_clients()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $clientID = $this->request->getPost('clientID');
	    $this->client->where('user_id', $clientID)->delete($clientID);
	    echo json_encode(array('type'=>'success', 'message' => 'Client Deleted Suceesfully!'));
		    exit;
	}
	public function import()
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.client_import_admin_title');
                //$this->data['company_list'] = $this->client->list_company();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/import', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script-import');
                break;
            case 2:
                $this->data['title'] = lang('Text.client_import_admin_title');
                //$this->data['company_list'] = $this->client->list_company();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/import', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script-import');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function clients_import()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		
		$input = $this->validate([
            'file' => 'uploaded[file]|max_size[file,1024]|ext_in[file,csv],'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        if($operation == 'import'){
            $file = $this->request->getFile('file');
            $file_name = $file->getTempName();
            $clients = array();
            $csv_data = array_map('str_getcsv', file($file_name));
            $csv_data_removed = array_shift($csv_data);
           // print_r($csv_data);
            if (count($csv_data) > 0) {
                
                //print_r($csv_data);
                foreach ($csv_data as $data) {
                        
                    $name = $data[0];
                    $checkrecord = $this->client->where('name',$name)->countAllResults();
                    if($checkrecord == 0){
                        $clients[] = array(
                            "country_id" => 103,
                            "name" => (isset($data[0])) ? $data[0] : '',
                            "code" => (isset($data[1])) ? $data[1] : '',
                            "address" => (isset($data[2])) ? $data[2] : '',
                            "phone" => (isset($data[3])) ? $data[3] : '',
                            "Phone2" => (isset($data[4])) ? $data[4] : '',
                            "email" => (isset($data[5])) ? $data[5] : '',
                            "whatsAppNo" => (isset($data[6])) ? $data[6] : ''
                            /*"is_same_parent" => 1,
                            "status" => 1,
                            "Parent_client" => '',
                            "createdBy" => $this->user_id,
                            "updatedBy" => 0,
				            "updatedDate" => '0000-00-00 00:00:00'*/
                        );
                    }
                    
                    
                }
                
                
                $all_countries = $this->client->list_country();
                $all_clients = $this->client->findAll();
                //print_r($all_countries);
                echo json_encode(array('type'=>'import', 'data' => $clients, 'countries' => $all_countries,'clients' => $all_clients));
		        exit;
                /*$status = $this->client->save_all_clients($clients);
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Client Batch Inserted Successfully!', 'redirect'=> 'clients'));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Client Batch Not Inserted Successfully!', 'redirect'=> 'clients'));
		           exit; 
                }*/

            } else {
                echo json_encode(array('type'=>'error', 'message' => 'Csv file is empty!', 'redirect'=> 'clients'));
		        exit;
            }
            /*if ($file->isValid() && ! $file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move(FCPATH .'public/csvfile', $newName);
               
                 // Reading file
               $file = fopen(FCPATH .'public/csvfile'.$newName,"r");
               $i = 0;
               $numberOfFields = 4; // Total number of fields
               exit;
               $importData_arr = array();
               while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                   $num = count($filedata);

                  // Skip first row & check number of fields
                  if($i > 0 && $num == $numberOfFields){ 
                     
                     // Key names are the insert table field names - name, email, city, and status
                     $importData_arr[$i]['country_id'] = $filedata[0];
                     $importData_arr[$i]['name'] = $filedata[1];
                     $importData_arr[$i]['code'] = $filedata[2];
                     $importData_arr[$i]['address'] = $filedata[3];
                     $importData_arr[$i]['phone'] = $filedata[4];
                     $importData_arr[$i]['phone2'] = $filedata[5];
                     $importData_arr[$i]['email'] = $filedata[6];
                     $importData_arr[$i]['whatsapp'] = $filedata[7];

                  }

                  $i++;
               }
               fclose($file);
               // Insert data
               print_r($importData_arr);
            } else {
                //file not imported
            }*/
        }
	}
	
	public function ajax_clients_import()
	{
	    
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
		    /*'company' => 'required',*/
            'selCountry.*' => 'required',
            'client_name.*' => 'required',
            'client_code.*' => 'required',
            'client_address.*' => 'required',
            'client_phone.*' => 'required',
            'client_email.*' => 'required',
        ],
        [   // Errors
            'selCountry.*' => [
                'required' => 'Country fields should not be empty!',
            ],
            'client_name.*' => [
                'required' => 'Client Name fields should not be empty!',
            ],
            'client_code.*' => [
                'required' => 'Client code fields should not be empty!',
            ],
            'client_address.*' => [
                'required' => 'Client Address fields should not be empty!',
            ],
            'client_phone.*' => [
                'required' => 'Phone fields should not be empty!',
            ],
            'client_email.*' => [
                'required' => 'Email fields should not be empty!',
            ]
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        //print_r($_POST);
         $operation = $this->request->getPost('operation');
        if($operation == 'importajax'){
            $client_code = $this->request->getPost('client_code');
            /*$company_id = $this->request->getPost('company');client_name*/
            if (count($client_code) > 0){
                 $loop = count($client_code);
                 $clients = array();
                 for ($i = 0; $i < $loop; $i++ ){
                     $parent = $_POST['selclient'][$i];
                     $clients[] = array(
                            "country_id" => $_POST['selCountry'][$i],
                            /*"company_id" => $company_id,*/
                            "name" => $_POST['client_name'][$i],
                            "code" => $_POST['client_code'][$i],
                            "address" => $_POST['client_address'][$i],
                            "phone" => $_POST['client_phone'][$i],
                            "Phone2" => $_POST['client_phone2'][$i],
                            "email" => $_POST['client_email'][$i],
                            "whatsAppNo" => $_POST['client_whatsapp'][$i],
                            "is_same_parent" => (!empty($parent)) ? 0 : 1,
                            "status" => 1,
                            "Parent_client" => $parent,
                            "createdBy" => $this->user_id,
                            "updatedBy" => 0,
				            "updatedDate" => '0000-00-00 00:00:00'
                        );
                 }
                // print_r($clients);exit;
                $status = $this->client->save_all_clients($clients);
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Client Batch Inserted Successfully!', 'redirect'=> 'clients'));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Client Batch Not Inserted Successfully!', 'redirect'=> 'clients'));
		           exit; 
                }
            }
            
        }
	}
	public function downloadsample()
	{
	    $url = FCPATH.'public/csvfile/Sample-Spreadsheet-client.csv';
	    $file_name = basename($url); 
	    $info = pathinfo($file_name);
	    if ($info["extension"] == "csv") {
      
            /* Use file_get_contents() function
            to get the file from url and use 
            file_put_contents() function to save
            the file by using base name */   
           /*if(file_put_contents( $file_name, 
                file_get_contents($url))) { 
                echo "File downloaded successfully";
            }
            else { 
                echo "File downloading failed."; 
            }*/
            /* Informing the browser that
            the file type of the concerned
             file is a MIME type (Multipurpose
            Internet Mail Extension type).
            Hence, no need to play the file
             but to directly download it on
            the client's machine. */
            header("Content-Description: File Transfer"); 
            header("Content-Type: application/octet-stream"); 
            header(
            "Content-Disposition: attachment; filename=\""
            . $file_name . "\""); 
            ob_clean();
            flush();
            readfile($url);
        }
	}
}