<?php

namespace App\Controllers;
use App\Models\AuthModel;
use App\Models\UsersModel;
use App\Models\TemplateModel;
use CodeIgniter\Controller;

class Home extends BaseController
{
	public function index()
	{
	    helper("cookie");
	    //echo get_cookie("member_login");
	    $model = new AuthModel();
		return view('login');
	}
	
	public function forgotpassword()
	{
	    return view('forgot-password');
	}
	
	public function send_forgot_password_email()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'email' => 'required',
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $email = $this->request->getPost('email');
        $model = new UsersModel();
        $checkRecord = $model->where('email',$email)->first();
        if(!empty($checkRecord))
        {
            //print_r($checkRecord);
            //TemplateModel
            $templatemodel = new TemplateModel();
            $template_info = $templatemodel->where('slug', 'forgot_password')->first();
            if ($model->mail_updated_at($checkRecord['user_id'])){
                $to = $email;
                $subject = (isset($template_info['subject']) && !empty($template_info['subject'])) ? $template_info['subject'] : 'Reset Password Link
';
                $token = $checkRecord['user_id'];
                $message = sprintf($template_info['template'],$checkRecord['userName']);
                $message .= '<p><a href="'.base_url().'/reset-password/'.base64_encode($token).'">Reset Password</a><p><br><br>';
                /*$message = 'Hi '.$checkRecord['userName'].'<br><br>'
                            .'Your Reset Password request has been received.'
                            .'Please click the below link to reset your password.<br><br>'
                            .'<a href="'.base_url().'/reset-password/'.base64_encode($token).'">Reset Password</a><br><br>';*/
                $image = (isset($template_info['image']) && !empty($template_info['image'])) ? base_url().$template_info['image'] :'';
                $template = $this->template_register($message, $image);
                
                if($this->send_email_rms($to, $subject, $template, $image)){
                    $type    = 'success';
			        $message = 'Reset passsword link sent to your registered email. Please verify with it in 30 min';
                    echo json_encode(array('type'=>$type, 'message' => $message));
		            exit;
                } else {
                    $type    = 'error';
			        $message = 'Something wrong!! Email not sent.';
                    echo json_encode(array('type'=>$type, 'message' => $message));
		            exit;
                }
            } else {
                $type    = 'error';
			    $message = 'Sorry ! Unable to update. Try again';
                echo json_encode(array('type'=>$type, 'message' => $message));
		        exit; 
            }
        } else {
            $type    = 'error';
			$message = 'Email not exist';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
	}
	public function check_expiry_token($time)
	{
	    $update_time = strtotime($time);
	    $current_time = time();
	    $timediff = $current_time - $update_time;
	    
	    if ($timediff < 1800){
	       return TRUE; 
	    } else {
	        return FALSE;
	    }
	    
	}
	public function reset_password($token)
	{
	    //echo $token;exit;
	   if (empty($token)){
	       throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	   } 
	   $model = new UsersModel();
	   $user_id = base64_decode($token);
	   $user_data = $model->where('user_id',$user_id)->first();
	   //print_r($user_data);
	   if (!empty($user_data)){
	       $this->data['token'] = $token;
	       if($this->check_expiry_token($user_data['mail_sent_at'])){
	          return view('recover-password', $this->data); 
	       } else {
	           return view('token-expired');
	      }
	       
	   } else {
	       //show unauthorized screen
	       throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	   }
	   
	}
	
	public function reset_password_process()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		//$validation =  \Config\Services::validation();
		$input = $this->validate([
            'password' => 'required|min_length[5]',
            'cpassword' => 'required|matches[password]'
        ]);
        
        //print_r($input);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $password = $this->request->getPost('password');
        $token = $this->request->getPost('token');
        $userid = base64_decode($token);
        $model = new UsersModel();
        if ($model->update($userid, ['password' => md5($password)])){
            $type    = 'success';
			$message = 'Password resetted successfully.';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        } else {
            $type    = 'error';
			$message = 'Something wrong!! Pasword noy reset.';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
	}
	
	public function auth_process()
	{
	    //$request->getPost()
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		//$validation =  \Config\Services::validation();
		$input = $this->validate([
            'email' => 'required|min_length[5]',
            'password' => 'required|min_length[5]'
        ]);
        
        //print_r($input);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $email = $this->request->getPost('email');
		$password = $this->request->getPost('password');
		$remem = $this->request->getPost('remember') ;
	    $model = new AuthModel();
		$login_status = $model->check_login($email, $password);
		if ($login_status) {
		    helper("cookie");
		    if(!empty($remem)) {
               
                set_cookie("member_login", trim($email), 3600);
                set_cookie("member_pass", trim($password), 3600);
                
                //echo get_cookie("member_login");
            } else {
                //if(has_cookie('member_login')){
                    delete_cookie("member_login");
                    delete_cookie("member_pass");
               // }
                
                 
            }
			$type    = 'success';
			$message = ($model->geterrors()) ? $model->geterrors() : '';
		} else {
			$type    = 'error';
			$message = ($model->geterrors()) ? $model->geterrors() : 'Something went wrong';
		}
		echo json_encode(array('type'=>$type, 'message' => $message));
		exit;
	}
    public function logout()
    {
        $this->session->destroy();
        header("Location:".base_url());
        exit;
    }
}
