<?php
namespace App\Controllers;
use App\Models\MasterModel;
use App\Models\UsertypeModel;
use App\Models\CompanyModel;
use App\Models\UsersModel;
use App\Models\SalesmanModel;
use App\Models\FyearModel;
use App\Models\CurrencyModel;
use App\Models\SettingsModel;
use App\Models\PermissionModel;
use App\Models\FollowupModel;
use App\Models\FollowupdetailsModel;

use App\Models\UsersproductModel;//connecting default(master db)


class Masters extends BaseController
{
    protected $model;
     public function __construct()
	{
	    $this->is_redirect_to_login();
	    $this->redirect_to_dashboard_if_not_admin_role();
	    $this->model = new MasterModel();
	    $this->followup = new FollowupModel();
	    $this->details = new FollowupdetailsModel();
	    
	}
	public function index()
	{
	    /*echo view('admin/parts/header');
	    echo view('admin/parts/nav');
		echo view('admin/dashboard');
		echo view('admin/parts/footer');*/
	}
	
	public function company()
	{
	    //print_r($this->data);
	    $this->data['title'] = lang('Text.masters_company_title');
	    $this->data['company_list'] = $this->model->list_company();
	    //print_r($data);
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/company/list', $this->data);
		echo view('admin/parts/list-footer', $this->data);
	}
	
	public function companyadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 1);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	       
    	    $this->data['title'] = lang('Text.masters_company_add_title');
    	    $this->data['country_list'] = $this->model->list_country();
    	    $this->data['company_parent'] = $this->model->list_parent_company();
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/company/add', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/company/script');
	    } else {
	         throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    
	    }
	}
	
	public function companyedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 1);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {

    	    $this->data['title'] = lang('Text.masters_company_edit_title');
    	    $this->data['company_id'] = $id;
    	    $this->data['company_row'] = $this->model->row_company($id);
    	    $this->data['country_list'] = $this->model->list_country();
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/company/edit', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/company/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
		
	}
	
	public function company_ajax(){
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		$input = $this->validate([
            'country' => 'required',
            'company_name' => 'required|alpha_space|max_length[100]',
            'company_address' => 'required|max_length[200]',
            'phone_number1' => 'required|numeric|max_length[15]',
            'phone_number2' => 'permit_empty|numeric|max_length[15]',
            'company_email' => 'required|valid_email|max_length[100]',
            'company_gst' => 'permit_empty|alpha_numeric_space|max_length[30]',
            'company_vat' => 'permit_empty|alpha_numeric_space|max_length[30]',
            'company_status' => 'permit_empty',
            /*'company_logo' => [
                'uploaded[company_logo]',
                'max_size[file,1024]',
            ]*/
        ]);
        
        if (!$input) {
             $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        
        $companyModel = new CompanyModel();
        $parent = $this->request->getPost('parent');
        $status = $this->request->getPost('company_status');
        if($parent == 1){
            $companyModel->update_company_type_to_branch();
        }
        if($operation == 'Add'){
            $img = $this->request->getFile('company_logo');
		    $file_name = $img->getTempName();
		    $logo = '';
		    if(!empty($file_name)){
		        $newName = $img->getRandomName();
                $img->move(FCPATH . 'public/uploads', $newName);
                $logo =  '/public/uploads/'.$img->getName();
                
                //$data['logo'] = $logo;
		    }
            //print_r($logo);
            $companyModel->save([
				'country_id'	=>	$this->request->getPost('country'),
				'companyName'	=>	$this->request->getPost('company_name'),
				'logo'	        =>	$logo,
				'companyAddress' =>	$this->request->getPost('company_address'),
				'phoneNo' =>	$this->request->getPost('phone_number1'),
				'phoneNo2' =>	$this->request->getPost('phone_number2'),
				'email' =>	$this->request->getPost('company_email'),
				'GstNo' =>	$this->request->getPost('company_gst'),
				'VatNo' =>	$this->request->getPost('company_vat'),
				'parent' =>	(!empty($parent)) ? $parent : 0,
				'status' =>	(!empty($status)) ? $status : 0
			]);
			//print_r($this->db->error());
			echo json_encode(array('type'=>'success', 'message' => 'Company Added Suceesfully!', 'redirect'=> 'masters/company'));
		    exit;
            
        } else if($operation == 'Edit'){
            $compID = $this->request->getPost('compID');
		    $compID = base64_decode($compID);
		    
		    $data = [
	            'country_id'	=>	$this->request->getPost('country'),
				'companyName'	=>	$this->request->getPost('company_name'),
				'companyAddress' =>	$this->request->getPost('company_address'),
				'phoneNo' =>	$this->request->getPost('phone_number1'),
				'phoneNo2' =>	$this->request->getPost('phone_number2'),
				'email' =>	$this->request->getPost('company_email'),
				'GstNo' =>	$this->request->getPost('company_gst'),
				'VatNo' =>	$this->request->getPost('company_vat'),
				'parent' =>	(!empty($parent)) ? $parent : 0,
				'status' =>	(!empty($status)) ? $status : 0
	        ];
	        
		    $img = $this->request->getFile('company_logo');
		    $file_name = $img->getTempName();
		    if(!empty($file_name)){
		        $newName = $img->getRandomName();
                $img->move(FCPATH . 'public/uploads', $newName);
                $logo =  '/public/uploads/'.$img->getName();
                
                $data['logo'] = $logo;
		    }
		    
            
		    
	 
        	$companyModel->update($compID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Company Updated Suceesfully!', 'redirect'=> 'masters/company'));
		    exit;
        }
        
	}
	
	public function delete_company()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $compID = $this->request->getPost('compID');
	    $checkRecord = $this->followup->where('company_id',$compID)->countAllResults();

	    if ($checkRecord > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this branch, as you have already entered invoice / follow-up / collection details!'));
            exit;
        } else {
            $companyModel = new CompanyModel();
	        $companyModel->where('company_id', $compID)->delete($compID);
	        echo json_encode(array('type'=>'success', 'message' => 'Company Deleted Suceesfully!'));
		    exit;
        }
	    
	}
	
	public function usertypes()
	{
	    $this->data['title'] = lang('Text.masters_user_type_title');
	    $this->data['usertype_list'] = $this->model->list_usertypes();
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/usertypes/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	
	public function usertypesadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 6);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_user_type_add_title');
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/usertypes/add');
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/usertypes/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }

	}
	
	public function usertypesedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 6);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_user_type_edit_title');
    	    $this->data['usertype_id'] = $id;
    	    $this->data['usertype_row'] = $this->model->row_usertypes($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/usertypes/edit', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/usertypes/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function usertype_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'usertype' => 'required|alpha_space|max_length[20]',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
		$usertype = $this->request->getPost('usertype');
		$status = $this->request->getPost('status');
		$operation = $this->request->getPost('operation');
		
		$usertypeModel = new UsertypeModel();
		
		if($operation == 'Add'){
		   $usertypeModel->save([
				'userType'	=>	$usertype,
				'status'	=>	(!empty($status)) ? $status : 0
			]);
			echo json_encode(array('type'=>'success', 'message' => 'User Type Added Suceesfully!', 'redirect'=> 'masters/usertypes'));
		    exit;
		} else if($operation == 'Edit'){
		    $typeID = $this->request->getPost('typeID');
		    $typeID = base64_decode($typeID);
		    $data = [
	            'userType'	=>	$usertype,
				'status'	=>	(!empty($status)) ? $status : 0
	        ];
	 
        	$usertypeModel->update($typeID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'User Type Updated Suceesfully!', 'redirect'=> 'masters/usertypes'));
		    exit;
		}
	}
	
    public function delete_usertypes()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $typeID = $this->request->getPost('typeID');

	    $usermodel = new UsersModel();
	    $checkRecord = $usermodel->where('userType_id',$typeID)->countAllResults();

	    if ($checkRecord > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this type, as you have already entered users!'));
            exit;
        } else {
        	$usertypeModel = new UsertypeModel();
	    	$usertypeModel->where('userType_id', $typeID)->delete($typeID);
	    	echo json_encode(array('type'=>'success', 'message' => 'User Type Deleted Suceesfully!'));
		    exit;
        }	    
	}
	
	public function users_permissions()
	{
	    $this->data['title'] = lang('Text.masters_users_title');
	    $this->data['users_list'] = $this->model->list_users_have_login();
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/permissions/list', $this->data);
		echo view('admin/parts/list-footer'); 
	}
	public function permissions($id=null)
	{
	    if (empty($id)) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		$access = getUserPrivilegeById($this->user_id, 9);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1) || (isset($access->addStatus) && $access->addStatus == 1)) {
		
    		$this->data['userid'] = base64_decode($id);
    	    $this->data['title'] = lang('Text.masters_permissions_title');
    	    $this->data['modules'] = $this->model->list_modules();
    	    //echo "<pre>";
    	    //print_r($this->data['modules']);
    	    echo view('admin/parts/list-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/permissions/add', $this->data);
    		echo view('admin/parts/list-footer');
    		echo view('admin/masters/permissions/script', $this->data);
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function permissions_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		
      
		$type = $this->request->getPost('type');
		$user_id = $this->request->getPost('user_id');
		$smodule = $this->request->getPost('smodule');
		$pvalue = $this->request->getPost('pvalue');
		//$exist = $this->request->getPost('exist');
		
		$pModel = new PermissionModel();
		
		//checkexist
		$exist = $pModel->where('user_id', $user_id)->where('sub_module_id', $smodule)->first();
		if(!empty($exist)){ // update value
		    if($type == 'add'){
		        $data = [
    	            'addStatus'	=>	$pvalue,
    	        ];
		    } else if($type == 'edit'){
		        $data = [
    	            'editStatus'	=>	$pvalue,
    	        ];
		    } else if($type == 'delete'){
		        $data = [
    	            'deleteStatus'	=>	$pvalue,
    	        ];
		    }
		    
	 
        	$pModel->updatePrivilege($data, $user_id, $smodule);
        	echo json_encode(array('type'=>'success', 'message' => 'Permission Updated Suceesfully!'));
		    exit;
		   
		} else{ // add value
		
		    if($type == 'add'){
		        $data = [
		            'user_id'	=>	$user_id,
		            'sub_module_id'	=>	$smodule,
		            'status'	=>	1,
    	            'addStatus'	=>	$pvalue,
    	            'editStatus' =>	0,
    	            'deleteStatus' =>	0,
    	        ];
		    } else if($type == 'edit'){
		        $data = [
		            'user_id'	=>	$user_id,
		            'sub_module_id'	=>	$smodule,
		            'status'	=>	1,
    	            'addStatus'	=>	0,
    	            'editStatus'	=>	$pvalue,
    	            'deleteStatus' =>	0,
    	        ];
		    } else if($type == 'delete'){
		        $data = [
		            'user_id'	=>	$user_id,
		            'sub_module_id'	=>	$smodule,
		            'status'	=>	1,
    	            'addStatus'	=>	0,
    	            'editStatus'	=>	0,
    	            'deleteStatus'	=>	$pvalue,
    	        ];
		    }
		    
		   $pModel->save($data);
			echo json_encode(array('type'=>'success', 'message' => 'Permission Added Suceesfully!'));
		    exit;
		}
	}
	
	public function users()
	{
	    $this->data['title'] = lang('Text.masters_users_title');
	    $this->data['users_list'] = $this->model->list_users(1);
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/users/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	
	public function usersadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 7);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_users_add_title');
    	    $this->data['usertype_list'] = $this->model->list_active_usertypes(1);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/users/add', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/users/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function usersedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 7);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_users_edit_title');
    	    $this->data['users_id'] = $id;
    	    $this->data['usertype_list'] = $this->model->list_active_usertypes(1);
    	    $this->data['user_row'] = $this->model->row_user($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/users/edit', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/users/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function users_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'usertype_id' => 'required',
            'user_name' => 'required|alpha_numeric|min_length[5]|max_length[30]|is_unique[tbl_user_m.userName,id,{id}]',
            'password' => 'required|min_length[5]',
            'email' => 'required|valid_email|max_length[30]',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        $password = $this->request->getPost('password');
        $status = $this->request->getPost('status');
        $usersModel = new UsersModel();
        //$usersprodModel = new UsersproductModel();
        if($operation == 'Add'){
            
            $usersModel->insert([
				'userType_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	$this->request->getPost('user_name'),
				'password'	   =>	md5($password),
				'email' =>	$this->request->getPost('email'),
				'isActive' =>	(!empty($status)) ? $status : 0,
				'loginStatus' => 1,
				'createdBy' => $this->user_id,
				'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);

			/*$product_app_user_id = $usersModel->getInsertID();

			$usersprodModel->insert([
				'product_id'	=>	$this->master_product_id,
				'product_app_user_id'	=>	$product_app_user_id,
				'product_app_usertype_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	$this->request->getPost('user_name'),
				'password'	   =>	md5($password),
				'email' =>	$this->request->getPost('email'),
				'isActive' =>	(!empty($status)) ? $status : 0,
				'loginStatus' => 1,
				//'createdBy' => $this->user_id,
				//'updatedBy' => 0,
				//'updatedDate' => '0000-00-00 00:00:00'
			]);*/

			echo json_encode(array('type'=>'success', 'message' => 'User Added Suceesfully!', 'redirect'=> 'masters/users'));
		    exit;
            
        } else if($operation == 'Edit'){
            $userId = $this->request->getPost('userId');
		    $userId = base64_decode($userId);
		    
            
		    $data = [
	            'userType_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	$this->request->getPost('user_name'),
				'password'	   =>	md5($password),
				'email' =>	$this->request->getPost('email'),
				'isActive' =>	(!empty($status)) ? $status : 0,
				//'loginStatus' => 1,
				//'createdBy' => $this->user_id,
				'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$usersModel->update($userId, $data);

        	/*$data1 = [
	            'product_app_usertype_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	$this->request->getPost('user_name'),
				'password'	   =>	md5($password),
				'email' =>	$this->request->getPost('email'),
				'isActive' =>	(!empty($status)) ? $status : 0,
				//'loginStatus' => 1,
				//'createdBy' => $this->user_id,
				//'updatedBy' => $this->user_id,
				//'updatedDate' => date('Y-m-d H:i:s')
	        ];

	        $produser = $usersprodModel->where('product_app_user_id',$userId)->where('product_id',$this->master_product_id)->first();
	        $userprodId = $produser['login_user_id'];
	        $usersprodModel->update($userprodId, $data1);*/
        	echo json_encode(array('type'=>'success', 'message' => 'User Updated Suceesfully!', 'redirect'=> 'masters/users'));
		    exit;
        }
	}
	
	public function delete_users()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $userID = $this->request->getPost('userID');
	    $usersModel = new UsersModel();
	    $checkRecord = $usersModel->where('createdBy',$userID)->countAllResults();
	    $checkRecord1 = $usersModel->where('updatedBy',$userID)->countAllResults();
	    $salesmanModel = new SalesmanModel();
	    $checkRecord2 = $salesmanModel->where('createdBy',$userID)->countAllResults();
	    $checkRecord3 = $this->followup->where('createdBy',$userID)->countAllResults();
	    if ($checkRecord > 0 || $checkRecord1 > 0 || $checkRecord2 > 0 || $checkRecord3 > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this user, as he associated with some other records!'));
            exit;
        } else {
            $usersModel->where('user_id', $userID)->delete($userID);
	        echo json_encode(array('type'=>'success', 'message' => 'User Deleted Suceesfully!'));
		    exit;
        }
	    
	}
	
	public function salesman()
	{
	    $this->data['title'] = lang('Text.masters_salesman_title');
	    $this->data['users_list'] = $this->model->list_users_sales(2);
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/salesman/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	
	public function salesmanadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 8);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_salesman_add_title');
    	    $this->data['usertype_list'] = $this->model->list_active_usertypes(2);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/salesman/add', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/salesman/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesmanedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 8);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_salesman_edit_title');
    	    $this->data['users_id'] = $id;
    	    $this->data['usertype_list'] = $this->model->list_active_usertypes(2);
    	    $this->data['user_row'] = $this->model->row_suser($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/salesman/edit', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/salesman/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function salesman_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
		    'name' => 'required',
            'usertype_id' => 'required',
            'user_name' => 'permit_empty|alpha_numeric|min_length[5]|max_length[30]|is_unique[tbl_user_m.userName,id,{id}]',
            'password' => 'permit_empty|min_length[5]',
            'email' => 'permit_empty|valid_email|max_length[30]',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        $loginsta = $this->request->getPost('create_login');
        
        $password = $this->request->getPost('password');
        $user_name = $this->request->getPost('user_name');
        $email = $this->request->getPost('email');
        $status = $this->request->getPost('status');
        //SalesmanModel
        $salesmanModel = new SalesmanModel();
        if($operation == 'Add'){
            
            $users_data =[
				'userType_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	(!empty($user_name)) ? $user_name : '',
				'password'	   => (!empty($password)) ?	md5($password) : '',
				'email' =>	(!empty($email)) ? $email : '',
				'isActive' =>	(!empty($status)) ? $status : 0,
				'loginStatus' => (!empty($loginsta)) ? $loginsta : 0,
				'createdBy' => $this->user_id,
				'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			];
			
			$userid = $salesmanModel->insert_user_data($users_data);
			
			if ($userid > 0){
			    $salesmanModel->save([
    				'sales_man_name'	=>	$this->request->getPost('name'),
    				'user_id'	   =>	$userid,
    				'status' =>	$this->request->getPost('status')
    			]);
    			
    			echo json_encode(array('type'=>'success', 'message' => 'Salesman Added Suceesfully!', 'redirect'=> 'masters/salesman'));
		        exit;
			} else {
			    echo json_encode(array('type'=>'error', 'message' => 'Salesman Not Added Suceesfully!', 'redirect'=> 'masters/salesman'));
		        exit;
			}
			
			
            
        } else if($operation == 'Edit'){
            $userId = $this->request->getPost('userId');
		    $userId = base64_decode($userId);
		    
            
		    $users_data = [
	            'userType_id'	=>	$this->request->getPost('usertype_id'),
				'userName'	=>	(!empty($user_name)) ? $user_name : '',
				'password'	   => (!empty($password)) ?	md5($password) : '',
				'email' =>	(!empty($email)) ? $email : '',
				'isActive' =>	(!empty($status)) ? $status : 0,
				'loginStatus' => (!empty($loginsta)) ? $loginsta : 0,
				//'createdBy' => $this->user_id,
				'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	        
	        $sta = $salesmanModel->update_user_data($users_data, $userId);
	        
	        //if($sta){
	            $data = [
    	            'sales_man_name'	=>	$this->request->getPost('name'),
    				'status' =>	$this->request->getPost('status')
    	        ];
	            $salesmanModel->update_sales_man($userId, $data);
            	echo json_encode(array('type'=>'success', 'message' => 'Salesman Updated Suceesfully!', 'redirect'=> 'masters/salesman'));
    		    exit; 
	        /*} else {
			    echo json_encode(array('type'=>'error', 'message' => 'Salesman Not Updated Suceesfully!', 'redirect'=> 'masters/salesman'));
		        exit;
			}*/
        }
	}
	
	public function delete_susers()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $userID = $this->request->getPost('userID');
	    $salesmanModel = new SalesmanModel();
	    $sales = $salesmanModel->where('user_id', $userID)->first();
	    $checkRecord = $this->followup->where('salesman_id',$sales['salesman_id'])->countAllResults();

	    $checkRecord1 = $this->details->where('salesman_id',$sales['salesman_id'])->countAllResults();
        
	    if ($checkRecord > 0 || $checkRecord1 > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this user, as he has already entered invoices!'));
            exit;
        } else {
            /*$salesmanModel = new SalesmanModel();*/
	        $salesmanModel->where('user_id', $userID)->delete($userID);
	        $usersModel = new UsersModel();
	        $usersModel->where('user_id', $userID)->delete($userID);
	        echo json_encode(array('type'=>'success', 'message' => 'Salesman Deleted Suceesfully!'));
		    exit;
        }
	    
	}
	public function financialyear()
	{
	    $this->data['title'] = lang('Text.masters_fyear_title');
	    $this->data['fyear_list'] = $this->model->list_financialyears();
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/fyear/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	public function financialyearadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 2);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_fyear_add_title');
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/fyear/add');
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/fyear/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function financialyearedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 2);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_fyear_edit_title');
    	    $this->data['fyear_id'] = $id;
    	    $this->data['fyear_row'] = $this->model->row_fyear($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/fyear/edit', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/fyear/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function financial_year_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'start_date' => 'required',
            'end_date' => 'required',
            'year' => 'required|is_unique[tbl_financialYear_m.financialYear,id,{id}]',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
		
		$operation = $this->request->getPost('operation');
		$start_date = $this->request->getPost('start_date');
		$end_date = $this->request->getPost('end_date');
		$statuss = $this->request->getPost('status');
		$fyearModel = new FyearModel();
		if($statuss == 1){
		    //inactive other rows
		    $res = $fyearModel->inactive_status();
		}
		if($operation == 'Add'){
		   $fyearModel->save([
				'startDate' => date('Y-m-d', strtotime($start_date)),
                'endDate' => date('Y-m-d', strtotime($end_date)),
                'financialYear' => $this->request->getPost('year'),
                'createdBy' => $this->user_id,
                'status' => (!empty($statuss)) ? $statuss : 0,
                'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);
			
			echo json_encode(array('type'=>'success', 'message' => 'Financial year Added Suceesfully!', 'redirect'=> 'masters/financialyear'));
		    exit;
		} else if($operation == 'Edit'){
		    $fID = $this->request->getPost('fID');
		    $fID = base64_decode($fID);
		    $data = [
	            'startDate' => date('Y-m-d', strtotime($start_date)),
                'endDate' => date('Y-m-d', strtotime($end_date)),
                'financialYear' => $this->request->getPost('year'),
                'status' => (!empty($statuss)) ? $statuss : 0,
                'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$fyearModel->update($fID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Financial year Updated Suceesfully!', 'redirect'=> 'masters/financialyear'));
		    exit;
		}
	}
	
	public function delete_financial_year()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $fID = $this->request->getPost('fID');
	    $checkRecord = $this->followup->where('financial_year_id',$fID)->countAllResults();

	    if ($checkRecord > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this year, as you have already entered invoice / follow-up / collection details!'));
            exit;
        } else {
        	$fyearModel = new FyearModel();
	    	$fyearModel->where('financialYear_id', $fID)->delete($fID);
	    
	    	echo json_encode(array('type'=>'success', 'message' => 'Salesman Deleted Suceesfully!'));
		    exit;
        }
	}
	public function settings()
	{
	    $access = getUserPrivilegeById($this->user_id, 3);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1) || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_settings_title');
    	    $this->data['settings_id'] = 1;
    	    $this->data['currency_list'] = $this->model->list_currency_active();
    	    $this->data['settings_row'] = $this->model->row_settings(1);
    	    $this->data['settings_email_id'] = 1;
    	    $this->data['settings_row_email'] = $this->model->row_settings_email(1);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/settings/list', $this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/settings/script');
	    } else {
	       throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return; 
	    }
	}
	public function settings_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'fcurrency' => 'required',
            'licenseNo' => 'required',
            'licenseExpiryDate' => 'required',
            'followupReminderDays' => 'required|numeric',
            'licenseExpiryReminderDays'=> 'required|numeric'
        ]);
        
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
		
		$operation = $this->request->getPost('operation');
		$licenseExpiryDate = $this->request->getPost('licenseExpiryDate');
		
		$settingsModel = new SettingsModel();
		
		if($operation == 'Edit'){
		    $settings_id = $this->request->getPost('settings_id');
		    //$fID = base64_decode($fID);
		    $data = [
	            'functionalCurrency_id' => $this->request->getPost('fcurrency'),
                'licenseExpiryDate' => date('Y-m-d', strtotime($licenseExpiryDate)),
                'licenseNo' => $this->request->getPost('licenseNo'),
                'followupReminderDays' => $this->request->getPost('followupReminderDays'),
                'licenseExpiryReminderDays' => $this->request->getPost('licenseExpiryReminderDays'),
	        ];
	 
        	$settingsModel->update($settings_id, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Settings Updated Suceesfully!', 'redirect'=> 'masters/settings'));
		    exit;
		}
	}
	
	public function settings_email_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'host' => 'required|max_length[100]',
            'port' => 'required|numeric',
            'username' => 'required|max_length[100]',
            'password' => 'required|max_length[100]',
            'fromname'=> 'required|max_length[100]',
            'fromemail'=> 'required|valid_email|max_length[100]',
        ]);
        
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
		
		$operation = $this->request->getPost('operation');
		$settingsModel = new SettingsModel();
		
		if($operation == 'Edit'){
		    $settings_id = $this->request->getPost('settings_id');
		    //$fID = base64_decode($fID);
		    $data = [
	            'host' => $this->request->getPost('host'),
	            'port' => $this->request->getPost('port'),
                'username' => $this->request->getPost('username'),
                'password' => $this->request->getPost('password'),
                'fromname' => $this->request->getPost('fromname'),
                'fromemail' => $this->request->getPost('fromemail'),
	        ];
	 
        	$settingsModel->updateEmailSettings($settings_id, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Email Settings Updated Suceesfully!', 'redirect'=> 'masters/settings'));
		    exit;
		}
	}
	/*public function settingsadd()
	{
	    echo view('admin/parts/form-header');
	    echo view('admin/parts/nav');
		echo view('admin/masters/settings/add');
		echo view('admin/parts/form-footer');
	}
	
	public function settingsedit()
	{
	    echo view('admin/parts/form-header');
	    echo view('admin/parts/nav');
		echo view('admin/masters/settings/edit');
		echo view('admin/parts/form-footer');
	}*/
	
	public function currency()
	{
	    $this->data['title'] = lang('Text.masters_currency_title');
	    $this->data['currency_list'] = $this->model->list_currency();
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/currency/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	
	public function currencyadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 4);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	    $this->data['title'] = lang('Text.masters_currency_add_title');
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/currency/add');
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/currency/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function currencyedit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 4);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_currency_edit_title');
    	    $this->data['currency_id'] = $id;
    	    $this->data['currency_row'] = $this->model->row_currency($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/currency/edit',$this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/currency/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function currency_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'name' => 'required',
            'code' => 'required',
            'symbol' => 'required',
            'rate' => 'required',
            'rate_date' => 'required',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
		
		
		$operation = $this->request->getPost('operation');
		$rate_date = $this->request->getPost('rate_date');
		$status = $this->request->getPost('status');
		$currencyModel = new CurrencyModel();
		
		if($operation == 'Add'){
		   $currencyModel->save([
		        'name' => $this->request->getPost('name'),
		        'code'=> $this->request->getPost('code'),
		        'symbol'=> $this->request->getPost('symbol'),
		        'rate'=> $this->request->getPost('rate'),
				'rateDate' => date('Y-m-d', strtotime($rate_date)),
                'createdBy' => $this->user_id,
                'status' => (!empty($status)) ? $status : 0,
                'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);
			
			echo json_encode(array('type'=>'success', 'message' => 'Currency Added Suceesfully!', 'redirect'=> 'masters/currency'));
		    exit;
		} else if($operation == 'Edit'){
		    $curID = $this->request->getPost('curID');
		    $curID = base64_decode($curID);
		    $data = [
	            'name' => $this->request->getPost('name'),
		        'code'=> $this->request->getPost('code'),
		        'symbol'=> $this->request->getPost('symbol'),
		        'rate'=> $this->request->getPost('rate'),
				'rateDate' => date('Y-m-d', strtotime($rate_date)),
                'status' => (!empty($status)) ? $status : 0,
                'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$currencyModel->update($curID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Currency Updated Suceesfully!', 'redirect'=> 'masters/currency'));
		    exit;
		}
	}
	
	public function delete_currency()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $curID = $this->request->getPost('curID');
	    $checkRecord = $this->followup->where('currency_id',$curID)->countAllResults();
	    if ($checkRecord > 0){
            echo json_encode(array('type'=>'error', 'message' => 'You cannot delete this currency, as you have already entered invoice / follow-up / collection details!'));
            exit;
        } else {
        	$currencyModel = new CurrencyModel();
	    	$currencyModel->where('currency_id', $curID)->delete($curID);
	    
	    	echo json_encode(array('type'=>'success', 'message' => 'Currency Deleted Suceesfully!'));
		    exit;
        }
	    
	}

	public function emails()
	{
	    $this->data['title'] = lang('Text.masters_template_title');
	    $this->data['emails_list'] = $this->model->list_email_templates();
	    echo view('admin/parts/list-header', $this->data);
	    echo view('admin/parts/nav', $this->data);
		echo view('admin/masters/emails/list', $this->data);
		echo view('admin/parts/list-footer');
	}
	
	public function template($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 5);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	    $this->data['title'] = lang('Text.masters_template_title');
    	    $this->data['template_id'] = $id;
    	    $this->data['template_row'] = $this->model->row_template($id);
    	    echo view('admin/parts/form-header', $this->data);
    	    echo view('admin/parts/nav', $this->data);
    		echo view('admin/masters/emails/edit',$this->data);
    		echo view('admin/parts/form-footer');
    		echo view('admin/masters/emails/script');
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function template_ajax(){
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		$input = $this->validate([
            'template_name' => 'required|alpha_space|max_length[100]',
            'template_sub' => 'required|alpha_space|max_length[100]',
            'template_content' => 'required|max_length[2000]',
            /*'company_logo' => [
                'uploaded[company_logo]',
                'max_size[file,1024]',
            ]*/
        ]);
        
        if (!$input) {
             $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        

        if($operation == 'Edit'){
            $tempID = $this->request->getPost('tempID');
		    $tempID = base64_decode($tempID);
		    
		    $data = [
				'title'	=>	$this->request->getPost('template_name'),
				'subject'	=>	$this->request->getPost('template_sub'),
				'template' =>	$this->request->getPost('template_content'),
				'signature'=>	$this->request->getPost('template_signature'),
				'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	        
		    $img = $this->request->getFile('template_logo');
		    $file_name = $img->getTempName();
		    if(!empty($file_name)){
		        $newName = $img->getRandomName();
                $img->move(FCPATH . 'public/uploads/emails', $newName);
                $logo =  '/public/uploads/emails/'.$img->getName();
                
                $data['image'] = $logo;
		    }
		    
        	$this->model->update_template($tempID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Template Updated Suceesfully!', 'redirect'=> 'masters/emails'));
		    exit;
        }
        
	}
	
}