<?php

namespace App\Models;

use CodeIgniter\Model;

class CollectionModel extends Model
{
    protected $table = 'tbl_collection_entry';

	protected $primaryKey = 'collection_id';

	protected $allowedFields = ['followup_id', 'received_amount','financialYear_id', 'received_amount_in_fc', 'payment_mode','payment_type', 'received_date','adjustment','balance','balance_amount_in_fc','Invoice_status','createdBy','updatedBy','updatedDate','status'];
	
	public function save_all_collections($collections = array())
	{
	    $builder = $this->db->table('tbl_collection_entry');
        $sta = $builder->insertBatch($collections);
        return $sta;
	}
	
	public function get_invoice_options($client_id)
	{
	    $htm = '<option value=""> -- select --</option>';
	    $query = $this->db->query("SELECT t1.code,t1.invoice_id FROM tbl_invoices t1 INNER JOIN tbl_followup t2 ON t1.invoice_id = t2.invoice_id WHERE t2.client_id = '$client_id' AND t2.invoice_status = 'O'");
        $row = $query->getResultArray();
        //echo "SELECT t1.code,t1.invoice_id FROM tbl_invoices t1 INNER JOIN tbl_followup_m t2 ON t1.invoice_id = t2.invoice_id WHERE t2.client_id = '$client_id'";
        //print_r($row);
        foreach($row as $val){
            $htm .= '<option value="'.$val['invoice_id'].'">'.$val['code'].'</option>';
        }
        return $htm;
	    
	}
	
	public function insert_followup_data_copy($followups = array())
	{
	    if (empty($followups)){
	        return false;
	    }
	    $builder = $this->db->table('tbl_temp_followup');
		$builder->insert($followups);
		return $this->db->insertID();
	}
	
	public function row_followup($followup_id)
	{
	   //$followup_id = base64_decode($id);
        $query = $this->db->query("SELECT t1.followup_id,t1.client_id,t1.financial_year_id,t1.company_id,t1.invoice_id,t1.salesman_id,t1.Invoice_date,t1.payment_terms,t1.due_date,t1.currency_id,t1.invoice_amount,t1.balance,t1.fc_currency_rate,t1.fc_currency_date,t1.invoice_amount_in_fc,t1.invoice_status,t1.status,t1.cust_ref_no,t1.critical_level_id,t1.remarks FROM tbl_followup t1 WHERE t1.followup_id = '$followup_id'");
        $row = $query->getRow();
        return $row; 
	}
	
	public function getPrintData($refno)
	{
	    $query = $this->db->query("SELECT * FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t1.ref_no = '$refno'");
        $row = $query->getResultArray();
        return $row;
	}
	
	public function getPrintSum($refno)
	{
	    $query = $this->db->query("SELECT SUM(received_amount_in_fc) as total FROM tbl_collection_entry t1 WHERE t1.ref_no = '$refno'");
        $row = $query->getResultArray();
        return $row;
	}
	
	public function update_invoice_data($data, $fid)
	{
	    $builder = $this->db->table('tbl_followup');
		$builder->update($data, ['followup_id' => $fid]);
		return $this->db->affectedRows() == 1;
	}
	public function fetch_invoice_followup($clients = array(),$invoice_id = 0, $invoicedate = '', $priority = 0, $company = 0, $fyear)
	{
	    $where = '';
	    if(!empty($clients)){
	        $idString = implode(",", $clients);
	        $where .= " AND t1.client_id IN ($idString)";
	    }
	    
	    if(!empty($invoice_id)){
	        $where .= " AND t1.invoice_id IN ($invoice_id)";
	    }
	    
	    if(!empty($invoicedate)){
	        //explode
	        $invdates = explode("-",$invoicedate);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.Invoice_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if(!empty($priority)){
	        $where .= " AND t1.critical_level_id IN ($priority)";
	    }
	    
	    if(!empty($company)){
	        $where .= " AND t1.company_id IN ($company)";
	    }
	    
	     //echo $idString;getResultArray
	     
	       $sql = "SELECT t1.followup_id,t1.client_id,t1.financial_year_id,t1.company_id,t1.critical_level_id,t1.invoice_id,DATE_FORMAT(t1.Invoice_date, '%d-%c-%Y') as Invoice_date,t1.payment_terms,DATE_FORMAT(t1.due_date, '%d-%c-%Y') as due_date,t1.currency_id,t1.invoice_amount,t1.balance,t1.is_followup_done,t1.invoice_status,t1.status, t2.name as clientname, t3.code as currency_code,t3.rate, t4.code as Invoice_no FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id INNER JOIN tbl_currency_m t3 ON t3.currency_id = t1.currency_id INNER JOIN tbl_invoices t4 ON t1.invoice_id = t4.invoice_id WHERE t1.invoice_status = 'O' AND t1.financial_year_id =$fyear $where ORDER BY t1.followup_id DESC";
	     $query = $this->db->query($sql);
	     $rowz = $query->getResultArray();
	     $followups = $rowz;
	     /*foreach($rowz as $row){
	         $fid = $row['followup_id'];
	         $sql = "SELECT followup_details_id,followup_id,salesman_id,last_follow_up_date,expected_amount,expected_payment_date,next_followup_date,remarks,createdBy,updatedBy,status FROM tbl_followup_details WHERE followup_id =$fid AND status = 'A'";
	        $query = $this->db->query($sql);
	        $srow = $query->getRow();
	        $row['details'] = $srow;
	        $followups[] = $row;
	     }*/
         return $followups;
	}
	public function list_branch_clients($client_id)
    {
        $query = $this->db->query("SELECT client_id FROM tbl_client_m WHERE Parent_client = $client_id");
        $row = $query->getResultArray();
        return $row;
    }
    public function row_currency($curid){
	    $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m WHERE currency_id = '$curid'");
        $row = $query->getRow();
        return $row;
	}
	
	public function get_invoices_string($printdata){
        $invoices = '';
        foreach ($printdata as $key => $data) {
            $invoice_no = get_invoice($data['invoice_id']);
            $invoices = $invoices.', '.$invoice_no;
        }
        $invoices = ltrim($invoices,",");
        return  $invoices;      
    }
    
	public function getCollections($postData=null, $fyear = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = isset($postData['order'][0]['column']) ? $postData['order'][0]['column'] : 0; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = isset($postData['order'][0]['dir']) ? $postData['order'][0]['dir'] : ''; // asc or desc
        //$searchValue = $postData['search']['value']; // Search value
        
        // Custom search filter 
         $searchInvoice = $postData['searchInvoice'];
         $searchCompany = $postData['searchCompany'];
         $searchStatus = $postData['searchStatus'];
         $searchClient = $postData['searchClient'];
         
        //for add collection page
        $session_data = array(
		    'search_client'          =>  $searchClient,
		    'search_invoice'          =>  $searchInvoice,
		);
		$session = \Config\Services::session();
		$session->set($session_data);
         
         $clients = [];
        
        if(!empty($searchClient)){
            $clients[] =  $searchClient;
            
            $client_data = $this->list_branch_clients($searchClient);
            foreach($client_data as $key => $data){
                $clients[] = $data['client_id'];
            }
        }
         
        $builder = $this->db->table('tbl_collection_entry');
        $builder->where('financialYear_id', $fyear);
        $builder->groupBy('tbl_collection_entry.ref_no');
        $totalRecords = $builder->countAllResults();
        
        
        //$builder = $this->db->table('tbl_collection_entry');
        $builder->select('tbl_collection_entry.collection_id,tbl_collection_entry.followup_id,tbl_collection_entry.financialYear_id,tbl_collection_entry.received_amount,tbl_collection_entry.received_amount_in_fc,tbl_collection_entry.payment_mode,tbl_collection_entry.payment_type,tbl_collection_entry.received_date,tbl_collection_entry.ref_no,tbl_collection_entry.adjustment,tbl_collection_entry.balance,tbl_collection_entry.balance_amount_in_fc,tbl_collection_entry.Invoice_status,tbl_collection_entry.createdBy,tbl_collection_entry.createdDate,tbl_collection_entry.updatedBy,tbl_collection_entry.updatedDate,tbl_collection_entry.status,tbl_followup.client_id, tbl_followup.company_id, tbl_followup.salesman_id, tbl_followup.invoice_id, tbl_followup.Invoice_date, tbl_followup.payment_terms, tbl_followup.due_date, tbl_followup.currency_id, tbl_followup.invoice_amount');
        $builder->join('tbl_followup', 'tbl_followup.followup_id = tbl_collection_entry.followup_id');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_details_id = tbl_collection_entry.followup_details_id');
        
        if($searchInvoice != ''){
            
            $builder->where('tbl_followup.invoice_id', $searchInvoice);
            
        }
        if($searchCompany != ''){
            
            $builder->where('tbl_followup.company_id', $searchCompany);
            
        }
        if($searchStatus != ''){
            $builder->like('tbl_followup.Invoice_status', $searchStatus);
        }
        if($searchClient != ''){
            $builder->whereIn('tbl_followup.client_id', $clients);
        }
        $builder->where('tbl_collection_entry.financialYear_id', $fyear);
        $builder->groupBy('tbl_collection_entry.ref_no');
        $totalRecordwithFilter = $builder->countAllResults();
        
        
        $builder->select('tbl_collection_entry.collection_id,tbl_collection_entry.followup_id,tbl_collection_entry.financialYear_id,tbl_collection_entry.received_amount,SUM(tbl_collection_entry.received_amount_in_fc) AS received_amount_in_fc,tbl_collection_entry.payment_mode,tbl_collection_entry.payment_type,tbl_collection_entry.received_date,tbl_collection_entry.ref_no,tbl_collection_entry.adjustment,tbl_collection_entry.balance,SUM(tbl_collection_entry.balance_amount_in_fc) AS balance_amount_in_fc,tbl_collection_entry.Invoice_status,tbl_collection_entry.createdBy,tbl_collection_entry.createdDate,tbl_collection_entry.updatedBy,tbl_collection_entry.updatedDate,tbl_collection_entry.status,tbl_followup.client_id, tbl_followup.company_id, tbl_followup.salesman_id, tbl_followup.invoice_id, tbl_followup.Invoice_date, tbl_followup.payment_terms, tbl_followup.due_date, tbl_followup.currency_id, tbl_followup.invoice_amount');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_details_id = tbl_collection_entry.followup_details_id');
        $builder->join('tbl_followup', 'tbl_followup.followup_id = tbl_collection_entry.followup_id');
        if($searchInvoice != ''){
            $builder->where('tbl_followup.invoice_id', $searchInvoice);
        }
         if($searchCompany != ''){
            
            $builder->where('tbl_followup.company_id', $searchCompany);
            
        }
        if($searchStatus != ''){
            $builder->like('tbl_followup.Invoice_status', $searchStatus);
        }
        if($searchClient != ''){
            $builder->whereIn('tbl_followup.client_id', $clients);
        }
        
        $builder->where('tbl_collection_entry.financialYear_id', $fyear);
        $builder->groupBy('tbl_collection_entry.ref_no');
        if(empty($columnSortOrder)){
            $builder->orderBy('tbl_collection_entry.collection_id', 'DESC');
        } /*else if($columnName == 'invoice'){
            $builder->orderBy('tbl_followup.invoice_id', $columnSortOrder);
        }*/ else if($columnName == 'receivedamount'){
            $builder->orderBy('received_amount_in_fc', $columnSortOrder);
        }
        else if($columnName == 'receiveddate'){
            $builder->orderBy('tbl_collection_entry.received_date', $columnSortOrder);
        }
        else if($columnName == 'balance'){
            $builder->orderBy('balance_amount_in_fc', $columnSortOrder);
        } else if($columnName == 'invoicestatus'){
            $builder->orderBy('tbl_collection_entry.Invoice_status', $columnSortOrder);
        }
        //$builder->orderBy($columnName, $columnSortOrder);invoicestatus
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
        //print_r($records);
        //exit;
        $data = array();

        foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $status = '';
            if($record->Invoice_status == 'O'){
                $status = '<span class="rmsopen">Open</span>';
            }else if($record->Invoice_status == 'C'){
                $status = '<span class="rmsclosed">Closed</span>';
            }
            
            $button = '';
            if($record->status == 'A'){
               //$button .= '<a href="'. base_url() .'/collections/edit/'. base64_encode($record->collection_id) .'" class="btn btn-primary btn-sm btn-flat" data-toggle="tooltip" title="Edit"><i class="far fa-edit"></i></a>';
            }
            //$button .= '<button class="btn btn-danger btn-sm btn-flat btn-followup-delete" data-id="'.$record->collection_id.'">Delete</button>';
            if(!empty($record->ref_no)){
                $button .= '<button data-ref="'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms btnviewreceipts" data-toggle="tooltip" title="View"><i class="fa fa-eye"></i></button>';
                $button .= '<a target="_blank" href="'. base_url() .'/collections/print/'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Print"><i class="fa fa-print"></i></a>';
            }
            $namex = get_client($record->client_id);
            $wapp = get_client_wapp($record->client_id);

            $invoices = '';
            if(!empty($wapp)){
                $printdata = $this->getPrintData($record->ref_no);
                $printsum = $this->getPrintSum($record->ref_no);
                $received_date = date('d-m-Y',strtotime($printdata[0]['received_date']));
                $received_amount_sum = $printsum[0]['total'];
                $invoices = $this->get_invoices_string($printdata);
                
                //$amt = $record->received_amount;
                $curr = $currency_data->code;
                $msgtxt = "Dear $namex, This is to confirm that on $received_date we have received $curr $received_amount_sum from you against the settlement invoices ($invoices)";
                $button .= '<a target="_blank" href="https://api.whatsapp.com/send/?phone='.$wapp.'&text='.$msgtxt.'&app_absent=0&lang=en" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Whatsapp"><i class="fab fa-whatsapp"></i></a>';
            }

            $em = get_client_email($record->client_id);
            
            if(!empty($em)){
                $button .= '<button data-name="'.$namex.'" data-email="'.$em.'" data-ref="'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms btnmodalemail" data-toggle="tooltip" title="Email"><i class="fa fa-envelope"></i></a>';
            }
           $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>$invoices,
             //"cur"=>$currency_data->code,
             "receivedamount"=>$record->received_amount_in_fc,
             "receiveddate"=>date('d-m-Y', strtotime($record->received_date)),
             "balance"=>$record->balance_amount_in_fc,
             "company"=>get_company($record->company_id),
             //"invoicestatus"=>$status,
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	
	public function getCollectionsByCreators($postData=null, $fyear = 0, $user_id = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = isset($postData['order'][0]['column']) ? $postData['order'][0]['column'] : 0; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = isset($postData['order'][0]['dir']) ? $postData['order'][0]['dir'] : ''; // asc or desc
        //$searchValue = $postData['search']['value']; // Search value
        
        // Custom search filter 
         $searchInvoice = $postData['searchInvoice'];
         $searchCompany = $postData['searchCompany'];
         $searchStatus = $postData['searchStatus'];
         $searchClient = $postData['searchClient'];
         
        $builder = $this->db->table('tbl_collection_entry');
        $builder->where('financialYear_id', $fyear);
        $builder->where('createdBy', $user_id);
        $builder->groupBy('tbl_collection_entry.ref_no');
        $totalRecords = $builder->countAllResults();
        
        
        $builder->select('tbl_collection_entry.collection_id,tbl_collection_entry.followup_id,tbl_collection_entry.financialYear_id,tbl_collection_entry.received_amount,tbl_collection_entry.received_amount_in_fc,tbl_collection_entry.payment_mode,tbl_collection_entry.payment_type,tbl_collection_entry.received_date,tbl_collection_entry.ref_no,tbl_collection_entry.adjustment,tbl_collection_entry.balance,tbl_collection_entry.balance_amount_in_fc,tbl_collection_entry.Invoice_status,tbl_collection_entry.createdBy,tbl_collection_entry.createdDate,tbl_collection_entry.updatedBy,tbl_collection_entry.updatedDate,tbl_collection_entry.status,tbl_followup.client_id, tbl_followup.company_id, tbl_followup.salesman_id, tbl_followup.invoice_id, tbl_followup.Invoice_date, tbl_followup.payment_terms, tbl_followup.due_date, tbl_followup.currency_id, tbl_followup.invoice_amount');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_details_id = tbl_collection_entry.followup_details_id');
        $builder->join('tbl_followup', 'tbl_followup.followup_id = tbl_collection_entry.followup_id');
        if($searchInvoice != ''){
            
            $builder->where('tbl_followup.invoice_id', $searchInvoice);
            
        }
        if($searchCompany != ''){
            
            $builder->where('tbl_followup.company_id', $searchCompany);
            
        }
        if($searchStatus != ''){
            $builder->like('tbl_followup.Invoice_status', $searchStatus);
        }
        if($searchClient != ''){
            $builder->like('tbl_followup.client_id', $searchClient);
        }
        $builder->where('tbl_collection_entry.financialYear_id', $fyear);
        $builder->where('tbl_collection_entry.createdBy', $user_id);
        $builder->groupBy('tbl_collection_entry.ref_no');
        $totalRecordwithFilter = $builder->countAllResults();
        
        
        $builder->select('tbl_collection_entry.collection_id,tbl_collection_entry.followup_id,tbl_collection_entry.financialYear_id,tbl_collection_entry.received_amount,SUM(tbl_collection_entry.received_amount_in_fc) AS received_amount_in_fc,tbl_collection_entry.payment_mode,tbl_collection_entry.payment_type,tbl_collection_entry.received_date,tbl_collection_entry.ref_no,tbl_collection_entry.adjustment,tbl_collection_entry.balance,SUM(tbl_collection_entry.balance_amount_in_fc) AS balance_amount_in_fc,tbl_collection_entry.Invoice_status,tbl_collection_entry.createdBy,tbl_collection_entry.createdDate,tbl_collection_entry.updatedBy,tbl_collection_entry.updatedDate,tbl_collection_entry.status,tbl_followup.client_id, tbl_followup.company_id, tbl_followup.salesman_id, tbl_followup.invoice_id, tbl_followup.Invoice_date, tbl_followup.payment_terms, tbl_followup.due_date, tbl_followup.currency_id, tbl_followup.invoice_amount');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_details_id = tbl_collection_entry.followup_details_id');
        $builder->join('tbl_followup', 'tbl_followup.followup_id = tbl_collection_entry.followup_id');
         if($searchInvoice != ''){
            
            $builder->where('tbl_followup.invoice_id', $searchInvoice);
            
        }
        if($searchCompany != ''){
            
            $builder->where('tbl_followup.company_id', $searchCompany);
            
        }
        if($searchStatus != ''){
            $builder->like('tbl_followup.Invoice_status', $searchStatus);
        }
        if($searchClient != ''){
            $builder->like('tbl_followup.client_id', $searchClient);
        }
        $builder->where('tbl_collection_entry.financialYear_id', $fyear);
        $builder->where('tbl_collection_entry.createdBy', $user_id);
        $builder->groupBy('tbl_collection_entry.ref_no');

        if(empty($columnSortOrder)){
            $builder->orderBy('tbl_collection_entry.collection_id', 'DESC');
        } /*else if($columnName == 'invoice'){
            $builder->orderBy('tbl_followup.invoice_id', $columnSortOrder);
        }*/ else if($columnName == 'receivedamount'){
            $builder->orderBy('received_amount_in_fc', $columnSortOrder);
        }
        else if($columnName == 'receiveddate'){
            $builder->orderBy('tbl_collection_entry.received_date', $columnSortOrder);
        }
        else if($columnName == 'balance'){
            $builder->orderBy('balance_amount_in_fc', $columnSortOrder);
        } else if($columnName == 'invoicestatus'){
            $builder->orderBy('tbl_collection_entry.Invoice_status', $columnSortOrder);
        }
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
        
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            $status = '';
            if($record->Invoice_status == 'O'){
                $status = '<span class="rmsopen">Open</span>';
            }else if($record->Invoice_status == 'C'){
                $status = '<span class="rmsclosed">Closed</span>';
            }
            
            $button = '';
            if($record->status == 'A'){
               //$button .= '<a href="'. base_url() .'/collections/edit/'. base64_encode($record->collection_id) .'" class="btn btn-primary btn-sm btn-flat" data-toggle="tooltip" title="Edit"><i class="far fa-edit"></i></a>';
            }
            if(!empty($record->ref_no)){
                $button .= '<button data-ref="'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms btnviewreceipts" data-toggle="tooltip" title="View"><i class="fa fa-eye"></i></button>';
                $button .= '<a href="'. base_url() .'/collections/print/'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Print"><i class="fa fa-print"></i></a>';
            }

            $namex = get_client($record->client_id);
            $wapp = get_client_wapp($record->client_id);
            if(!empty($wapp)){
                $printdata = $this->getPrintData($record->ref_no);
                $printsum = $this->getPrintSum($record->ref_no);
                $received_date = date('d-m-Y',strtotime($printdata[0]['received_date']));
                $received_amount_sum = $printsum[0]['total'];
                $invoices = $this->get_invoices_string($printdata);
                
                //$amt = $record->received_amount;
                $curr = $currency_data->code;
                $msgtxt = "Dear $namex, This is to confirm that on $received_date we have received $curr $received_amount_sum from you against the settlement invoices ($invoices)";
                $button .= '<a target="_blank" href="https://api.whatsapp.com/send/?phone='.$wapp.'&text='.$msgtxt.'&app_absent=0&lang=en" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Whatsapp"><i class="fab fa-whatsapp"></i></a>';
            }
            $em = get_client_email($record->client_id);
            
            if(!empty($em)){
                $button .= '<button data-name="'.$namex.'" data-email="'.$em.'" data-ref="'. $record->ref_no .'" class="btn btn-primary btn-sm btn-flat btn-rms btnmodalemail" data-toggle="tooltip" title="Email"><i class="fa fa-envelope"></i></a>';
            }
            //$button .= '<button class="btn btn-danger btn-sm btn-flat btn-followup-delete" data-id="'.$record->collection_id.'">Delete</button>';
           $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "cur"=>$currency_data->code,
             "receivedamount"=>$record->received_amount_in_fc,
             "receiveddate"=>date('d-m-Y', strtotime($record->received_date)),
             "balance"=>$record->balance_amount_in_fc,
             "company"=>get_company($record->company_id),
             "invoicestatus"=>$status,
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
}