<?php

namespace App\Models;

use CodeIgniter\Model;

class MasterModel extends Model
{
    public function list_company()
    {
        $query = $this->db->query("SELECT company_id,country_id,companyName,companyAddress,logo,phoneNo,phoneNo2,email,GstNo,VatNo,parent,status FROM tbl_company_m");
        $row = $query->getResultArray();
        return $row;
    }
    public function list_parent_company()
    {
        $query = $this->db->query("SELECT company_id,country_id,companyName,companyAddress,logo,phoneNo,phoneNo2,email,GstNo,VatNo,status FROM tbl_company_m WHERE parent = 0");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function row_company($id = null)
    {
        $comp_id = base64_decode($id);
        $query = $this->db->query("SELECT company_id,country_id,companyName,companyAddress,logo,phoneNo,phoneNo2,email,GstNo,VatNo,parent,status FROM tbl_company_m WHERE company_id = '$comp_id'");
        $row = $query->getRow();
        return $row;
    }
    
    public function list_usertypes()
    {
        $query = $this->db->query("SELECT userType_id,userType,status FROM tbl_usertype_m");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function list_active_usertypes($type = null)
    {
        $sql = "SELECT userType_id,userType,status FROM tbl_usertype_m WHERE status = 1";
        if (!empty($type)){
            $sql .= " AND userType_id = '$type'";
        }
        
        $query = $this->db->query($sql);
        $row = $query->getResultArray();
        return $row;
    }
    
    public function row_usertypes($id = null)
    {
        $type = base64_decode($id);
        $query = $this->db->query("SELECT userType_id,userType,status FROM tbl_usertype_m WHERE userType_id = '$type'");
        $row = $query->getRow();
        return $row;
    }
    
    public function list_users($type = 1)
    {
        $query = $this->db->query("SELECT user_id,userType_id,userName,password,email,createdBy,createdDate,isActive,loginStatus,updatedBy,updatedDate,login_time FROM tbl_user_m WHERE userType_id = '$type'");
        $row = $query->getResultArray();
        return $row;
    }
    public function list_users_have_login()
    {
        $query = $this->db->query("SELECT t1.user_id,t1.userType_id,t1.userName,t1.password,t1.email,t1.createdBy,t1.createdDate,t1.isActive,t1.loginStatus,t1.updatedBy,t1.updatedDate,t1.login_time,t2.userType FROM tbl_user_m t1 INNER JOIN tbl_usertype_m t2 ON t1.userType_id = t2.userType_id WHERE t1.loginStatus = 1 AND t1.user_id != 1");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function list_users_sales($type = 2)
    {
        $query = $this->db->query("SELECT t1.user_id,t1.userType_id,t1.userName,t1.password,t1.email,t1.createdBy,t1.createdDate,t1.isActive,t1.loginStatus,t1.updatedBy,t1.updatedDate,t1.login_time, t2.sales_man_name FROM tbl_user_m t1 INNER JOIN tbl_salesman_m t2 ON t1.user_id = t2.user_id WHERE t1.userType_id = '$type'");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function list_users_have_account($type = 1)
    {
        $query = $this->db->query("SELECT t1.user_id,t1.userType_id,t1.userName,t1.password,t1.email,t1.createdBy,t1.createdDate,t1.isActive,t1.loginStatus,t1.updatedBy,t1.updatedDate,t1.login_time,t2.userType FROM tbl_user_m t1 INNER JOIN tbl_usertype_m t2 ON t1.userType_id = t2.userType_id WHERE t1.loginStatus = '$type'");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function row_user($id = null)
    {
        $uid = base64_decode($id);
        $query = $this->db->query("SELECT user_id,userType_id,userName,password,email,createdBy,createdDate,isActive,updatedBy,updatedDate,login_time FROM tbl_user_m WHERE user_id = '$uid'");
        $row = $query->getRow();
        return $row;
    }
    
    public function row_suser($id = null)
    {
        $uid = base64_decode($id);
        $query = $this->db->query("SELECT t1.user_id,t1.userType_id,t1.userName,t1.password,t1.email,t1.createdBy,t1.createdDate,t1.isActive,t1.loginStatus,t1.updatedBy,t1.updatedDate,t1.login_time,t2.sales_man_name FROM tbl_user_m t1 INNER JOIN tbl_salesman_m t2 ON t1.user_id = t2.user_id WHERE t1.user_id = '$uid'");
        $row = $query->getRow();
        return $row;
    }
    
    public function list_financialyears()
    {
        $query = $this->db->query("SELECT financialYear_id,startDate,endDate,financialYear,status,createdBy,createdDate,updatedBy,updatedDate FROM tbl_financialYear_m");
        $row = $query->getResultArray();
        return $row;
    }
    public function row_fyear($id = null)
    {
        $fid = base64_decode($id);
        $query = $this->db->query("SELECT financialYear_id,startDate,endDate,financialYear,status,createdBy,createdDate,updatedBy,updatedDate FROM tbl_financialYear_m WHERE financialYear_id = '$fid'");
        $row = $query->getRow();
        return $row;
    }
    
    
    public function list_currency()
    {
        $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m");
        $row = $query->getResultArray();
        return $row;
    }
    
    public function list_currency_active()
    {
        $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m WHERE status = 1");
        $row = $query->getResultArray();
        return $row;
    }
    public function row_currency($id = null)
    {
        $curid = base64_decode($id);
        $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m WHERE currency_id = '$curid'");
        $row = $query->getRow();
        return $row;
    }
    public function list_country()
    {
        $query = $this->db->query("SELECT country_id,phone_code,country_name,country_code,status FROM tbl_country_m WHERE status = 1");
        $row = $query->getResultArray();
        return $row;
    }
    public function row_settings($id = null)
    {
        //$curid = base64_decode($id);
        $query = $this->db->query("SELECT settings_id,functionalCurrency_id,licenseNo,licenseExpiryDate,followupReminderDays,licenseExpiryReminderDays FROM tbl_settings_m WHERE settings_id = 1");
        $row = $query->getRow();
        return $row;
    }
    
    public function row_settings_email($id = null)
    {
        //$curid = base64_decode($id);
        $query = $this->db->query("SELECT id,host,port,username,password,fromname,fromemail FROM tbl_email_settings_m WHERE id = '$id'");
        $row = $query->getRow();
        return $row;
    }
    
    public function list_email_templates()
    {
        $query = $this->db->query("SELECT id,slug,title,subject,template,signature,image,createdBy,createdDate,updatedBy,updatedDate FROM tbl_emails_m");
        $row = $query->getResultArray();
        return $row;
    }
    public function row_template($id = null)
    {
        $tid = base64_decode($id);
        $query = $this->db->query("SELECT id,slug,title,subject,template,signature,image,createdBy,createdDate,updatedBy,updatedDate FROM tbl_emails_m WHERE id = '$tid'");
        $row = $query->getRow();
        return $row;
    }
    public function update_template($tempID, $data)
    {
        $builder = $this->db->table('tbl_emails_m');
		$builder->update($data, ['id' => $tempID]);
		return $this->db->affectedRows() == 1;
    }
    
    public function list_modules()
    {
        $query = $this->db->query("SELECT module_id,name,status FROM tbl_modules_m WHERE status = 1");
        $rows = $query->getResultArray();
        $modules = array();
        foreach($rows as $row){
            $module_id = $row['module_id'];
            $query1 = $this->db->query("SELECT sub_module_id,name,parent,status FROM tbl_sub_module_m WHERE status = 1 AND parent = '$module_id'");
            $rows1 = $query1->getResultArray();
            $modules[] = array(
                'module_id' => $row['module_id'],
                'name' => $row['name'],
                'status' => $row['status'],
                'submodules' => $rows1,
                );
        }
        return $modules;
    }
    
}