<?php

namespace App\Models;

use CodeIgniter\Model;

class SettingsModel extends Model
{
    protected $table = 'tbl_settings_m';

	protected $primaryKey = 'settings_id';

	protected $allowedFields = ['functionalCurrency_id', 'licenseNo', 'licenseExpiryDate', 'followupReminderDays', 'licenseExpiryReminderDays'];
	
	public function active_fyear()
	{
	    $query = $this->db->query("SELECT financialYear_id,startDate,endDate,financialYear,status,createdBy,createdDate,updatedBy,updatedDate FROM tbl_financialYear_m WHERE status = 1");
        $row = $query->getRow();
        return $row->financialYear_id;
	}
	
	public function site_settings()
	{
	    $query = $this->db->query("SELECT functionalCurrency_id,licenseNo,licenseExpiryDate,followupReminderDays,licenseExpiryReminderDays FROM tbl_settings_m");
        $row = $query->getRow();
        return $row;
	}
	public function email_settings()
	{
	    $query = $this->db->query("SELECT host,port,username,password,fromname,fromemail FROM tbl_email_settings_m");
        $row = $query->getRow();
        return $row;
	}
	public function updateEmailSettings($settings_id, $data)
	{
	    $builder = $this->db->table('tbl_email_settings_m');
		$builder->update($data, ['id' => $settings_id]);
		return $this->db->affectedRows() == 1;
	}
}