<?php
namespace App\Controllers;
use App\Models\CollectionModel;
use App\Models\InvoiceModel;
use App\Models\ClientsModel;
use App\Models\CurrencyModel;
use App\Models\CompanyModel;
use App\Models\PriorityModel;
use App\Models\TemplateModel;

class Collections extends BaseController
{
    public function __construct()
	{
	    $this->is_redirect_to_login();
	    $this->collection = new CollectionModel();
	    $this->invoice = new InvoiceModel();
	    $this->client = new ClientsModel();
	    $this->currency = new CurrencyModel();
	    $this->company = new CompanyModel();
	    $this->level = new PriorityModel();
      $this->template = new TemplateModel();
	}
	public function index()
	{
    $this->data['templates'] = $this->template->where('mailgroup', 'collection')->find();
	    switch ($this->user_role) {
            case 1:
               $this->data['title'] = lang('Text.collections_admin_title');
                
                $this->data['invoices_list'] = $this->invoice->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/collections/list', $this->data);
        		echo view('admin/parts/collections-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.collections_admin_title');
                $this->data['invoices_list'] = $this->invoice->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/collections/list', $this->data);
        		echo view('admin/parts/collections-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	
	//collections_ajax
	public function collections_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    switch ($this->user_role) {
	        case 1:
	            $fdata = $this->collection->getCollections($postData,$this->fyear);
	            break;
	        case 2:
	            $fdata = $this->collection->getCollectionsByCreators($postData,$this->fyear,$this->user_id);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";
	    }
	    
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	
	public function collections_invoice_search_ajax()
	{
	      if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		/*$input = $this->validate([
            'client' => 'required'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }*/
        $clients = [];
        $parent_client = $this->request->getPost('client');
        if(!empty($parent_client)){
            $clients[] =  $parent_client;
            
            $client_data = $this->client->where('Parent_client', $parent_client)->findAll();
            foreach($client_data as $key => $data){
                $clients[] = $data['client_id'];
            }
        }
        
        $invoice_id = $this->request->getPost('invoice');
        
        $invoicedate = $this->request->getPost('invoicedate');
        
        $priority = $this->request->getPost('critical_level');
        $company = $this->request->getPost('sel_company');
        //print_r($invoicedate);exit;
        
        //get all followups 
        $followups = $this->collection->fetch_invoice_followup($clients, $invoice_id, $invoicedate, $priority, $company, $this->fyear);
        echo json_encode(array('type'=>'search', 'data' => $followups, 'datacount'=>count($followups)));
		    exit;
	}
	
	public function collections_crud_ajax()
	{
	    //print_r($_POST);exit;
	    $operation = $this->request->getPost('operation');
	    $refNo = (isset($_POST['ref_no']) && !empty($_POST['ref_no'])) ? $_POST['ref_no'] : '';
        if (!empty($refNo)){
            $dataref = $this->collection->where('ref_no',$refNo)->find();
            $countref = count($dataref);
            if ($countref > 0){
              echo json_encode(array('type'=>'exist', 'message' => 'REF. No is already exist!'));
              exit;
            }
        }
        if($operation == 'Add'){
           $check = $this->request->getPost('check');
           $followup_id = $this->request->getPost('followup_id');
           //echo count($check);exit;
           $collections = array();
           $dynamicref = time();
           if (count($check) > 0){
               $loop = count($followup_id);
               $received_date = $_POST['received_date'];
               $ref_no = (isset($_POST['ref_no']) && !empty($_POST['ref_no'])) ? $_POST['ref_no'] : $dynamicref;
               for ($i = 0; $i < $loop; $i++ ){
                   //echo $i;
                   $chkitem = $_POST['chkitem'][$i];
                   if (!empty($chkitem)){
                       //echo $i;
                       $fid = $_POST['followup_id'][$i];
                       $selclient = $_POST['selclient'][$i];
                       $invoice_no = $_POST['invoice_no'][$i];
                       $invoice_date = $_POST['invoice_date'][$i];
                       $selCurrency = $_POST['selCurrency'][$i];
                       $invoice_amount = $_POST['invoice_amount'][$i];
                       $adjustment = $_POST['adjustment'][$i];
                       $received_amount = $_POST['received_amount'][$i];
                       $payType = $_POST['payType'][$i];
                       $payMode = $_POST['payMode'][$i];
                       $balance = $_POST['balance'][$i];
                       
                       $invoice_status = 'O';
                       if($balance == 0 || $balance == 1){
                          $invoice_status = 'C'; 
                       }
                       
                       $functional_currency_id = $this->fc_currency;
                       $curr_data = $this->currency->where('currency_id', $selCurrency)->findAll();
                       $fc_rate = $curr_data[0]['rate'];
                       $fc_rate = (!empty($fc_rate)) ? $fc_rate : 1;
                       $fc_date = $curr_data[0]['rateDate'];
                       
                       $balance_fc_amount = 0;
                       $received_amount_in_fc = 0;
                       if($selCurrency == $functional_currency_id){
                           $balance_fc_amount = $balance;
                           $received_amount_in_fc = $received_amount;
                       } else {
                           $balance_fc_amount = (float)$balance * (float)$fc_rate;
                           $received_amount_in_fc = (float)$received_amount * (float)$fc_rate;
                       }
                       
                           
                   
                       $collections[] = array(
                           'followup_id' => $fid,
                           'financialYear_id' =>  $this->fyear,
                           'received_amount' => $received_amount,
                           'received_amount_in_fc' => $received_amount_in_fc,
                           'payment_mode' => $payMode,
                           'payment_type' => $payType,
                           'received_date' => (!empty($received_date)) ? date('Y-m-d',strtotime($received_date)) : date('Y-m-d'),
                           'ref_no'=> $ref_no,
                           'adjustment' => (!empty($adjustment)) ? $adjustment : 0,
                           'balance' => $balance,
                           'balance_amount_in_fc' => $balance_fc_amount,
                           'Invoice_status'=> $invoice_status,
                           'status'=> 'A',
                           'createdBy' => $this->user_id,
                           'updatedBy' => 0,
    				       'updatedDate' => '0000-00-00 00:00:00'
                        );
                        
                        //update invoice table , status, based on fid
                        $data = [
                            'balance' => $balance,
                            'balance_amount_in_fc' => $balance_fc_amount,
                            'invoice_status'=> $invoice_status,
                            ];
                            
                        $this->collection->update_invoice_data($data,$fid);
                        
                        //take record of fid and insert it with received date to followup history
                        $rowfdta = $this->collection->row_followup($fid);
                        $fdatacopy = array(
                            "followup_id" => $rowfdta->followup_id,
                            "client_id" => $rowfdta->client_id,
                            "invoice_id" => $rowfdta->invoice_id,
                            "financial_year_id" => $rowfdta->financial_year_id,
                            "company_id" => $rowfdta->company_id,
                            'salesman_id'=> $rowfdta->salesman_id,
                            "Invoice_date" => date('Y-m-d', strtotime($rowfdta->Invoice_date)),
                            "payment_terms" => $rowfdta->payment_terms,
                            "due_date" => date('Y-m-d', strtotime($rowfdta->due_date)),
                            "currency_id" => $rowfdta->currency_id,
                            "invoice_amount" => $rowfdta->invoice_amount,
                            "balance" => $balance,
                            "fc_currency_rate" => $rowfdta->fc_currency_rate,
                            "fc_currency_date" => date('Y-m-d', strtotime( $rowfdta->fc_currency_date)),
    		                    "invoice_amount_in_fc" => $rowfdta->invoice_amount_in_fc,
    		                    "balance_amount_in_fc" => $balance_fc_amount,
    		                    "received_date" => (!empty($received_date)) ? date('Y-m-d',strtotime($received_date)) : date('Y-m-d'),
    		                    "cust_ref_no"=> $rowfdta->cust_ref_no,
            				        "invoice_status" => $invoice_status,
                            "status" =>'A',
                            "createdBy" => $this->user_id,
                            "updatedBy" => 0,
    		                    "updatedDate" => '0000-00-00 00:00:00'
                          );
                        
                        $this->collection->insert_followup_data_copy($fdatacopy);
                        //chck record exist update statusus to inactive
                            
                        $checkRecord = $this->collection->where('followup_id',$fid)->countAllResults();
                       if ($checkRecord > 0){
                           //update status to inactive
                           $this->collection->update($fid, ['status' => 'I']);
                       }
                   }
               
               }
               //print_r($collections);exit;
               $status = $this->collection->save_all_collections($collections);
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Collection Batch Inserted Successfully!', 'redirect'=> 'collections', 'printrefno'=> $ref_no));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Collection Batch Not Inserted Successfully!', 'redirect'=> 'collections'));
		           exit; 
                }
           }
        }
        exit;
	}


	
	public function print($refno = null)
	{
	    //echo $refno;
	    //echo "print";
	    $this->data['refno'] = $refno;
	    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
	    $this->data['printdata'] = $this->collection->getPrintData($refno);
	    $this->data['printsum'] = $this->collection->getPrintSum($refno);
	    $this->data['headcomp'] = $this->company->where('parent', 1)->first();
	    echo view('admin/collections/print', $this->data);
	}
	
	public function get_invoices()
	{
	    $client_id = $this->request->getPost('client_id');
	    echo $this->collection->get_invoice_options($client_id);
	}
	
    public function add()
    {
        $access = getUserPrivilegeById($this->user_id, 13);
        $this->data['templates'] = $this->template->where('mailgroup', 'collection')->find();
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
            $x_search_client = $this->session->get('search_client');
            $x_search_invoice = $this->session->get('search_invoice');
            //$this->fc_currency
            switch ($this->user_role) {
                case 1:
                    $this->data['search_client'] = !empty($x_search_client) ? $x_search_client : 0;
                    $this->data['search_invoice'] = !empty($x_search_invoice) ? $x_search_invoice : 0;
                    $this->data['title'] = lang('Text.collections_add_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['invoices_list'] = $this->invoice->findAll(25, 0);
                    /*$this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();*/
                    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                    //print_r($this->data['curr_data']);
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['priority_list'] =  $this->level->findAll();
    		        $this->data['company_list'] = $this->client->list_company();
    		        
                    echo view('admin/parts/collections-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/collections/add', $this->data);
            		echo view('admin/parts/collections-form-footer');
            		echo view('admin/collections/script');
                    break;
                case 2:
                    $this->data['search_client'] = !empty($x_search_client) ? $x_search_client : 0;
                    $this->data['search_invoice'] = !empty($x_search_invoice) ? $x_search_invoice : 0;
                    $this->data['title'] = lang('Text.collections_add_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['invoices_list'] = $this->invoice->findAll();
                    $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                    //print_r($this->data['curr_data']);
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['priority_list'] =  $this->level->findAll();
    		        $this->data['company_list'] = $this->client->list_company();
    		        
                    echo view('admin/parts/collections-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/collections/add', $this->data);
            		echo view('admin/parts/collections-form-footer');
            		echo view('admin/collections/script');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   echo "i is not equal to 0, 1 or 2";
            }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}

  public function send_email()
    {
        if (!$this->request->isAJAX()) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            return;
        }

        $email = $this->request->getPost('email');
        $name = $this->request->getPost('name');
        $template = $this->request->getPost('template');

        $template_info = $this->template->where('slug', $template)->first();
        $subject = (isset($template_info['subject']) && !empty($template_info['subject'])) ? $template_info['subject'] : 'Collection';
        $message = sprintf($template_info['template'],$name);
        $image = (isset($template_info['image']) && !empty($template_info['image'])) ? base_url().$template_info['image'] :'';
        $template = $this->template_register($message, $image);
        $to = $email;
        if($this->send_email_rms($to, $subject, $template, $image)){
            $type    = 'success';
            $message = 'Email sent';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        } else {
            $type    = 'error';
            $message = 'Something wrong!! Email not sent.';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        }

    }

}