<?php
namespace App\Controllers;
use App\Models\RemindersModel;
use CodeIgniter\HTTP\RequestInterface;

class Reminders extends BaseController
{
    public function __construct()
	{
	    $this->is_redirect_to_login();
	    $this->reminder = new RemindersModel();
	}
	public function index()
	{
	    //echo $this->user_role;
	    switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.reminders_admin_title');
                //$this->data['reminders_list'] = $this->reminder->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/reminders/list', $this->data);
        		echo view('admin/parts/reminder-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.reminders_admin_title');
                //$this->data['reminders_list'] = $this->reminder->where('createdBy', (int)$this->user_id)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/reminders/list', $this->data);
        		echo view('admin/parts/reminder-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
                $this->data['title'] = lang('Text.reminders_admin_title');
                //$this->data['reminders_list'] = $this->reminder->where('createdBy', (int)$this->user_id)->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/reminders/list', $this->data);
        		echo view('admin/parts/reminder-list-footer');
        }
	}
	
	public function add()
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.client_add_admin_title');
                //$this->data['country_list'] = $this->client->list_country();
                //$this->data['company_list'] = $this->client->list_company();
                //$this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/reminders/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/reminders/script');
                break;
            case 2:
                $this->data['title'] = lang('Text.client_add_admin_title');
                //$this->data['country_list'] = $this->client->list_country();
                //$this->data['company_list'] = $this->client->list_company();
                //$this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/reminders/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/reminders/script');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               //echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function edit($id)
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
    	   $this->data['reminder_id'] =  $id;
    	   //$clientid = base64_decode($id);
    	   switch ($this->user_role) {
                case 1:
                    $this->data['title'] = lang('Text.client_edit_admin_title');
                    //$this->data['country_list'] = $this->client->list_country();
                    //$this->data['company_list'] = $this->client->list_company();
                    //$this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['reminder_row'] = $this->reminder->row_reminder($id);
                    echo view('admin/parts/client-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/reminders/edit', $this->data);
            		echo view('admin/parts/client-form-footer');
            		echo view('admin/reminders/script');
                    break;
                case 2:
                    $this->data['title'] = lang('Text.client_edit_admin_title');
                    //$this->data['country_list'] = $this->client->list_country();
                    //$this->data['company_list'] = $this->client->list_company();
                    //$this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                     $this->data['reminder_row'] = $this->reminder->row_reminder($id);
                    echo view('admin/parts/client-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/reminders/edit', $this->data);
            		echo view('admin/parts/client-form-footer');
            		echo view('admin/reminders/script');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   //echo "i is not equal to 0, 1 or 2";
            } 
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
    public function reminders_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'subject' => 'required|alpha_space|max_length[600]',
            'schedule_date'=> 'required',
            'status' => 'permit_empty'
        ]);
        

        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        $schedule_date = $this->request->getPost('schedule_date');
        $completed_date = $this->request->getPost('completed_date');
        $status = $this->request->getPost('status');
        $priority = $this->request->getPost('priority');
        if($operation == 'Add'){
            
            $this->reminder->save([
				'subject'	   =>	$this->request->getPost('subject'),
				'scheduled_date'	   =>	(!empty($schedule_date)) ? date('Y-m-d',strtotime($schedule_date)) : date('Y-m-d'),
				'status' =>	(!empty($status) && !empty($completed_date)) ? 'C' : 'P',
                'completed_date' => (!empty($completed_date)) ? date('Y-m-d',strtotime($completed_date)) : '',
                'priority' => $priority,
                'financialYear_id' => $this->fyear,
				'createdBy' => $this->user_id,
				'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);
			echo json_encode(array('type'=>'success', 'message' => 'Reminder Added Suceesfully!', 'redirect'=> 'reminders'));
		    exit;
            
        } else if($operation == 'Edit'){
            $reminderID = $this->request->getPost('reminderID');
		    $reminderID = base64_decode($reminderID);
		    
            
		    $data = [
	            'subject'	   =>	$this->request->getPost('subject'),
				'scheduled_date'	   =>	(!empty($schedule_date)) ? date('Y-m-d',strtotime($schedule_date)) : date('Y-m-d'),
				'status' =>	(!empty($status) && !empty($completed_date)) ? 'C' : 'P',
                'completed_date' => (!empty($completed_date)) ? date('Y-m-d',strtotime($completed_date)) : '',
                'priority' => $priority,
				'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$this->reminder->update($reminderID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Reminder Updated Suceesfully!', 'redirect'=> 'reminders'));
		    exit;
        }
	}
	
    public function delete_reminder()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $reminderID = $this->request->getPost('reminderID');
	    $this->reminder->where('reminder_id', $reminderID)->delete($reminderID);
	    echo json_encode(array('type'=>'success', 'message' => 'Reminder Deleted Suceesfully!'));
		    exit;
	}

    public function reminders_ajax_list()
    {
        $postData = $_POST;
        //print_r($this->fyear);
        switch ($this->user_role) {
            case 1:
                $fdata = $this->reminder->getReminders($postData,$this->fyear, $this->user_id);
                break;
            case 2:
                $fdata = $this->reminder->getRemindersByCreators($postData,$this->fyear,$this->user_id);
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
        
        //$fdata = array();
        echo json_encode($fdata);
    }
	/*public function import()
	{
	    $access = getUserPrivilegeById($this->user_id, 10);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.client_import_admin_title');
                //$this->data['company_list'] = $this->client->list_company();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/import', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script-import');
                break;
            case 2:
                $this->data['title'] = lang('Text.client_import_admin_title');
                //$this->data['company_list'] = $this->client->list_company();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/clients/import', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/clients/script-import');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}*/
	
	

	
}