<?php

namespace App\Models;

use CodeIgniter\Model;

class FollowupModel extends Model
{
    protected $table = 'tbl_followup';

	protected $primaryKey = 'followup_id';

	protected $allowedFields = ['client_id', 'financial_year_id', 'company_id', 'invoice_id','salesman_id', 'Invoice_date', 'payment_terms','due_date','currency_id','invoice_amount','balance','is_followup_done','fc_currency_rate','invoice_amount_in_fc','balance_amount_in_fc','cust_ref_no','status','remarks','invoice_status','critical_level_id','createdBy', 'updatedBy', 'updatedDate'];
	
	public function row_followup($id)
	{
	   $followup_id = base64_decode($id);
        $query = $this->db->query("SELECT t1.client_id,t1.financial_year_id,t1.company_id,t1.invoice_id,t1.salesman_id,t1.Invoice_date,t1.payment_terms,t1.due_date,t1.currency_id,t1.invoice_amount,t1.invoice_status,t1.status,t1.cust_ref_no,t1.critical_level_id,t1.remarks, t2.code as Invoice_no FROM tbl_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE followup_id = '$followup_id'");
        $row = $query->getRow();
        return $row; 
	}
	
	public function delete_from_temp($followupID)
	{
	     //$query = $this->db->query("DELETE FROM tbl_temp_followup WHERE followup_id = '$followup_id'");
	     $builder = $this->db->table('tbl_temp_followup');
	     $builder->delete(['followup_id' => $followupID]);
	}
	public function fetch_invoice_followup($clients = array(),$salesman_id = 0, $invoicedate = '', $priority = 0, $company = 0,$currency=0, $fyear)
	{
	     $where = '';
	    if(!empty($clients)){
	        $idString = implode(",", $clients);
	        $where .= " AND t1.client_id IN ($idString)";
	    }
	    
	    /*if(!empty($salesman_id)){
	        $where .= " AND t1.invoice_id IN ($salesman_id)";
	    }*/
	    
	    if(!empty($invoicedate)){
	        //explode
	        $invdates = explode("-",$invoicedate);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.Invoice_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if(!empty($priority)){
	        $where .= " AND t1.critical_level_id IN ($priority)";
	    }
	    
	    if(!empty($company)){
	        $where .= " AND t1.company_id IN ($company)";
	    }
	     if(!empty($currency)){
	        $where .= " AND t1.currency_id IN ($currency)";
	    }
	     //echo $idString;getResultArray
	     if(!empty($salesman_id)){
	         $where .= " AND t1.salesman_id IN ($salesman_id)";
	     }
	         
	        /* $sql = "SELECT t1.followup_id,t1.client_id,t1.financial_year_id,t1.company_id,t1.invoice_id,DATE_FORMAT(t1.Invoice_date, '%d-%c-%Y') as Invoice_date,t1.payment_terms,DATE_FORMAT(t1.due_date, '%d-%c-%Y') as due_date,t1.currency_id,t1.invoice_amount,t1.balance,t1.invoice_status,t1.status,t1.critical_level_id, t2.name as clientname, t3.code as currency_code, t4.code as Invoice_no FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id INNER JOIN tbl_currency_m t3 ON t3.currency_id = t1.currency_id INNER JOIN tbl_invoices t4 ON t1.invoice_id = t4.invoice_id  INNER JOIN tbl_followup_details t5 ON t5.followup_id = t1.followup_id WHERE  t1.invoice_status = 'O' $where ORDER BY t1.followup_id DESC";
	         
	         $query = $this->db->query($sql);
    	     $rowz = $query->getResultArray();
	         return $rowz;
	     } else {*/
	          $sql = "SELECT t1.followup_id,t1.client_id,t1.financial_year_id,t1.company_id,t1.invoice_id,DATE_FORMAT(t1.Invoice_date, '%d-%c-%Y') as Invoice_date,t1.payment_terms,DATE_FORMAT(t1.due_date, '%d-%c-%Y') as due_date,t1.currency_id,t1.invoice_amount,t1.balance,t1.invoice_status,t1.status,t1.critical_level_id,t1.salesman_id, t2.name as clientname, t3.code as currency_code, t4.code as Invoice_no FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id INNER JOIN tbl_currency_m t3 ON t3.currency_id = t1.currency_id INNER JOIN tbl_invoices t4 ON t1.invoice_id = t4.invoice_id WHERE  t1.invoice_status = 'O' $where ORDER BY t1.followup_id DESC";
    	     $query = $this->db->query($sql);
    	     $rowz = $query->getResultArray();
    	     $followups = array();
    	     foreach($rowz as $row){
    	         $fid = $row['followup_id'];
    	         $sql = "SELECT followup_details_id,followup_id,salesman_id,last_follow_up_date,expected_amount,expected_payment_date,next_followup_date,remarks,createdBy,updatedBy,status FROM tbl_followup_details WHERE followup_id =$fid AND status = 'A'";
    	        $query = $this->db->query($sql);
    	        $srow = $query->getRow();
    	        $row['details'] = $srow;
    	        $followups[] = $row;
    	     }
             return $followups;
	     //}
	    
	}
	public function save_all_followups($followups = array())
	{
	    $builder = $this->db->table('tbl_followup');
        $sta = $builder->insertBatch($followups);
        return $sta;
	}
	
	public function insert_followup_data($followups = array())
	{
	    if (empty($followups)){
	        return false;
	    }
	    $builder = $this->db->table('tbl_followup');
		$builder->insert($followups);
		return $this->db->insertID();
	}
	public function insert_followup_data_copy($followups = array())
	{
	    if (empty($followups)){
	        return false;
	    }
	    $builder = $this->db->table('tbl_temp_followup');
		$builder->insert($followups);
		return $this->db->insertID();
	}
	public function update_followup_data_copy($fid, $data)
	{
	    if (empty($fid)){
	        return false;
	    }
	    $builder = $this->db->table('tbl_temp_followup');
		$builder->update($data, ['followup_id' => $fid]);
		return $this->db->affectedRows() == 1;
	}
	public function row_currency($curid){
	    $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m WHERE currency_id = '$curid'");
        $row = $query->getRow();
        return $row;
	}
	
	public function row_invoice($invoiceid){
	    $query = $this->db->query("SELECT invoice_id,code FROM tbl_invoices WHERE invoice_id = '$invoiceid'");
        $row = $query->getRow();
        return $row;
	}
	
	public function row_details($fid)
	{
	    $query = $this->db->query("SELECT * FROM tbl_followup_details WHERE followup_id = '$fid' AND status = 'A'");
        $row = $query->getRow();
        return $row;
	}
	public function getFollowups($postData=null, $fyear = 0, $user_id = 0, $user_role = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
         
        // Custom search filter 
         $searchClient = $postData['searchClient'];
         $searchCompany = $postData['searchCompany'];
         $searchStatus = $postData['searchStatus'];
         $searchPriority = $postData['searchPriority'];
         $searchFollowdate = $postData['searchFollowdate'];
        ## Search 
        
        $builder = $this->db->table('tbl_followup');
        $builder->select('*');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
        $builder->where('tbl_followup.financial_year_id', $fyear);
         $builder->where('tbl_followup.invoice_status', 'O');
        //$builder->where('tbl_followup_details.status', 'A');
         $totalRecords = $builder->countAllResults();
        
        
        
        $builder->select('*');
       
        if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        // $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('tbl_followup.Invoice_date >=', $date1);
	        $builder->where('tbl_followup.Invoice_date <=', $date2);
	        //$builder->where('tbl_followup_details.status', 'A');
	       
	    }
	    $builder->where('tbl_followup.invoice_status', 'O');
        $builder->where('tbl_followup.financial_year_id', $fyear);
        

        $totalRecordwithFilter = $builder->countAllResults();
        
        $builder->select('*');
        
         if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        // $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('tbl_followup.Invoice_date >=', $date1);
	        $builder->where('tbl_followup.Invoice_date <=', $date2);
	        //$builder->where('tbl_followup_details.status', 'A');
	       
	    }
	    $builder->where('tbl_followup.invoice_status', 'O');
        $builder->where('tbl_followup.financial_year_id', $fyear);
        
        if(!empty($columnName)){
            if($columnName == 'invoice'){
                $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id', 'inner');
                $builder->orderBy('tbl_invoices.code', $columnSortOrder);
            } else if ($columnName == 'invoicedate'){
                $builder->orderBy('tbl_followup.Invoice_date', $columnSortOrder);
            }
            
            
        }
        //$builder->orderBy('updatedDate', 'Desc');
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
       
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            $invoice_data = $this->row_invoice($record->invoice_id);
            
            $details = $this->row_details($record->followup_id);
           
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            if($record->critical_level_id == 1){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="">'.$level.'</span>';
            }
            //<a href="'. base_url() .'/followup/edit/'. base64_encode($record->followup_id) .'" class="btn btn-primary btn-sm btn-flat">Edit</a>
            
            $access = getUserPrivilegeById($user_id, 11); 
            $button = '';
            if($user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
            $button .= '<a href="'. base_url() .'/followup/add/'. base64_encode($record->client_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Add" data-id="'.$record->client_id.'"><i class="fas fa-plus"></i></a><a href="'. base_url() .'/followup/details/'. base64_encode($record->followup_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Details"><i class="fas fa-file-alt"></i></a>';
            }
            
            
            /*<button class="btn btn-danger btn-sm btn-flat btn-followup-delete btn-rms" data-id="'.$record->followup_id.'" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button>*/
           $data[] = array( 
             "invoice"=>$invoice_data->code,
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "amt"=>$record->invoice_amount,
             "balance"=>$record->balance,
             "followupdate"=> (isset($details->last_follow_up_date)) ? date('d-m-Y', strtotime($details->last_follow_up_date)) : '',//date('d-m-Y', strtotime($record->last_follow_up_date))
             "nfollowupdate"=> (isset($details->next_followup_date)) ? date('d-m-Y', strtotime($details->next_followup_date)) : '',
             "sman"=>get_salesman($record->salesman_id),
             "rmarks"=>(isset($details->remarks)) ? $details->remarks : $record->remarks,
             "paymentterms"=>$record->payment_terms,
             "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "currency"=>$currency_data->code,
             "invoicestatus"=>$status,
             "company"=>get_company($record->company_id),
             "priority"=> $priority,
             
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	
	public function getFollowupsByCreators($postData=null, $fyear = 0, $user_id = 0, $user_role = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
         
        // Custom search filter 
         $searchClient = $postData['searchClient'];
         $searchCompany = $postData['searchCompany'];
         $searchStatus = $postData['searchStatus'];
         $searchPriority = $postData['searchPriority'];
         $searchFollowdate = $postData['searchFollowdate'];
         
        ## Search 
        
        $builder = $this->db->table('tbl_followup');
        $builder->select('*');
        $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id');
        $builder->where('tbl_followup.financial_year_id', $fyear);
        $builder->where('tbl_followup_details.createdBy', $user_id);
        $builder->where('tbl_followup_details.status', 'A');
        $totalRecords = $builder->countAllResults();
        
        
        $builder->select('*');
        $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id');
        if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('last_follow_up_date >=', $date1);
	        $builder->where('last_follow_up_date <=', $date2);
	        //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
	    }
        $builder->where('tbl_followup.financial_year_id', $fyear);
        $builder->where('tbl_followup_details.createdBy', $user_id);
        $builder->where('tbl_followup_details.status', 'A');
        $totalRecordwithFilter = $builder->countAllResults();
        
        $builder->select('*');
        $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id');
         if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('last_follow_up_date >=', $date1);
	        $builder->where('last_follow_up_date <=', $date2);
	        //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
	    }
        $builder->where('tbl_followup.financial_year_id', $fyear);
        $builder->where('tbl_followup_details.createdBy', $user_id);
        $builder->where('tbl_followup_details.status', 'A');
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
        
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            $invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            if($record->critical_level_id == 1){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="">'.$level.'</span>';
            }
            //<a href="'. base_url() .'/followup/edit/'. base64_encode($record->followup_id) .'" class="btn btn-primary btn-sm btn-flat">Edit</a>
            $button = '';
            if($user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
            $button .= '<a href="'. base_url() .'/followup/add/'. base64_encode($record->client_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Add" data-id="'.$record->client_id.'"><i class="fas fa-plus"></i></a><a href="'. base_url() .'/followup/details/'. base64_encode($record->followup_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Details"><i class="fas fa-pencil-alt"></i></a>';
            }
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "invoice"=>$invoice_data->code,
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "amt"=>$record->invoice_amount,
             "balance"=>$record->balance,
             "followupdate"=> date('d-m-Y', strtotime($record->last_follow_up_date)),
             "nfollowupdate"=> date('d-m-Y', strtotime($record->next_followup_date)),
             "sman"=>get_salesman($record->salesman_id),
             "rmarks"=>$record->remarks,
             "paymentterms"=>$record->payment_terms,
             "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "currency"=>$currency_data->code,
             "invoicestatus"=>$status,
             "company"=>get_company($record->company_id),
             "priority"=> $priority,
             
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	
	public function getInvoices($postData=null, $fyear = 0, $fcur = 0, $user_id = 0, $user_role = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
         
        // Custom search filter 
         $searchClient = $postData['searchClient'];
         //$searchPriority = $postData['searchPriority'];
         $searchInvdate = $postData['searchInvdate'];
         $searchInvStatus = $postData['searchInvStatus'];
         $searchCompany = $postData['searchCompany'];

         
        ## Search 
        
        $builder = $this->db->table('tbl_followup');
        $builder->where('financial_year_id', $fyear);
        $totalRecords = $builder->countAllResults();
        
        if($searchClient != ''){
            $builder->where('client_id', $searchClient);
            
        }
        /*if($searchPriority != ''){
            $builder->where('critical_level_id', $searchPriority);
            
        }*/
        if($searchCompany != ''){
            $builder->where('company_id', $searchCompany);
            
        }
        if(!empty($searchInvdate)){
	        //explode
	        $invdates = explode("-",$searchInvdate);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $builder->where('Invoice_date >=', $date1);
	        $builder->where('Invoice_date <=', $date2);
	        //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
	    }
        if($searchInvStatus != ''){
            $builder->where('invoice_status', $searchInvStatus);
            
        }
        
        $builder->where('financial_year_id', $fyear);
        $totalRecordwithFilter = $builder->countAllResults();
        
         if($searchClient != ''){
            $builder->where('client_id', $searchClient);
            
        }
        /*if($searchPriority != ''){
            $builder->where('critical_level_id', $searchPriority);
            
        }*/
        if($searchCompany != ''){
            $builder->where('company_id', $searchCompany);
            
        }
        if(!empty($searchInvdate)){
            //explode
            $invdates = explode("-",$searchInvdate);
            $date1 = date('Y-m-d', strtotime($invdates[0]));
            $date2 = date('Y-m-d', strtotime($invdates[1]));
            $builder->where('Invoice_date >=', $date1);
            $builder->where('Invoice_date <=', $date2);
            //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
        }
        if($searchInvStatus != ''){
            $builder->where('invoice_status', $searchInvStatus);
            
        }
        $builder->where('financial_year_id', $fyear);
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
        
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            $invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            if($record->critical_level_id == 1){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="">'.$level.'</span>';
            }
            $access = getUserPrivilegeById($user_id, 11); 
            $button = '';
            if($user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
            $button .= '<a href="'. base_url() .'/followup/invoiceedit/'. base64_encode($record->followup_id) .'" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Edit"><i class="fas fa-pencil-alt"></i></a>';
            }
            if($user_id == 1 || (isset($access->deleteStatus) && $access->deleteStatus == 1)) {
            $button .= '<button class="btn btn-danger btn-sm btn-flat btn-invoice-delete btn-rms" data-id="'.$record->followup_id.'" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button>';
            }
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "invoice"=>$invoice_data->code,
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "currency"=>$currency_data->code,
             "invamt"=>$record->invoice_amount,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "amtfc"=>$record->invoice_amount_in_fc,
             "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "salesman"=>get_salesman($record->salesman_id),
             "paymentterms"=>$record->payment_terms,
             "invoicestatus"=>$status,
             "company"=>get_company($record->company_id),
             "priority"=> $priority,
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	
	public function getInvoicesByCreators($postData=null, $fyear = 0, $user_id=0, $user_role = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
         
        // Custom search filter 
         $searchClient = $postData['searchClient'];
         //$searchPriority = $postData['searchPriority'];
         $searchInvdate = $postData['searchInvdate'];
         $searchInvStatus = $postData['searchInvStatus'];
         $searchCompany = $postData['searchCompany'];
        ## Search 
        
        $builder = $this->db->table('tbl_followup');
        $builder->where('financial_year_id', $fyear);
        $builder->where('createdBy', $user_id);
        $totalRecords = $builder->countAllResults();
        
        if($searchClient != ''){
            $builder->where('client_id', $searchClient);
            
        }
        /*if($searchPriority != ''){
            $builder->where('critical_level_id', $searchPriority);
            
        }*/
        if($searchCompany != ''){
            $builder->where('company_id', $searchCompany);
            
        }
        if(!empty($searchInvdate)){
            //explode
            $invdates = explode("-",$searchInvdate);
            $date1 = date('Y-m-d', strtotime($invdates[0]));
            $date2 = date('Y-m-d', strtotime($invdates[1]));
            $builder->where('Invoice_date >=', $date1);
            $builder->where('Invoice_date <=', $date2);
            //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
        }
        if($searchInvStatus != ''){
            $builder->where('invoice_status', $searchInvStatus);
            
        }
        $builder->where('financial_year_id', $fyear);
        $builder->where('createdBy', $user_id);
        $totalRecordwithFilter = $builder->countAllResults();
        
         if($searchClient != ''){
            $builder->where('client_id', $searchClient);
            
        }
        /*if($searchPriority != ''){
            $builder->where('critical_level_id', $searchPriority);
            
        }*/
        if($searchCompany != ''){
            $builder->where('company_id', $searchCompany);
            
        }
        if(!empty($searchInvdate)){
            //explode
            $invdates = explode("-",$searchInvdate);
            $date1 = date('Y-m-d', strtotime($invdates[0]));
            $date2 = date('Y-m-d', strtotime($invdates[1]));
            $builder->where('Invoice_date >=', $date1);
            $builder->where('Invoice_date <=', $date2);
            //$where .= " AND t1.due_date BETWEEN '$date1' AND '$date2'";
        }
        if($searchInvStatus != ''){
            $builder->where('invoice_status', $searchInvStatus);
            
        }
        $builder->where('financial_year_id', $fyear);
        $builder->where('createdBy', $user_id);
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
        
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            $invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            if($record->critical_level_id == 1){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="">'.$level.'</span>';
            }
            //$user_id
            $access = getUserPrivilegeById($user_id, 11); 
            $button = '';
            if($user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
            $button = '<a href="'. base_url() .'/followup/invoiceedit/'. base64_encode($record->followup_id) .'" class="btn btn-primary btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Edit"><i class="fas fa-pencil-alt"></i></a>';
            }
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "invoice"=>$invoice_data->code,
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "currency"=>$currency_data->code,
             "invamt"=>$record->invoice_amount,
             "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "salesman"=>get_salesman($record->salesman_id),
             "paymentterms"=>$record->payment_terms,
             "invoicestatus"=>$status,
             "company"=>get_company($record->company_id),
             "priority"=> $priority,
             "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
}