<?php

namespace App\Models;

use CodeIgniter\Model;

class UsersModel extends Model
{
    protected $table = 'tbl_user_m';

	protected $primaryKey = 'user_id';

	protected $allowedFields = ['userType_id', 'userName', 'password', 'email', 'createdBy', 'updatedBy', 'updatedDate', 'isActive', 'loginStatus', 'mail_sent_at'];
	
	public function mail_updated_at($user_id)
	{
	    $builder = $this->db->table('tbl_user_m');
		$builder->update(['mail_sent_at' => date('Y-m-d H:i:s')], ['user_id' => $user_id]);
		return $this->db->affectedRows() == 1;
	}
	
	/*public function verify_token($token)
	{
	    
	}*/
}