
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminLTE 3 | Forgot Password (v2)</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- toastr bootstrap -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/toastr/toastr.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/dist/css/adminlte.min.css">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="<?php echo base_url() ?>" class="h1"><b>Admin</b>RMS</a>
    </div>
    <div class="card-body">
      <p class="login-box-msg">You forgot your password? Here you can easily retrieve a new password.</p>
      <form id="forgotForm" action="<?php echo base_url() ?>/home/send_forgot_password_email" method="post">
        <div class="input-group mb-3">
          <input type="email" class="form-control" placeholder="Email" name="email" id="email">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <button id="btn-login" type="submit" class="btn btn-primary btn-block">Request new password</button>
          </div>
          <!-- /.col -->
        </div>
      </form>
      <p class="mt-3 mb-1">
        <a href="<?php echo base_url() ?>">Login</a>
      </p>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?php echo base_url() ?>/public/plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo base_url() ?>/public/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- jquery-validation -->
<script src="<?php echo base_url() ?>/public/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="<?php echo base_url() ?>/public/plugins/jquery-validation/additional-methods.min.js"></script>
<!-- toastr modal -->
<script src="<?php echo base_url() ?>/public/plugins/toastr/toastr.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url() ?>/public/dist/js/adminlte.min.js"></script>
<script>
$(function () {
    
    function login_submit() {
       // $('#btn-login i').addClass('fa-refresh fa-spin');
       $('#btn-login').prop('disabled', true);
       $.post("<?php echo base_url('home/send_forgot_password_email') ?>", $('#forgotForm').serialize(), function (data) {
           $('#btn-login').prop('disabled', false);
           if (data.type == 'success'){
	  					toastr.success(data.message);
	  			} else {
	  				
	  				toastr.error(data.message);
	  				//$('#btn-login i').removeClass('fa-refresh fa-spin');
	  			}
       }, 'json')
    }
  $.validator.setDefaults({
    submitHandler: function () {
      login_submit();
    }
  });
  $('#forgotForm').validate({
    rules: {
      email: {
        required: true,
       /* minlength: 5*/
        /*email: true,*/
      }
    },
    messages: {
      email: {
        required: "Please enter a email address / username",
        /*minlength: "Your username must be at least 5 characters long"*/
      }
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.input-group').append(error);
    },
    highlight: function (element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
</body>
</html>
