<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Libraries\UserAuth;
use App\Models\SettingsModel;
/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */

class BaseController extends Controller
{
	/**
	 * An array of helpers to be loaded automatically upon
	 * class instantiation. These helpers will be available
	 * to all other controllers that extend BaseController.
	 *
	 * @var array
	 */
	protected $helpers = ['custom'];
	public $user_id;
    public $user_name;
    public $user_email;
    public $user_role;
    public $fyear;
    public $fc_currency;
    protected $auth;
    public $data = [];
    
	/**
	 * Constructor.
	 *
	 * @param RequestInterface  $request
	 * @param ResponseInterface $response
	 * @param LoggerInterface   $logger
	 */
	public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
	{
		// Do Not Edit This Line
		parent::initController($request, $response, $logger);

		//--------------------------------------------------------------------
		// Preload any models, libraries, etc, here.
		//--------------------------------------------------------------------
		// E.g.: $this->session = \Config\Services::session();
		$this->session = \Config\Services::session();
		$this->db = \Config\Database::connect();
		
		$settings = $this->get_settings();
		
		$this->user_id      =   $this->session->get('user_id');
		$this->user_name    =   $this->session->get('user_name');
		$this->user_email   =   $this->session->get('user_email');
		$this->user_role    =   $this->session->get('user_role');
		$this->fyear        =  $this->get_active_fyear();
		$this->fc_currency  =  $settings->functionalCurrency_id;
		
		$this->data['user_id'] = $this->session->get('user_id');
		$this->data['user_name'] = $this->session->get('user_name');
		$this->data['user_email'] = $this->session->get('user_email');
		$this->data['user_role'] = $this->session->get('user_role');
		$this->data['fyear'] = $this->fyear;
		$this->data['title'] = '';
		
		
	}
	
	public function is_redirect_to_login()
	{
		$this->auth = new UserAuth();// loads and creates instance 
		if (!$this->auth->logged_in()) {
           header("Location:".base_url());
           exit;
        }
	}
	
	public function redirect_to_dashboard_if_not_admin_role()
	{
	    $this->auth = new UserAuth();// loads and creates instance
		if (!$this->auth->is_admin()) {
		    
           header("Location:".base_url('/dashboard'));
           exit;
        }
	}
	
	public function get_active_fyear()
	{
	    $settingsModel = new SettingsModel();
	    return $settingsModel->active_fyear();
	}
	
	public function get_settings()
	{
	    $settingsModel = new SettingsModel();
	    return $settingsModel->site_settings();
	}
	
	public function get_email_settings()
	{
	    $settingsModel = new SettingsModel();
	    return $settingsModel->email_settings();
	}
	
	public function send_email_rms($to, $subject, $message, $image = null)
	{
	    $config['mailType'] = 'html';
	    
	    $email = \Config\Services::email();
	    $email->initialize($config);
        $settings = $this->get_email_settings();
        $email->setFrom($settings->fromemail, $settings->fromname);
        $email->setTo($to);
        //$email->setCC('another@another-example.com');
        //$email->setBCC('them@their-example.com');
        
        $email->setSubject($subject);
        $email->setMessage($message);
        
        if ($email->send()) {
            return TRUE;
        } else {
            //$data = $email->printDebugger(['headers']);
            //print_r($data);
            return FALSE;
        }
	}
	
	public function template_register($message, $image = null){
	    $template = '';
	    $src = (!empty($image)) ? $image : 'https://gallery.mailchimp.com/108b19dfcf418dbca9e8ab4e6/images/bd7542ed-1b66-4ebb-949d-a2e00caa7dcc.jpg';                    
        $template .= file_get_contents(APPPATH . '/Views/mail/template/header.php');
        $template .='<img src="'.$src.'" style="border: 0;border-radius: 8px 8px 0 0;display: block;outline: none;text-decoration: none;height: auto;width: 100%;line-height: 100%;" width="600" alt="invite_header.jpg">';
        $template .= file_get_contents(APPPATH . '/Views/mail/template/header-split.php');
        $template .= $message;
        $template .= file_get_contents(APPPATH . '/Views/mail/template/footer.php');
        return $template;
	}
	
	
}
