<?php
namespace App\Controllers;
use App\Models\FollowupModel;
use App\Models\InvoiceModel;
use App\Models\ClientsModel;
use App\Models\SalesmanModel;
use App\Models\FyearModel;
use App\Models\CurrencyModel;
use App\Models\FollowupdetailsModel;
use CodeIgniter\HTTP\RequestInterface;
use App\Models\CompanyModel;
use App\Models\PriorityModel;
use App\Models\IssuetypeModel;
use App\Models\TemplateModel;
class Followup extends BaseController
{
    public function __construct()
	{
	    $this->is_redirect_to_login();
        
	    $this->followup = new FollowupModel();
	    $this->client = new ClientsModel();
	    $this->finance = new FyearModel();
	    $this->currency = new CurrencyModel();
	    $this->details = new FollowupdetailsModel();
	    $this->invoice = new InvoiceModel();
	    $this->company = new CompanyModel();
	    $this->level = new PriorityModel();
        $this->template = new TemplateModel();
	}
	public function index()
	{
	    switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.followup_admin_title');
                
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['priority_list'] =  $this->level->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/list', $this->data);
        		echo view('admin/parts/followup-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.followup_admin_title');
                 $this->data['clients_list'] = $this->client->where('createdBy', (int)$this->user_id)->findAll();
                 $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                 $this->data['priority_list'] =  $this->level->findAll();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/list', $this->data);
        		echo view('admin/parts/followup-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	
	public function invoices()
	{
	    switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.invoices_admin_title');
                
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                //$this->data['priority_list'] =  $this->level->findAll();
                $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/invoices', $this->data);
        		echo view('admin/parts/invoices-list-footer');
                break;
            case 2:
                //echo $this->user_id;
                $this->data['title'] = lang('Text.invoices_admin_title');
                 $this->data['clients_list'] = $this->client->where('createdBy', (int)$this->user_id)->findAll();
                 //$this->data['priority_list'] =  $this->level->findAll();
                 $this->data['company_list'] = $this->company->where('status', 1)->findAll();
                $this->data['curr_data'] = $this->currency->where('currency_id', $this->fc_currency)->first();
                echo view('admin/parts/client-list-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/invoices', $this->data);
        		echo view('admin/parts/invoices-list-footer');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	public function invoiceadd()
	{
	    $access = getUserPrivilegeById($this->user_id, 11);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.invoices_add_admin_title');
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                $this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                $this->data['company_list'] = $this->client->list_company();
                $this->salesman = new SalesmanModel();
		        $this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/invoice-add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/script-edit');
                break;
            case 2:
                $this->data['title'] = lang('Text.invoices_add_admin_title');
                $this->data['clients_list'] = $this->client->where('status', 1)->where('createdBy', (int)$this->user_id)->findAll();
                $this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                $this->data['company_list'] = $this->client->list_company();
                
                $this->salesman = new SalesmanModel();
		        $this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/invoice-add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/script-edit');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	public function add($client_id = 0){
	    $access = getUserPrivilegeById($this->user_id, 12);
        $this->data['templates'] = $this->template->where('mailgroup', 'followup')->find();
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.followup_add_admin_title');
                $this->data['search_client'] = base64_decode($client_id);
                $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                //$this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                $this->salesman = new SalesmanModel();
		        $this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
		        $this->data['priority_list'] =  $this->level->findAll();
		        $this->data['company_list'] = $this->client->list_company();
                
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/script');
                break;
            case 2:
                $this->data['title'] = lang('Text.followup_add_admin_title');
                $this->data['search_client'] = base64_decode($client_id);
                 $this->data['clients_list'] = $this->client->where('status', 1)->where('createdBy', (int)$this->user_id)->findAll();
                //$this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                $this->salesman = new SalesmanModel();
		        $this->data['salesman_active_list'] = $this->salesman->where('status', 1)->where('salesman_id', (int)$this->user_id)->findAll();
		        $this->data['priority_list'] =  $this->level->findAll();
		        $this->data['company_list'] = $this->client->list_company();
		        
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/script');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function invoiceedit($id){
	    $access = getUserPrivilegeById($this->user_id, 11);
	    if($this->user_id == 1 || (isset($access->editStatus) && $access->editStatus == 1)) {
	    
    	    $this->data['follow_up_id'] = $id;
    	    $this->data['followup_row'] = $this->followup->row_followup($id);
    	    //print_r($this->data['followup_row']);exit;
    	    switch ($this->user_role) {
                case 1:
                    $this->data['title'] = lang('Text.invoices_edit_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['company_list'] = $this->client->list_company();
                    $this->data['priority_list'] =  $this->level->findAll();
                    $this->salesman = new SalesmanModel();
    		        $this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
                    echo view('admin/parts/client-form-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            	    $checkRecord = $this->details->where('followup_id',base64_decode($id))->countAllResults();
                    if ($checkRecord > 0){
                        echo view('admin/followup/editreadonly', $this->data);
                    }else {
            		    echo view('admin/followup/edit', $this->data);
                    }
            		
            		echo view('admin/parts/client-form-footer');
            		echo view('admin/followup/script-edit');
                    break;
                case 2:
                    $this->data['title'] = lang('Text.invoices_edit_admin_title');
                    $this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();
                    $this->data['company_list'] = $this->client->list_company();
                     $this->data['priority_list'] =  $this->level->findAll();
                     
                    echo view('salesman/parts/client-form-header', $this->data);
            	    echo view('salesman/parts/nav', $this->data);
            		echo view('salesman/followup/edit', $this->data);
            		echo view('salesman/parts/client-form-footer');
            		echo view('salesman/followup/script-edit');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   echo "i is not equal to 0, 1 or 2";
            }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function details($id = null){
	    if (empty($id)) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		$access = getUserPrivilegeById($this->user_id, 12);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
    	    $this->data['follow_up_id'] = $id;
    	    $follow_up_id = base64_decode($id);
    	    $this->data['followup_details_row'] = $this->details->list_followup_details($id);
    	    $this->data['followup_row'] = $this->followup->where('followup_id',$follow_up_id)->first();
    	    
    	    switch ($this->user_role) {
                case 1:
                    $this->data['title'] = lang('Text.invoices_admin_title');
                    /*$this->data['clients_list'] = $this->client->where('status', 1)->findAll();
                    $this->data['fyear_list'] = $this->finance->where('status', 1)->findAll();
                    $this->data['currency_list'] = $this->currency->where('status', 1)->findAll();*/
                    
                    echo view('admin/parts/client-list-header', $this->data);
            	    echo view('admin/parts/nav', $this->data);
            		echo view('admin/followup/details/list', $this->data);
            		echo view('admin/parts/client-list-footer');
            		//echo view('admin/followup/details/script');
                    break;
                case 2:
                    $this->data['title'] = lang('Text.invoices_admin_title');
                    //$this->data['country_list'] = $this->client->list_country();
                    echo view('salesman/parts/client-list-header', $this->data);
            	    echo view('salesman/parts/nav', $this->data);
            		echo view('salesman/followup/details/list', $this->data);
            		echo view('salesman/parts/client-list-footer');
            		//echo view('salesman/followup/details/script');
                    break;
                case 3:
                    //echo "i equals 2";
                    break;
                default:
                   echo "i is not equal to 0, 1 or 2";
            }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function delete_followup_det()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		$fid = $this->request->getPost('fID');
		$detailsID = $this->request->getPost('detailsID');
		
		$this->details->where('followup_details_id', $detailsID)->delete($detailsID);
		
		$checkRecord = $this->details->where('followup_id',$fid)->countAllResults();
		
		if($checkRecord > 0){
		    //$this->details->where('followup_id', $fid)->orderBy('followup_details_id','desc')->take(1)->update(['status' => 'A']);
		    $data = $this->details->get_max_id($fid);
		    $followup_details_id = $data->followup_details_id;
		    //print_r($this->db->error());
		    $this->details->update($followup_details_id, ['status' => 'A']);
		}
		//exit;
	    echo json_encode(array('type'=>'success', 'message' => 'Follow-up Deleted Suceesfully!'));
		    exit;
	}
	
	public function detailsadd($id = null){
	    if (empty($id)) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		$this->data['follow_up_id'] = $id;
		$follow_up_id = base64_decode($id);
		$this->data['followup_row'] = $this->followup->where('followup_id',$follow_up_id)->first();
		switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.invoices_add_admin_title');
        		$this->salesman = new SalesmanModel();
        		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
        		echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/details/add', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/details/script');
        		break;
            case 2:
                $this->data['title'] = lang('Text.invoices_add_admin_title');
                $this->salesman = new SalesmanModel();
        		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
        		echo view('salesman/parts/client-form-header', $this->data);
        	    echo view('salesman/parts/nav', $this->data);
        		echo view('salesman/followup/details/add', $this->data);
        		echo view('salesman/parts/client-form-footer');
        		echo view('salesman/followup/details/script');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	
	public function detailsedit($id = null){
	    if (empty($id)) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		$this->data['follow_up_det_id'] = $id;
		$this->data['followup_details_row'] = $this->details->row_followup_details($id);
		switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.invoices_edit_admin_title');
        		$this->salesman = new SalesmanModel();
        		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
        		 
        		echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/details/edit', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/details/script');
        		break;
            case 2:
                $this->data['title'] = lang('Text.invoices_edit_admin_title');
                $this->salesman = new SalesmanModel();
        		$this->data['salesman_active_list'] = $this->salesman->where('status', 1)->findAll();
        		 
        		echo view('salesman/parts/client-form-header', $this->data);
        	    echo view('salesman/parts/nav', $this->data);
        		echo view('salesman/followup/details/edit', $this->data);
        		echo view('salesman/parts/client-form-footer');
        		echo view('salesman/followup/details/script');
        		break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	}
	
	public function followup_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    switch ($this->user_role) {
	        case 1:
	            $fdata = $this->followup->getFollowups($postData,$this->fyear, $this->user_id, $this->user_role);
	            break;
	        case 2:
	            $fdata = $this->followup->getFollowupsByCreators($postData,$this->fyear, $this->user_id, $this->user_role);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";
	    }
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	
	public function invoices_ajax()
	{
	    $postData = $_POST;
	    //print_r($this->fyear);
	    switch ($this->user_role) {
	        case 1:
	            $fdata = $this->followup->getInvoices($postData,$this->fyear, $this->fc_currency, $this->user_id, $this->user_role);
	            break;
	        case 2:
	            $fdata = $this->followup->getInvoicesByCreators($postData,$this->fyear,$this->user_id, $this->user_role);
	            break;
	        default:
               echo "i is not equal to 0, 1 or 2";
	    }
	    //$fdata = array();
	    echo json_encode($fdata);
	}
	public function get_remark()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $followup_id = $this->request->getPost('followup_id');
	    $remark = '';
	    $data = $this->details->where('followup_id',$followup_id)->where('status','A')->first();
	    if(!empty($data)){
	      $remark =  $data['remarks']; 
	    }
	    
	    echo json_encode(array('type'=>'success', 'remark' => $remark));
		           exit; 
	}
	public function followup_invoice_search_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		/*$input = $this->validate([
            'client' => 'required'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }*/
        
        $clients = [];
        $parent_client = $this->request->getPost('client');
        if(!empty($parent_client)){
            $clients[] =  $parent_client;
        
            $client_data = $this->client->where('Parent_client', $parent_client)->findAll();
            foreach($client_data as $key => $data){
                $clients[] = $data['client_id'];
            }
        }
        
        $salesman_id = $this->request->getPost('salesman');
        
        $invoicedate = $this->request->getPost('invoicedate');
        
        $priority = $this->request->getPost('critical_level');
        $company = $this->request->getPost('sel_company');
        $currency = $this->request->getPost('currency');
        //get all followups 
        $followups = $this->followup->fetch_invoice_followup($clients, $salesman_id, $invoicedate, $priority, $company,$currency, $this->fyear);
        $this->salesman = new SalesmanModel();
		$salesman_active_list = $this->salesman->where('status', 1)->findAll();
		
		$this->issues = new IssuetypeModel();
		$issues_active_list = $this->issues->where('status', 1)->findAll();
		
		$priority_list =  $this->level->findAll();
		
        echo json_encode(array('type'=>'search', 'data' => $followups, 'datacount'=>count($followups), 'salesman'=> $salesman_active_list, 'priority' => $priority_list, 'issues' => $issues_active_list));
		    exit;
        /*$html = '';
        foreach($followups as $key => $val){
            $client_id = $val['client_id'];
            $client_name = $val['clientname'];
            $invoice_no = $val['Invoice_no'];
            $invoice_date = date('d-m-Y',strtotime($val['Invoice_date']));
            $html = '<tr>';
                $html .= '<td><select name="selclient[]" class="form-control" id="selclient'.$key.'" placeholder="Enter client"><option value="'.$client_id.'">'.$client_name.'</option></select></td>';
                $html .= '<td><input type="text" name="invoice_no[]" class="form-control" id="invoice_no'.$key.'" placeholder="Enter client" value="'.$invoice_no.'" readonly></td>';
                $html .= '<td><input type="text" name="invoice_date[]" class="form-control" id="invoice_date'.$key.'" placeholder="Enter client" value="'.$invoice_no.'"></td>';
            $html .= '<tr>';
        }*/
        // select all 
	}
	public function followup_crud_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		/*$input = $this->validate([
            'expected_amount.*' => 'required',
            'expected_date.*' => 'required',
            'next_followup_date.*' => 'required',
            'selSalesman.*' => 'required',
        ],
        [   // Errors
            'expected_amount.*' => [
                'required' => 'Expected Amount fields should not be empty!',
            ],
            'expected_date.*' => [
                'required' => 'Expected Date fields should not be empty!',
            ],
            'next_followup_date.*' => [
                'required' => 'Next Followup Date fields should not be empty!',
            ],
            'selSalesman.*' => [
                'required' => 'Salesman fields should not be empty!',
            ]
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }*/
        
        $operation = $this->request->getPost('operation');
        if($operation == 'Add'){
            $check = $this->request->getPost('check');
           $followup_id = $this->request->getPost('followup_id');
           $followups = array();
           if (count($check) > 0){
               $loop = count($followup_id);
               for ($i = 0; $i < $loop; $i++ ){
                   $chkitem = $_POST['chkitem'][$i];
                   if (!empty($chkitem)){
                        $fid = $_POST['followup_id'][$i];
                        $checkRecord = $this->details->where('followup_id',$fid)->countAllResults();
                       if ($checkRecord > 0){
                           //update status to inactive
                           $this->details->update_status_inactive($fid);
                       }
                       //update priority
                       $priority = $_POST['selPriority'][$i];
                       $res = $this->followup->update($fid, ['critical_level_id' => $priority]);
                       $followups[] = array(
                           'followup_id' => $_POST['followup_id'][$i],
                           'salesman_id' =>  $_POST['selSalesman'][$i],
                           'last_follow_up_date' => date('Y-m-d'),
                           'expected_amount' => $_POST['expected_amount'][$i],
                           'expected_payment_date' => date('Y-m-d',strtotime($_POST['expected_date'][$i])),
                           'next_followup_date' => date('Y-m-d',strtotime($_POST['next_followup_date'][$i])),
                           'remarks' => $_POST['remarks'][$i],
                           'issue_type'=>$_POST['selIssues'][$i],
                           'payment_type'=>$_POST['payType'][$i],
                           'status' => 'A',
                           'createdBy' => $this->user_id,
                           'updatedBy' => 0,
    				       'updatedDate' => '0000-00-00 00:00:00'
                        );
                   }
               }
               
               $status = $this->details->save_all_followup_details($followups);
               //print_r($this->db->error());
               //print_r($followups);exit;
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Followup Batch Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Followup Batch Not Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                }
           }
        }
        exit;
        
	}
	public function invoice_crud_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		$input = $this->validate([
            'client' => 'required',
            'invoice' => 'required|max_length[30]',
            'invoice_date' => 'required',
            //'payment_term' => 'required|numeric',
            'due_date' => 'required',
            'currency' => 'required',
            'invoice_amount' => 'required|decimal',
            'company' => 'required',
            'critical_level'=> 'permit_empty',
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
	    $operation = $this->request->getPost('operation');
        $invoice_date = $this->request->getPost('invoice_date');
        $due_date = $this->request->getPost('due_date');
        $currencyx = $this->request->getPost('currency');
        $invoice_amount = $this->request->getPost('invoice_amount');
        $salesman = $this->request->getPost('salesman');
        $functional_currency_id = $this->fc_currency;
         //get rate and date from currency table
            $curr_data = $this->currency->where('currency_id', $currencyx)->findAll();
            $fc_rate = $curr_data[0]['rate'];
            $fc_rate = (!empty($fc_rate)) ? $fc_rate : 1;
            $fc_date = $curr_data[0]['rateDate'];
        $invoice_fc_amount = 0;    
        if($currencyx == $functional_currency_id){
            $invoice_fc_amount = (float)$invoice_amount;
        } else {
           
            $invoice_fc_amount = (float)$invoice_amount * (float)$fc_rate;
        }
        
        $invoicecode = $this->request->getPost('invoice');
        $invoicedata = $this->invoice->where('code', $invoicecode)->where('financial_year', $this->fyear)->findAll();
        if (!empty($invoicedata)){
            $invoice_id = $invoicedata[0]['invoice_id'];
        } else {
            //insert invoice and get data
            $invoice = [
                    'code' => $invoicecode,
                    'financial_year' =>$this->fyear,
                    'invoice_status' => 'O'
                ];
            $invoice_id = $this->invoice->insert_invoice_data($invoice);
        }
        
        $checkrecord = $this->followup->where('invoice_id',$invoice_id)->where('financial_year_id',$this->fyear)->countAllResults();
        
        $status = $this->request->getPost('status');
        $invstatus = $this->request->getPost('invstatus');
        
        
        if($operation == 'Add'){
            
            if($checkrecord == 0){
                $fdata = [
    		        'client_id' => $this->request->getPost('client'),
    		        'financial_year_id'=> $this->fyear,
    		        'company_id' => $this->request->getPost('company'),
    		        'invoice_id'=> $invoice_id,//$salesman
    		        'salesman_id'=> (!empty($salesman)) ? $salesman : '',
    		        'Invoice_date'=> date('Y-m-d', strtotime($invoice_date)),
    				'payment_terms'=> $this->request->getPost('payment_term'),
    				'due_date'=> date('Y-m-d', strtotime($due_date)),
    				'currency_id'=> $currencyx,
    				'invoice_amount'=> $invoice_amount,
    				'balance'=> $invoice_amount,
    				'fc_currency_rate' => $fc_rate,
    				'fc_currency_date' => date('Y-m-d', strtotime($fc_date)),
    				'invoice_amount_in_fc' => $invoice_fc_amount,
    				'balance_amount_in_fc' => $invoice_fc_amount,
    				'cust_ref_no' => $this->request->getPost('cust_ref_no'),
    				'invoice_status' => 'O',
                    'createdBy' => $this->user_id,
                    'status' => (!empty($status)) ? 'A' : 'I',
                    'remarks' => $this->request->getPost('remarks'),
                    'updatedBy' => 0,
    				'updatedDate' => '0000-00-00 00:00:00'
    			];
    			
    			$followup_id = $this->followup->insert_followup_data($fdata);
    			if ($followup_id > 0){
    			    $fdatacopy = $fdata;
    			    $fdatacopy['followup_id'] = $followup_id;
    			    $fdatacopy['received_date'] = date('Y-m-d', strtotime($invoice_date));
    			    //here save same details to another table for history
    			    $this->followup->insert_followup_data_copy($fdatacopy);
    			}
    			
    			echo json_encode(array('type'=>'success', 'message' => 'Invoice Added Suceesfully!', 'redirect'=> 'followup/invoices'));
    		    exit;
                
            } else {
                echo json_encode(array('type'=>'error', 'message' => 'Invoice Exist!', 'redirect'=> 'followup/invoices'));
    		    exit;
            }
        } else if($operation == 'Edit'){
            $followupID = $this->request->getPost('followupID');
		    $followupID = base64_decode($followupID);
		    $data = [
	            'client_id' => $this->request->getPost('client'),
		        'financial_year_id'=> $this->fyear,
		        'company_id' => $this->request->getPost('company'),
		        'invoice_id'=> $invoice_id,
		        'salesman_id'=> (!empty($salesman)) ? $salesman : '',
		        'Invoice_date'=> date('Y-m-d', strtotime($invoice_date)),
				'payment_terms'=> $this->request->getPost('payment_term'),
				'due_date'=> date('Y-m-d', strtotime($due_date)),
				'currency_id'=> $currencyx,
				'invoice_amount'=> $invoice_amount,
				'balance'=> $invoice_amount,
				'fc_currency_rate' => $fc_rate,
				'fc_currency_date' => date('Y-m-d', strtotime($fc_date)),
				'invoice_amount_in_fc' => $invoice_fc_amount,
				'balance_amount_in_fc' => $invoice_fc_amount,
				'cust_ref_no' => $this->request->getPost('cust_ref_no'),
				'invoice_status' => (!empty($invstatus)) ? $invstatus : 'C',
				'critical_level_id' => $this->request->getPost('critical_level'),
                'createdBy' => $this->user_id,
                'status' => (!empty($status)) ? 'A' : 'I',
                'remarks' => $this->request->getPost('remarks'),
                'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$this->followup->update($followupID, $data);
        	$this->followup->update_followup_data_copy($followupID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Invoice Updated Suceesfully!', 'redirect'=> 'followup/invoices'));
		    exit;
        }
	}
	public function delete_followup()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
	    $followupID = $this->request->getPost('followupID');
	    $this->followup->where('followup_id', $followupID)->delete($followupID);
	    $this->followup->delete_from_temp($followupID);
	    
	    echo json_encode(array('type'=>'success', 'message' => 'Followup Deleted Suceesfully!'));
		    exit;
	}
	public function import()
	{
	    $access = getUserPrivilegeById($this->user_id, 12);
	    if($this->user_id == 1 || (isset($access->addStatus) && $access->addStatus == 1)) {
	        switch ($this->user_role) {
            case 1:
                $this->data['title'] = lang('Text.invoices_import_admin_title');
                $this->data['company_list'] = $this->client->list_company();
                echo view('admin/parts/client-form-header', $this->data);
        	    echo view('admin/parts/nav', $this->data);
        		echo view('admin/followup/import', $this->data);
        		echo view('admin/parts/client-form-footer');
        		echo view('admin/followup/script-import');
                break;
            case 2:
                $this->data['title'] = lang('Text.invoices_import_admin_title');
                $this->data['company_list'] = $this->client->list_company();
                echo view('salesman/parts/client-form-header', $this->data);
        	    echo view('salesman/parts/nav', $this->data);
        		echo view('salesman/followup/import', $this->data);
        		echo view('salesman/parts/client-form-footer');
        		echo view('salesman/followup/script-import');
                break;
            case 3:
                //echo "i equals 2";
                break;
            default:
               echo "i is not equal to 0, 1 or 2";
        }
	    } else {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
	    }
	}
	
	public function followup_import()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		helper(['form', 'url']);
		
		$input = $this->validate([
            'file' => 'uploaded[file]|max_size[file,1024]|ext_in[file,csv],'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        if($operation == 'import'){
            $file = $this->request->getFile('file');
            $file_name = $file->getTempName();
            $followups = array();
            $warnings = '';
            $txtwarnings = '';
            $warningcount = 0;
            $csv_data = array_map('str_getcsv', file($file_name));
            $csv_data_removed = array_shift($csv_data);
            //print_r($csv_data);exit;
            $functional_currency_id = $this->fc_currency;
            $totalrows = count($csv_data);
            if (count($csv_data) > 0) {
                foreach ($csv_data as $key => $data) {
                    $rowc = $key + 1;
                    $name = $data[0];
                    $invoice = $data[1];
                    $invoice_id = 0;
                    
                    $inv_date = str_replace('/', '-', $data[2]);
                    $due_date =  str_replace('/', '-', $data[4]);
                    
                    if(empty($invoice)){
                        $warningcount++;
                        $warnings .= '<p>Invoice is missing in row '.$rowc.'</p>';
                        $txtwarnings .= "\r\n Invoice is missing in row ".$rowc."\r\n";
                        continue;
                    }
                    if(empty($name)){
                        $warningcount++;
                        $warnings .= '<p>Client name is missing in row '.$rowc.'</p>';
                        $txtwarnings .= "\r\n Client name is missing in row ".$rowc."\r\n";
                        continue;
                    }
                    
                    
                    $invarr = explode('-',$inv_date);
                    $duearr = explode('-',$due_date);
                    if(strlen($invarr[2]) < 4){
                        $warningcount++;
                        $warnings .= '<p>Invoice year should have four digits  '.$rowc.'</p>';
                        $txtwarnings .= "\r\n Invoice year should have four digits ".$rowc."\r\n";
                        continue;
                    }
                    if(strlen($duearr[2]) < 4){
                        $warningcount++;
                        $warnings .= '<p>Due year should have four digits  '.$rowc.'</p>';
                        $txtwarnings .= "\r\n Due year should have four digits ".$rowc."\r\n";
                        continue;
                    }
                    //check client exist, id exist get client id
                    $checkClient = $this->client->where('name',$name)->countAllResults();
                    if($checkClient == 0){
                        $warningcount++;
                        $warnings .= '<p> Client <b>'.$name.'</b> is missing in database. Check csv row '.$rowc.'</p>';
                        $txtwarnings .= "\r\n Client ".$name." is missing in database. Check csv row ".$rowc."\r\n";
                    }
                    if($checkClient > 0){
                        $client_data = $this->client->where('name',$name)->find();
                        $client_id = $client_data[0]['client_id'];
                        $pterm = $client_data[0]['payment_term'];
                        
                         $invoicedata = $this->invoice->where('code', $invoice)->where('financial_year', $this->fyear)->findAll();
                            if (!empty($invoicedata)){
                                $invoice_id = $invoicedata[0]['invoice_id'];
                            } else {
                                //insert invoice and get data
                                $invoicesta = [
                                        'code' => $invoice,
                                        'financial_year' =>$this->fyear,
                                        'invoice_status' => 'O'
                                    ];
                                $invoice_id = $this->invoice->insert_invoice_data($invoicesta);
                            }
                    
                        $checkrecord = $this->followup->where('invoice_id',$invoice_id)->where('financial_year_id',$this->fyear)->countAllResults();
                        
                        if($checkrecord == 0){
                            $currencycode = (isset($data[5])) ? $data[5] : '';
                            $currency_id = '';
                            if(!empty($currencycode)){
                                $currency_data = $this->currency->where('code',$currencycode)->find();
                            
                                $currency_id = $currency_data[0]['currency_id'];
                            }
                            
                            
                           $followups[] = array(
                                "client_id" => $client_id,
                                "Invoice_no" => $invoice,
                                "Invoice_date" => (isset($data[2])) ? date('d-m-Y', strtotime($inv_date)) : '',
                                "payment_terms" => (isset($data[3]) && !empty($data[3])) ? $data[3] : $pterm,
                                "due_date" => (isset($data[4])) ? date('d-m-Y', strtotime($due_date)) : '',
                                "currency_id" => $currency_id,
                                "invoice_amount" => (isset($data[6])) ? $data[6] : '',
                                "cust_ref_no" => (isset($data[7])) ? $data[7] : '',
                                "sales_man_name" => (isset($data[8])) ? $data[8] : '',
                               /* "fc_currency_rate" => $fc_rate,
                                "fc_currency_date" => date('Y-m-d', strtotime($fc_date)),
				                "invoice_amount_in_fc" => $invoice_fc_amount,
                				"invoice_status" => 'O',
                                "status" =>'A',
                                "createdBy" => $this->user_id,
                                "updatedBy" => 0,
				                "updatedDate" => '0000-00-00 00:00:00'*/
                            );
                        } else {
                            $warningcount++;
                            $warnings .= '<p> Invoice <b>'.$invoice.'</b> is already in database. Check csv row '.$rowc.'</p>';
                            $txtwarnings .= "\r\n Invoice ".$invoice." is already in database. Check csv row ".$rowc."\r\n";
                        }
                        
                    }
                }
                
                //print_r($followups);exit;
                
                $processed  = (int)$totalrows - (int)$warningcount;
                //print_r($followups);exit;
                $txtfile = FCPATH.'public/errors.txt';
                $myfile = fopen($txtfile, "w") or die("Unable to open file!");
                fwrite($myfile, $txtwarnings);
                fclose($myfile);
                //file_put_contents($txtfile, $txtwarnings, FILE_APPEND);
                $all_clients = $this->client->findAll();
                $all_currency = $this->currency->findAll();
                $this->salesman = new SalesmanModel();
		        $salesman_active_list = $this->salesman->where('status', 1)->findAll();
                echo json_encode(array('type'=>'import', 'data' => $followups,'clients' => $all_clients,'salesman' => $salesman_active_list,'currencies' => $all_currency,'warningcount' => $warningcount,'warnings' => $warnings,'totalrows' => $totalrows,'processed' => $processed));
		        exit;
                /*$status = $this->followup->save_all_followups($followups);
                if($status){
                   echo json_encode(array('type'=>'success', 'message' => 'Followup Batch Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Followup Batch Not Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                }*/
            } else {
                echo json_encode(array('type'=>'error', 'message' => 'Csv file is empty!', 'redirect'=> 'followup'));
		        exit;
            }
        }
	}
	
	
	public function ajax_followup_import()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'selclient.*' => 'required',
            'invoice_no.*' => 'required',
            'invoice_date.*' => 'required',
            'terms.*' => 'required',
            'due_date.*' => 'required',
            'selCurrency.*' => 'required',
            'invoice_amount.*' => 'required',
            'company' => 'required',
        ],
        [   // Errors
            'selclient.*' => [
                'required' => 'Client fields should not be empty!',
            ],
            'invoice_no.*' => [
                'required' => 'Invoice No fields should not be empty!',
            ],
            'invoice_date.*' => [
                'required' => 'Invoice Date fields should not be empty!',
            ],
            'terms.*' => [
                'required' => 'Payment Terms fields should not be empty!',
            ],
            'due_date.*' => [
                'required' => 'Due date fields should not be empty!',
            ],
            'selCurrency.*' => [
                'required' => 'Currency fields should not be empty!',
            ],
            'invoice_amount.*' => [
                'required' => 'Invoice amount fields should not be empty!',
            ]
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        $status = false;
        $operation = $this->request->getPost('operation');
        $functional_currency_id = $this->fc_currency;
        if($operation == 'importajax'){
            $selclient = $this->request->getPost('selclient');
            $company_id = $this->request->getPost('company');
            if (count($selclient) > 0){
                $loop = count($selclient);
                $followups = array();
                for ($i = 0; $i < $loop; $i++ ){
                    $currencyid = $_POST['selCurrency'][$i];
                    $currency_data = $this->currency->where('currency_id',$currencyid)->find();
                    $fc_rate = $currency_data[0]['rate'];
                    $fc_rate = (!empty($fc_rate)) ? $fc_rate : 1;
                    $fc_date = $currency_data[0]['rateDate'];
                    $invoice_fc_amount = 0; 
                    $invoice_amount = $_POST['invoice_amount'][$i];
                    if($currencyid == $functional_currency_id){
                        $invoice_fc_amount = (float)$invoice_amount;
                    } else {
                       
                        $invoice_fc_amount = (float)$invoice_amount * (float)$fc_rate;
                    }
                    $invoicecode = $_POST['invoice_no'][$i];
                    $invoicedata = $this->invoice->where('code', $invoicecode)->where('financial_year', $this->fyear)->findAll();
                    if (!empty($invoicedata)){
                        $invoice_id = $invoicedata[0]['invoice_id'];
                    } else {
                        //insert invoice and get data
                        $invoice = [
                                'code' => $invoicecode,
                                'financial_year' =>$this->fyear,
                                'invoice_status' => 'O'
                            ];
                        $invoice_id = $this->invoice->insert_invoice_data($invoice);
                    }
                    
                    $checkrecord = $this->followup->where('invoice_id',$invoice_id)->where('financial_year_id',$this->fyear)->countAllResults();
                    
                    if($checkrecord == 0){
                        $invoice_date = $_POST['invoice_date'][$i];
                        $salesman = $_POST['selSalesman'][$i];
                        //$followups[]
                         $fdata = array(
                            "client_id" => $_POST['selclient'][$i],
                            "invoice_id" => $invoice_id,
                            "financial_year_id" => $this->fyear,
                            "company_id" => $company_id,
                            'salesman_id'=> (!empty($salesman)) ? $salesman : 0,
                            "Invoice_date" => (isset($invoice_date)) ? date('Y-m-d', strtotime($invoice_date)) : '',
                            "payment_terms" => $_POST['terms'][$i],
                            "due_date" => (isset($_POST['due_date'][$i])) ? date('Y-m-d', strtotime($_POST['due_date'][$i])) : '',
                            "currency_id" => $_POST['selCurrency'][$i],
                            "invoice_amount" => $_POST['invoice_amount'][$i],
                            "balance" => $_POST['invoice_amount'][$i],
                            "fc_currency_rate" => $fc_rate,
                            "fc_currency_date" => date('Y-m-d', strtotime($fc_date)),
    		                "invoice_amount_in_fc" => $invoice_fc_amount,
    		                "balance_amount_in_fc" => $invoice_fc_amount,
    		                "cust_ref_no"=> $_POST['cust_ref_no'][$i],
            				"invoice_status" => 'O',
                            "status" =>'A',
                            "createdBy" => $this->user_id,
                            "updatedBy" => 0,
    		                "updatedDate" => '0000-00-00 00:00:00'
                        );
                        
                        $followup_id = $this->followup->insert_followup_data($fdata);
                        if ($followup_id > 0){
            			    $fdatacopy = $fdata;
            			    $fdatacopy['followup_id'] = $followup_id;
            			    $fdatacopy['received_date'] = date('Y-m-d', strtotime($invoice_date));
            			    //here save same details to another table for history
            			    $status = $this->followup->insert_followup_data_copy($fdatacopy);
            			}
                    }
                }
                
                //save
                //print_r($followups);
                //exit;
               //$status = $this->followup->save_all_followups($followups);
                if($status){
                   echo json_encode(array('type'=>'successimport', 'message' => 'Invoices Batch Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                } else {
                    echo json_encode(array('type'=>'error', 'message' => 'Invoices Batch Not Inserted Successfully!', 'redirect'=> 'followup'));
		           exit; 
                }
            }

        }
	}
	public function followup_details_crud_ajax()
	{
	    if (!$this->request->isAJAX()) {
	        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
			return;
		}
		
		helper(['form', 'url']);
		
		$input = $this->validate([
            'salesman' => 'required',
            'expected_amount' => 'required',
            'expected_payment_date' => 'required',
            'next_followup_date' => 'required',
            'status' => 'required'
        ]);
        
        if (!$input) {
            $type    = 'error';
			$message = ($this->validator->listErrors()) ? $this->validator->listErrors() : 'Something went wrong';
            echo json_encode(array('type'=>$type, 'message' => $message));
		    exit;
        }
        
        $operation = $this->request->getPost('operation');
        //$last_follow_up_date = $this->request->getPost('last_follow_up_date');
        $expected_payment_date= $this->request->getPost('expected_payment_date');
        $next_followup_date = $this->request->getPost('next_followup_date');
        $remarks= $this->request->getPost('remarks');
        if($operation == 'Add'){
            $followupID = $this->request->getPost('followupID');
            $followupID = base64_decode($followupID);
            $this->details->save([
		        'followup_id' => $followupID,
		        'salesman_id'=> $this->request->getPost('salesman'),
		        'last_follow_up_date'=> date('Y-m-d'),
				'expected_amount'=> $this->request->getPost('expected_amount'),
				'expected_payment_date'=> date('Y-m-d', strtotime($expected_payment_date)),
				'next_followup_date'=> date('Y-m-d', strtotime($next_followup_date)),
				'remarks'=> (!empty($remarks)) ? $remarks : '',
                'createdBy' => $this->user_id,
                'status' => $this->request->getPost('status'),
                'updatedBy' => 0,
				'updatedDate' => '0000-00-00 00:00:00'
			]);
			
			echo json_encode(array('type'=>'success', 'message' => 'Followup Added Suceesfully!', 'redirect'=> 'followup/details/'.$this->request->getPost('followupID')));
		    exit;
        } else if($operation == 'Edit'){
            $followupdetailsID = $this->request->getPost('followupdetailsID');
		    $followupdetailsID = base64_decode($followupdetailsID);
		    //$getdata = $this->details->where('followup_details_id', $followupdetailsID)->findAll();
		    $followupid = $this->request->getPost('followupID');
		    
		    $data = [
		        'salesman_id'=> $this->request->getPost('salesman'),
				'expected_amount'=> $this->request->getPost('expected_amount'),
				'expected_payment_date'=> date('Y-m-d', strtotime($expected_payment_date)),
				'next_followup_date'=> date('Y-m-d', strtotime($next_followup_date)),
				'remarks'=> (!empty($remarks)) ? $remarks : '',
                'createdBy' => $this->user_id,
                'status' => $this->request->getPost('status'),
                'updatedBy' => $this->user_id,
				'updatedDate' => date('Y-m-d H:i:s')
	        ];
	 
        	$this->details->update($followupdetailsID, $data);
        	echo json_encode(array('type'=>'success', 'message' => 'Followup Updated Suceesfully!', 'redirect'=> 'followup/details/'.$followupid));
		    exit;
        }
	}
	
	public function downloadsample()
	{
	    $url = FCPATH.'public/csvfile/Sample-Spreadsheet-Invoice.csv';
	    $file_name = basename($url); 
	    $info = pathinfo($file_name);
	    if ($info["extension"] == "csv") {
      
            /* Use file_get_contents() function
            to get the file from url and use 
            file_put_contents() function to save
            the file by using base name */   
           /*if(file_put_contents( $file_name, 
                file_get_contents($url))) { 
                echo "File downloaded successfully";
            }
            else { 
                echo "File downloading failed."; 
            }*/
            /* Informing the browser that
            the file type of the concerned
             file is a MIME type (Multipurpose
            Internet Mail Extension type).
            Hence, no need to play the file
             but to directly download it on
            the client's machine. */
            header("Content-Description: File Transfer"); 
            header("Content-Type: application/octet-stream"); 
            header(
            "Content-Disposition: attachment; filename=\""
            . $file_name . "\""); 
            ob_clean();
            flush();
            readfile($url);
        }
	}
	
	public function errors()
	{
	    $url = FCPATH.'public/errors.txt';
	    $file_name = basename($url); 
	    $info = pathinfo($file_name);
	    if ($info["extension"] == "txt") {
      
            /* Use file_get_contents() function
            to get the file from url and use 
            file_put_contents() function to save
            the file by using base name */   
           /*if(file_put_contents( $file_name, 
                file_get_contents($url))) { 
                echo "File downloaded successfully";
            }
            else { 
                echo "File downloading failed."; 
            }*/
            /* Informing the browser that
            the file type of the concerned
             file is a MIME type (Multipurpose
            Internet Mail Extension type).
            Hence, no need to play the file
             but to directly download it on
            the client's machine. */
            header("Content-Description: File Transfer"); 
            header("Content-Type: application/octet-stream"); 
            header(
            "Content-Disposition: attachment; filename=\""
            . $file_name . "\""); 
            ob_clean();
            flush();
            readfile($url);
        }
	}
	public function send_email()
    {
        if (!$this->request->isAJAX()) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            return;
        }

        $email = $this->request->getPost('email');
        $name = $this->request->getPost('name');
        $template = $this->request->getPost('template');

        $template_info = $this->template->where('slug', $template)->first();
        $subject = (isset($template_info['subject']) && !empty($template_info['subject'])) ? $template_info['subject'] : 'Follow-up';
        $message = sprintf($template_info['template'],$name);
        $image = (isset($template_info['image']) && !empty($template_info['image'])) ? base_url().$template_info['image'] :'';
        $template = $this->template_register($message, $image);
        $to = $email;
        if($this->send_email_rms($to, $subject, $template, $image)){
            $type    = 'success';
            $message = 'Email sent';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        } else {
            $type    = 'error';
            $message = 'Something wrong!! Email not sent.';
            echo json_encode(array('type'=>$type, 'message' => $message));
            exit;
        }

    }
}