<?php

namespace App\Models;

use CodeIgniter\Model;

class DashboardModel extends Model
{
    
	public function get_upcoming_followups($followupReminderDays = 7)
	{
	    
	}
	public function line_chart_sales($fyear = 0) {
	    $query = $this->db->query("SELECT SUM(invoice_amount_in_fc) as ramt,MONTHNAME(Invoice_date) as month_name FROM tbl_followup  WHERE financial_year_id = '$fyear' GROUP BY MONTH(Invoice_date)");
	    $record = $query->getResult();
	    $data = [];
 
      foreach($record as $row) {
            $data['label'][] = $row->month_name;
            $data['data'][] = (int) $row->ramt;
      }
      $chart_data = json_encode($data);
	  return $chart_data;
	}
	public function bar_chart_expected($fyear = 0) {
	    $query = $this->db->query("SELECT SUM(t1.expected_amount) as ramt,MONTHNAME(t1.expected_payment_date) as month_name FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.financial_year_id = '$fyear' GROUP BY MONTH(t1.expected_payment_date)");
	    $record = $query->getResult();
	    $data = [];
 
      foreach($record as $row) {
            $data['label'][] = $row->month_name;
            $data['data'][] = (int) $row->ramt;
      }
      $chart_data = $data;
	  return $chart_data;
	}
	public function bar_chart_collection($fyear = 0) {
	    $query = $this->db->query("SELECT SUM(received_amount_in_fc) as ramt,MONTHNAME(received_date) as month_name FROM tbl_collection_entry WHERE financialYear_id = '$fyear' GROUP BY MONTH(received_date)");
	    $record = $query->getResult();
	    $data = [];
 
      foreach($record as $row) {
            $data['label'][] = $row->month_name;
            $data['data'][] = (int) $row->ramt;
      }
      //$chart_data = json_encode($data);
      $chart_data = $data;
	  return $chart_data;
	}
	public function row_avg_bal_fc($client_id,$currency_id, $groupby, $where, $where1){
        
	    $query = $this->db->query("SELECT SUM(t1.invoice_amount_in_fc) as openingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where GROUP BY t1.Invoice_date ASC Limit 0,1");
        $row = $query->getRow();
        
        $openingbal = (isset($row->openingbal)) ? $row->openingbal : 0;
       
       /* $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' $where1 GROUP BY t1.received_date DESC Limit 0,1");
        $row1 = $query1->getRow();*/
        $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where");
        $row1 = $query1->getRow();
       //echo "SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where";
         $closingbal = (isset($row1->closingbal)) ? $row1->closingbal : 0;
          
        $avg_bal = ((float)$openingbal + (float)$closingbal)/2;
        return $avg_bal;
	}
	public function get_analysis($fyear = 0)
	{
	    $searchDate = date('Y-m-d');
	    $query = $this->db->query("SELECT t1.client_id,t1.currency_id,t1.financial_year_id,t1.company_id,t1.invoice_id,t1.Invoice_date,SUM(t1.invoice_amount_in_fc) AS invoice_amount_in_fc,SUM(t1.balance_amount_in_fc) AS balance_amount_in_fc, COUNT(t1.followup_id) AS cnt,t2.name FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id WHERE t1.financial_year_id = '$fyear' GROUP BY t1.client_id ORDER BY t1.currency_id ASC LIMIT 0, 5");
	    $row = $query->getResult();
	    $data = array();
	    $groupby3 = "t1.client_id";
	    $where1 = " AND t1.financialYear_id = $fyear";
	    $where2 = " AND t1.financial_year_id = $fyear";
	    foreach($row as $record ){
	        $avg_bal_customer =$this->row_avg_bal_fc($record->client_id,$record->currency_id, $groupby3, $where2, $where1);
            //echo "------------";
            $rturn = (float)$record->invoice_amount_in_fc/(float)$avg_bal_customer;
            $aavg = 365/$rturn;
	        $data[] = array( 
                 "client"=>$record->name,
                 "balfc"=>$record->balance_amount_in_fc,
                 "avg"=>number_format($aavg, 2),
	        );
	    }
	    return $data;
	}
	public function get_next_followup($fyear = 0)
	{
	    $searchDate = date('Y-m-d');
	    $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t2.remarks,t2.createdBy,t2.createdDate,t2.updatedBy,t2.updatedDate,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.due_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc,t3.critical_level_id FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' AND t2. followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) AND t3.financial_year_id = '$fyear' ORDER BY next_followup_date ASC LIMIT 0, 5");
	    $row = $query->getResult();
	    return $row;
	}
	public function get_aging_invoice($fyear = 0)
	{
	    $searchDate = date('Y-m-d');
	    $query = $this->db->query("SELECT SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 1 AND 30, balance_amount_in_fc, 0)) AS age30,SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 31 AND 60, balance_amount_in_fc, 0)) AS age60, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 61 AND 90, balance_amount_in_fc, 0)) AS age90, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 91 AND 180, balance_amount_in_fc, 0)) AS age180,SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 181 AND 360, balance_amount_in_fc, 0)) AS age360,SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > 360, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc IS NOT NULL AND invoice_status = 'O' AND bill.financial_year_id = '$fyear'");
	    $row = $query->getRow();
	    return $row;
	}
	
	public function get_aging_due($fyear = 0)
	{
	    $searchDate = date('Y-m-d');
	    $query = $this->db->query("SELECT SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN 1 AND 30, balance_amount_in_fc, 0)) AS age30,SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN 31 AND 60, balance_amount_in_fc, 0)) AS age60, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN 61 AND 90, balance_amount_in_fc, 0)) AS age90, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN 91 AND 180, balance_amount_in_fc, 0)) AS age180,SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN 181 AND 360, balance_amount_in_fc, 0)) AS age360,SUM(IF(DATEDIFF('$searchDate', due_date ) > 360, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc IS NOT NULL AND invoice_status = 'O' AND bill.financial_year_id = '$fyear'");
	    $row = $query->getRow();
	    return $row;
	}
	
	public function get_ratios($fyear = 0)
	{
	    $query = $this->db->query("SELECT SUM(t1.invoice_amount_in_fc) as openingbal FROM tbl_followup t1 WHERE t1.financial_year_id = '$fyear' GROUP BY t1.Invoice_date ASC Limit 0,1");
        $row = $query->getRow();
        
        $openingbal = (isset($row->openingbal)) ? $row->openingbal : 0;
       
       /* $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' $where1 GROUP BY t1.received_date DESC Limit 0,1");
        $row1 = $query1->getRow();*/
        $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.financial_year_id = '$fyear'");
        $row1 = $query1->getRow();
       //echo "SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where";
         $closingbal = (isset($row1->closingbal)) ? $row1->closingbal : 0;
          
        $avg_bal = ((float)$openingbal + (float)$closingbal)/2;
        
        $query2 = $this->db->query("SELECT SUM(t1.invoice_amount_in_fc) as totalinvoice FROM tbl_followup t1 WHERE t1.financial_year_id = '$fyear'");
        $row2 = $query2->getRow();
        $rturn = (float)$row2->totalinvoice/(float)$avg_bal;
        $aavg = 365/$rturn;
        $sale = (float)$avg_bal/(float)$row2->totalinvoice;
        $rat = array(
            'rturn' => $rturn,
            'aavg' => $aavg,
            'sale' => $sale,
            );
        return $rat;
        
	}
	
	public function priority_data($fyear = 0)
	{
	    $level= array();
	    //normal
	    $query = $this->db->query("SELECT COUNT(*) as normalcnt, SUM(balance_amount_in_fc) as normaltot FROM tbl_followup WHERE financial_year_id = '$fyear' AND critical_level_id = '1' AND invoice_status = 'O'");
        $row = $query->getRow();
        //print_r($row);
         $level['normalcnt'] = $row->normalcnt;
         $level['normaltot'] = $row->normaltot;
         
         $query2 = $this->db->query("SELECT COUNT(*) as normalcnt, SUM(balance_amount_in_fc) as normaltot FROM tbl_followup WHERE financial_year_id = '$fyear' AND critical_level_id = '2' AND invoice_status = 'O'");
        $row2 = $query2->getRow();
        
        $level['medcnt'] = $row2->normalcnt;
        $level['medtot'] = $row2->normaltot;
        
        $query3 = $this->db->query("SELECT COUNT(*) as normalcnt, SUM(balance_amount_in_fc) as normaltot FROM tbl_followup WHERE financial_year_id = '$fyear' AND critical_level_id = '3' AND invoice_status = 'O'");
        $row3 = $query3->getRow();
        
        $level['highcnt'] = $row3->normalcnt;
        $level['hightot'] = $row3->normaltot;
        
        $query4 = $this->db->query("SELECT COUNT(*) as normalcnt, SUM(balance_amount_in_fc) as normaltot FROM tbl_followup WHERE financial_year_id = '$fyear' AND critical_level_id = '4' AND invoice_status = 'O'");
        $row4 = $query4->getRow();
        
        $level['discnt'] = $row4->normalcnt;
        $level['distot'] = $row4->normaltot;
        
        $totalcnt = $level['normalcnt'] + $level['medcnt'] + $level['highcnt'] + $level['discnt'];
        $grangtot = $level['normaltot'] + $level['medtot'] + $level['hightot'] + $level['distot'];
        
        $level['count'] =$totalcnt;
        $level['grand'] =$grangtot;
        return $level;
	}
}