<?php

namespace App\Models;

use CodeIgniter\Model;

class ReportsModel extends Model
{

    public function getFollowupCollectionSummary($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        //$searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchRange= $postData['searchRange'];
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t2.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t2.company_id = $searchCompany";
            }
            
            //if(!empty($searchStatus)){
                $where .= " AND t2.invoice_status = 'O'";
            //}
            $groupby = "client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }
            if(!empty($searchRange)){
            //explode
                $invdates = explode("-",$searchRange);
                $date1 = date('Y-m-d', strtotime($invdates[0]));
                $date2 = date('Y-m-d', strtotime($invdates[1]));
                $where .= " AND t1.expected_payment_date BETWEEN '$date1' AND '$date2'";
            }
        if ($searchDate == $today){
            
           $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
           
           
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,SUM(t1.expected_amount * t2.fc_currency_rate) AS expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,SUM(t2.balance_amount_in_fc) AS balance_amount_in_fc,t2.fc_currency_rate,SUM(t2.invoice_amount_in_fc) AS invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id,t2.Invoice_date, DATEDIFF('$searchDate', t1.expected_payment_date) AS age FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecords = $query->getNumRows();
                
           
            
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.expected_payment_date <= '$searchDate' GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT t1.last_follow_up_date,SUM(t1.expected_amount * t2.fc_currency_rate) AS expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedDate,t1.updatedBy,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,SUM(t2.balance_amount_in_fc) AS balance_amount_in_fc,t2.fc_currency_rate,SUM(t2.invoice_amount_in_fc) AS invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id,t2.Invoice_date,DATEDIFF('$searchDate', t1.expected_payment_date) AS age FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.expected_payment_date <= '$searchDate' GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon='';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            $rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $expamtfc = (float)$record->expected_amount;
            
           $data[] = array( 
            //"financialyear"=>$record->financial_year_id,
             //"inv"=>get_invoice($record->invoice_id),
             //"invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
            // "cur"=>$currency_data->code,
             //"rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             //"invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
            // "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             //"last" => date('d-m-Y', strtotime($record->last_follow_up_date)),
             //"expamt"=>$record->expected_amount,
             "expamtfc"=>number_format((float)$expamtfc, 2, '.', ''),
             "dueamtfc"=>(($record->age > 0) && ($record->balance > 0)) ? number_format((float)$expamtfc, 2, '.', '') : '',
             //"expdate"=>date('d-m-Y', strtotime($record->expected_payment_date)),
             //"next"=>date('d-m-Y', strtotime($record->next_followup_date)),
             //"remarks"=>$record->remarks,
             //"issue"=>$record->payment_terms,
             //"due"=>date('d-m-Y', strtotime($record->due_date)),
             //"salesman"=>get_salesman($record->salesman_id),
             //"paymentterms"=>$record->payment_terms,cust_ref_no
             //"cust_ref_no"=>$record->cust_ref_no,
             //"priority"=>$level,
             //"status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             //"company"=>get_company($record->company_id),
             //"priority"=> $priority,
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function getFollowupCollectionFC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        //$searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchRange= $postData['searchRange'];
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t2.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t2.company_id = $searchCompany";
            }
            
            //if(!empty($searchStatus)){
                $where .= " AND t2.invoice_status = 'O'";
            //}
            $groupby = "currency_id, client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }
            if(!empty($searchRange)){
	        //explode
    	        $invdates = explode("-",$searchRange);
    	        $date1 = date('Y-m-d', strtotime($invdates[0]));
    	        $date2 = date('Y-m-d', strtotime($invdates[1]));
    	        $where .= " AND t1.expected_payment_date BETWEEN '$date1' AND '$date2'";
    	    }
        if ($searchDate == $today){
            
           $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
           
           
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.balance_amount_in_fc,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id,t2.Invoice_date, DATEDIFF('$searchDate', t1.expected_payment_date) AS age FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecords = $query->getNumRows();
                
           
            
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.expected_payment_date <= '$searchDate' GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedDate,t1.updatedBy,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.balance_amount_in_fc,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id,t2.Invoice_date,DATEDIFF('$searchDate', t1.expected_payment_date) AS age FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.expected_payment_date <= '$searchDate' GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon='';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            $rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $expamtfc = (float)$record->expected_amount * (float)$rate;
            
           $data[] = array( 
            //"financialyear"=>$record->financial_year_id,
             "inv"=>get_invoice($record->invoice_id),
             "invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
            // "cur"=>$currency_data->code,
             //"rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             //"invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
            // "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             //"last" => date('d-m-Y', strtotime($record->last_follow_up_date)),
             //"expamt"=>$record->expected_amount,
             "expamtfc"=>number_format((float)$expamtfc, 2, '.', ''),
             "dueamtfc"=>(($record->age > 0) && ($record->balance > 0)) ? number_format((float)$expamtfc, 2, '.', '') : '',
             "expdate"=>date('d-m-Y', strtotime($record->expected_payment_date)),
             //"next"=>date('d-m-Y', strtotime($record->next_followup_date)),
             //"remarks"=>$record->remarks,
             //"issue"=>$record->payment_terms,
             //"due"=>date('d-m-Y', strtotime($record->due_date)),
             //"salesman"=>get_salesman($record->salesman_id),
             //"paymentterms"=>$record->payment_terms,cust_ref_no
             //"cust_ref_no"=>$record->cust_ref_no,
             //"priority"=>$level,
             //"status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             //"company"=>get_company($record->company_id),
             //"priority"=> $priority,
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function getCollectionSummaryMC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	     $groupby = "GROUP BY t2.currency_id, t2.client_id";
	     
	    if($searchDate < $today){
	        $where .= " AND t1.received_date <= $searchDate";
	    }
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $groupby" );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where $groupby" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where $groupby ORDER BY t2.currency_id LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            //$level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array(
                "rno"=>strtotime($record->createdDate),
                "rdate"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
                "client"=>get_client($record->client_id),
                //"invoice"=>get_invoice($record->invoice_id),
                "currency"=>$currency_data->code,
                "ramt"=>$record->received_amount,
                "ramtfc"=>$record->received_amount_in_fc,
             
            
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    public function getCollectionSummary($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if($searchDate < $today){
	        $where .= " AND t1.received_date <= $searchDate";
	    }
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            //$level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array(
                "rno"=>strtotime($record->createdDate),
                "rdate"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
                "client"=>get_client($record->client_id),
                "invoice"=>get_invoice($record->invoice_id),
                "currency"=>$currency_data->code,
                "ramt"=>$record->received_amount,
                "ramtfc"=>$record->received_amount_in_fc,
             
            
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    public function getCustomerAnalysisFC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $postData['searchPeriod'];
        $searchCurrency= $postData['searchCurrency'];
        $groupby = "t1.client_id";
        $groupby2= "t2.client_id";
        $groupby3 = "t1.client_id";
        
        $where = '';
        $where1 = '';
        $where2 = '';
        if(!empty($searchPeriod)){
            $where .= " AND t1.financial_year_id = $searchPeriod";
            $where1 .= " AND t1.financialYear_id = $searchPeriod";
            $where2 .= " AND t1.financial_year_id = $searchPeriod";
        }
        if(!empty($searchClient)){
             $where .= " AND t1.client_id = $searchClient";
        }
        if(!empty($searchCompany)){
             $where .= " AND t1.company_id = $searchCompany";
        }
        if(!empty($searchStatus)){
             $where .= " AND t1.invoice_status = '$searchStatus'";
        }
        if(!empty($searchCurrency)){
             $where .= " AND t1.currency_id = $searchCurrency";
        }
        $query = $this->db->query("SELECT * FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id" );
        $totalRecords = $query->getNumRows();
        
        $query = $this->db->query("SELECT * FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id WHERE 1=1 $where GROUP BY $groupby " );
        $totalRecordwithFilter = $query->getNumRows();
        
        $query = $this->db->query("SELECT t1.client_id,t1.currency_id,t1.financial_year_id,t1.company_id,t1.invoice_id,t1.Invoice_date,SUM(t1.invoice_amount_in_fc) AS invoice_amount_in_fc,SUM(t1.balance_amount_in_fc) AS balance_amount_in_fc, COUNT(t1.followup_id) AS cnt,t2.name FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id WHERE 1=1 $where GROUP BY $groupby ORDER BY t1.currency_id ASC LIMIT $start, $rowperpage" );
        $records =$query->getResult();
        
        $data = array();
        
        foreach($records as $record ){
            //(isset($record->invoice_id)) ? get_invoice($record->invoice_id) : 
            $currency_data = $this->row_currency($record->currency_id);
            $rect_data = $this->row_receipt_fc($record->client_id,$record->currency_id, $groupby2, $where1);
            $avg_bal_customer =$this->row_avg_bal_fc($record->client_id,$record->currency_id, $groupby3, $where2, $where1);
            //echo "------------";
            $rturn = (float)$record->invoice_amount_in_fc/(float)$avg_bal_customer;
            $aavg = 365/$rturn;
            $sale = (float)$avg_bal_customer/(float)$record->invoice_amount_in_fc;
            //print_r($rect_data);
            $data[] = array( 
                 "client"=>$record->name,
                 //"cur"=>$currency_data->code,
                 //"totinvamt"=>$record->invoice_amount,
                 //"totrctamt"=>(isset($rect_data->totrctamt)) ? $rect_data->totrctamt : '',
                 //"totbal"=>$record->balance,
                 "invamfc"=>$record->invoice_amount_in_fc,
                 "rctamtfc"=>(isset($rect_data->totrctamtfc)) ? $rect_data->totrctamtfc : '',
                 "balfc"=>$record->balance_amount_in_fc,
                 "rturn"=>number_format($rturn, 2),
                 "avg"=>number_format($aavg, 2),
                 "sale"=>number_format($sale, 2),
                 "invcount"=>$record->cnt,

               );
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
        
    }
    public function row_avg_bal_fc($client_id,$currency_id, $groupby, $where, $where1){
        
	    $query = $this->db->query("SELECT SUM(t1.invoice_amount_in_fc) as openingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where GROUP BY t1.Invoice_date ASC Limit 0,1");
        $row = $query->getRow();
        
        $openingbal = (isset($row->openingbal)) ? $row->openingbal : 0;
       
       /* $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' $where1 GROUP BY t1.received_date DESC Limit 0,1");
        $row1 = $query1->getRow();*/
        $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where");
        $row1 = $query1->getRow();
       //echo "SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' $where";
         $closingbal = (isset($row1->closingbal)) ? $row1->closingbal : 0;
          
        $avg_bal = ((float)$openingbal + (float)$closingbal)/2;
        return $avg_bal;
	}
     public function row_receipt_fc($client_id,$currency_id, $groupby, $where){
        
	    $query = $this->db->query("SELECT SUM(t1.received_amount) as totrctamt, SUM(t1.received_amount_in_fc) as totrctamtfc FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' $where GROUP BY $groupby");
        $row = $query->getRow();
        return $row;
	}
    public function getCustomerAnalysis($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $postData['searchPeriod'];
        $searchCurrency= $postData['searchCurrency'];
        $groupby = "t1.currency_id, t1.client_id";
        $groupby2= "t2.currency_id, t2.client_id";
        $groupby3 = "t1.currency_id, t1.client_id";
        
        $where = '';
        $where1 = '';
        $where2 = '';
        if(!empty($searchPeriod)){
            $where .= " AND t1.financial_year_id = $searchPeriod";
            $where1 .= " AND t1.financialYear_id = $searchPeriod";
            $where2 .= " AND t1.financial_year_id = $searchPeriod";
        }
        if(!empty($searchClient)){
             $where .= " AND t1.client_id = $searchClient";
        }
        if(!empty($searchCompany)){
             $where .= " AND t1.company_id = $searchCompany";
        }
        if(!empty($searchStatus)){
             $where .= " AND t1.invoice_status = '$searchStatus'";
        }
        if(!empty($searchCurrency)){
             $where .= " AND t1.currency_id = $searchCurrency";
        }
        $query = $this->db->query("SELECT * FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id" );
        $totalRecords = $query->getNumRows();
        
        $query = $this->db->query("SELECT * FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id WHERE 1=1 $where GROUP BY $groupby " );
        $totalRecordwithFilter = $query->getNumRows();
        
        $query = $this->db->query("SELECT t1.client_id,t1.currency_id,t1.financial_year_id,t1.company_id,t1.invoice_id,t1.Invoice_date,SUM(t1.invoice_amount) AS invoice_amount,SUM(t1.invoice_amount_in_fc) AS invoice_amount_in_fc,SUM(t1.balance_amount_in_fc) AS balance_amount_in_fc,SUM(t1.balance) AS balance, COUNT(t1.followup_id) AS cnt,t2.name FROM tbl_followup t1 INNER JOIN tbl_client_m t2 ON t1.client_id = t2.client_id WHERE 1=1 $where GROUP BY $groupby ORDER BY t1.currency_id ASC LIMIT $start, $rowperpage" );
        $records =$query->getResult();
        
        $data = array();
        
        foreach($records as $record ){
            //(isset($record->invoice_id)) ? get_invoice($record->invoice_id) : 
            $currency_data = $this->row_currency($record->currency_id);
            $rect_data = $this->row_receipt($record->client_id,$record->currency_id, $groupby2, $where1);
            $avg_bal_customer =$this->row_avg_bal($record->client_id,$record->currency_id, $groupby3, $where2, $where1);
            //echo "------------";
            $rturn = (float)$record->invoice_amount_in_fc/(float)$avg_bal_customer;
            $aavg = 365/$rturn;
            $sale = (float)$avg_bal_customer/(float)$record->invoice_amount_in_fc;
            //print_r($rect_data);
            $data[] = array( 
                 "client"=>$record->name,
                 "cur"=>$currency_data->code,
                 "totinvamt"=>$record->invoice_amount,
                 "totrctamt"=>(isset($rect_data->totrctamt)) ? $rect_data->totrctamt : '',
                 "totbal"=>$record->balance,
                 "invamfc"=>$record->invoice_amount_in_fc,
                 "rctamtfc"=>(isset($rect_data->totrctamtfc)) ? $rect_data->totrctamtfc : '',
                 "balfc"=>$record->balance_amount_in_fc,
                 "rturn"=>number_format($rturn, 2),
                 "avg"=>number_format($aavg, 2),
                 "sale"=>number_format($sale, 2),
                 "invcount"=>$record->cnt,

               );
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
        
    }
    
    public function row_avg_bal($client_id,$currency_id, $groupby, $where, $where1){
        
	    $query = $this->db->query("SELECT SUM(t1.invoice_amount_in_fc) as openingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' AND t1.currency_id = '$currency_id' $where GROUP BY t1.Invoice_date ASC Limit 0,1");
        $row = $query->getRow();
        
        $openingbal = (isset($row->openingbal)) ? $row->openingbal : '';
       
        /*$query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' AND t2.currency_id = '$currency_id' $where1 GROUP BY t1.received_date DESC Limit 0,1");
        $row1 = $query1->getRow();*/
        
        $query1 = $this->db->query("SELECT SUM(t1.balance_amount_in_fc) as closingbal FROM tbl_followup t1 WHERE t1.client_id = '$client_id' AND t1.currency_id = '$currency_id' $where");
        $row1 = $query1->getRow();
        
        $closingbal = (isset($row1->closingbal)) ? $row1->closingbal : $openingbal;
         
        $avg_bal = ((float)$openingbal + (float)$closingbal)/2;
        return $avg_bal;
	}
     public function row_receipt($client_id,$currency_id, $groupby, $where){
        
	    $query = $this->db->query("SELECT SUM(t1.received_amount) as totrctamt, SUM(t1.received_amount_in_fc) as totrctamtfc FROM tbl_collection_entry t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE t2.client_id = '$client_id' AND t2.currency_id ='$currency_id' $where GROUP BY $groupby");
        $row = $query->getRow();
        return $row;
	}
    public function getCustomerSoaMc($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        $totalRecords = 0;
        $totalRecordwithFilter= 0;
        $data = array();
        $where = '';
        $where1 = '';
        $where2 = '';
        if(!empty($searchPeriod)){
            $where .= " AND t1.financial_year_id = $searchPeriod";
            $where1 .= " AND t3.financial_year_id = $searchPeriod";
            $where2 .= " AND t5.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t1.company_id = $searchCompany";
            $where1 .= " AND t3.company_id = $searchCompany";
            $where2 .= " AND t5.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.Invoice_date BETWEEN '$date1' AND '$date2'";
	        $where1 .= " AND t2.received_date BETWEEN '$date1' AND '$date2'";
	        $where2 .= " AND t4.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    if($searchDate < $today){
	         $where .= " AND t1.Invoice_date <= '$searchDate'";
	         $where1 .= " AND t2.received_date <= '$searchDate'";
             $where2 .= " AND t4.received_date <= '$searchDate'";
	    }
        if (!empty($searchClient)){
            $where .= " AND t1.client_id = $searchClient";
            $where1 .= " AND t3.client_id = $searchClient";
            $where2 .= " AND t5.client_id = $searchClient";
            
            
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 " );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type, t1.currency_id, t1.invoice_id, t1.invoice_amount_in_fc,t1.invoice_amount, '' AS received_amount_in_fc,'' AS received_amount, t1.balance_amount_in_fc,t1.balance,t1.fc_currency_rate FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type, t3.currency_id, t3.invoice_id, t3.invoice_amount_in_fc,t3.invoice_amount,t2.received_amount_in_fc,t2.received_amount,t2.balance_amount_in_fc,t2.balance,t3.fc_currency_rate FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type, t5.currency_id, t5.invoice_id,t5.invoice_amount_in_fc,t5.invoice_amount,t4.adjustment AS received_amount_in_fc,t4.adjustment AS received_amount, t4.balance_amount_in_fc,t4.balance,t5.fc_currency_rate FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 ORDER BY currency_id LIMIT $start, $rowperpage" );
            
            $records =$query->getResult();
            
            foreach($records as $record ){
                //print_r($record);
                $currency_data = $this->row_currency($record->currency_id);
                //$level = get_critical_level($record->critical_level_id);
                /*$status = '';
                if($record->invoice_status == 'O'){
                    $status = 'Open';
                }else if($record->invoice_status == 'C'){
                    $status = 'Closed';
                }*/
                $received_amount_in_fc = '';
                if($record->doc_type == 'ADJ'){
                   $rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
                    $received_amount_in_fc = (float)$record->received_amount * (float)$rate; 
                }
               
                
                $data[] = array( 
                 "ddate"=>date('d-m-Y', strtotime($record->doc_date)),
                 "type"=>$record->doc_type,
                 "ref"=>(isset($record->invoice_id)) ? get_invoice($record->invoice_id) : '',
                 "cur"=>$currency_data->code,
                 "invamt"=>($record->doc_type == 'INV') ? $record->invoice_amount : '',
                 "ramt"=>$record->received_amount,
                 "bal"=>$record->balance,
                 "invamtfc"=>($record->doc_type == 'INV') ? $record->invoice_amount_in_fc : '',
                 "ramtfc"=>($record->doc_type == 'ADJ') ? $received_amount_in_fc: $record->received_amount_in_fc,
                 "balfc"=>$record->balance_amount_in_fc,

               ); 
                
    	    }
            
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    public function getCustomerSoaFc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        $totalRecords = 0;
        $totalRecordwithFilter= 0;
        $data = array();
        $where = '';
        $where1 = '';
        $where2 = '';
        if(!empty($searchPeriod)){
            $where .= " AND t1.financial_year_id = $searchPeriod";
            $where1 .= " AND t3.financial_year_id = $searchPeriod";
            $where2 .= " AND t5.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t1.company_id = $searchCompany";
            $where1 .= " AND t3.company_id = $searchCompany";
            $where2 .= " AND t5.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.Invoice_date BETWEEN '$date1' AND '$date2'";
	        $where1 .= " AND t2.received_date BETWEEN '$date1' AND '$date2'";
	        $where2 .= " AND t4.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    if($searchDate < $today){
	         $where .= " AND t1.Invoice_date <= '$searchDate'";
	         $where1 .= " AND t2.received_date <= '$searchDate'";
             $where2 .= " AND t4.received_date <= '$searchDate'";
	    }
        if (!empty($searchClient)){
            $where .= " AND t1.client_id = $searchClient";
            $where1 .= " AND t3.client_id = $searchClient";
            $where2 .= " AND t5.client_id = $searchClient";
            
            
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 " );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t1.Invoice_date AS doc_date, 'INV' AS doc_type, t1.currency_id, t1.invoice_id, t1.invoice_amount_in_fc, '' AS received_amount_in_fc, t1.balance_amount_in_fc FROM `tbl_followup` t1 WHERE 1=1 $where UNION SELECT t2.received_date AS doc_date,'RCT' AS doc_type, t3.currency_id, t3.invoice_id, t3.invoice_amount_in_fc,t2.received_amount_in_fc,t2.balance_amount_in_fc FROM `tbl_collection_entry` t2 INNER JOIN `tbl_followup` t3 ON t2.followup_id = t3.followup_id WHERE 1=1 $where1 UNION SELECT t4.received_date AS doc_date,'ADJ' AS doc_type, t5.currency_id, t5.invoice_id,t5.invoice_amount_in_fc,t4.adjustment AS received_amount_in_fc,t4.balance_amount_in_fc FROM `tbl_collection_entry` t4 INNER JOIN `tbl_followup` t5 ON t4.followup_id = t5.followup_id WHERE 1=1 AND t4.adjustment > 0 $where2 LIMIT $start, $rowperpage" );
            
            $records =$query->getResult();
            
            foreach($records as $record ){
                //print_r($record);
                $currency_data = $this->row_currency($record->currency_id);
                //$level = get_critical_level($record->critical_level_id);
                /*$status = '';
                if($record->invoice_status == 'O'){
                    $status = 'Open';
                }else if($record->invoice_status == 'C'){
                    $status = 'Closed';
                }*/
                
                /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
                $ramtfc = (float)$record->received_amount * (float)$rate;*/
                
                $data[] = array( 
                 "ddate"=>date('d-m-Y', strtotime($record->doc_date)),
                 "type"=>$record->doc_type,
                 "ref"=>(isset($record->invoice_id)) ? get_invoice($record->invoice_id) : '',
                 "cur"=>$currency_data->code,
                 "invamtfc"=>($record->doc_type == 'INV') ? $record->invoice_amount_in_fc : '',
                 "ramtfc"=>$record->received_amount_in_fc,
                 "balfc"=>$record->balance_amount_in_fc,

               ); 
                
    	    }
            
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    
     public function getCollectionDetailsSalesmanMc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
       // $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        $searchSalesman = $postData['searchSalesman'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        if (!empty($searchSalesman)){
            $where .= " AND t2.salesman_id = $searchSalesman";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if($searchDate == $today){
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    } else {
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
           $totalRecords = $query->getNumRows();
           
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
	    }
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "ramt"=>$record->received_amount,
             "ramtfc"=>$record->received_amount_in_fc,
             "received_date"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "adjustment"=>$record->adjustment,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
	    
    }
     public function getCollectionDetailsMc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
       // $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if($searchDate == $today){
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    } else {
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
           $totalRecords = $query->getNumRows();
           
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
	    }
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "ramt"=>$record->received_amount,
             "ramtfc"=>$record->received_amount_in_fc,
             "received_date"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "adjustment"=>$record->adjustment,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
	    
    }
    public function getCollectionDetailsSalesmanFc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
       // $columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        $searchSalesman = $postData['searchSalesman'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        if (!empty($searchSalesman)){
            $where .= " AND t2.salesman_id = $searchSalesman";
        }
        
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if($searchDate == $today){
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    } else {
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
           $totalRecords = $query->getNumRows();
           
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
	    }
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "ramt"=>$record->received_amount,
             "ramtfc"=>$record->received_amount_in_fc,
             "received_date"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "adjustment"=>$record->adjustment,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
	    
    }
    public function getCollectionDetailsFc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
       // $columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        //$searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        //$searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        //$searchSalesman = $postData['searchSalesman'];
        //$searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t1.received_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    if($searchDate == $today){
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where" );
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 $where LIMIT $start, $rowperpage" );
            $records =$query->getResult();
	    } else {
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE 1=1 " );
           $totalRecords = $query->getNumRows();
           
	        $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT * FROM `tbl_collection_entry` t1 INNER JOIN `tbl_followup` t2 ON t2.followup_id = t1.followup_id WHERE t1.received_date <='$searchDate' $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
	    }
	    
	    $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
            /*$rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $ramtfc = (float)$record->received_amount * (float)$rate;*/
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "ramt"=>$record->received_amount,
             "ramtfc"=>$record->received_amount_in_fc,
             "received_date"=> (isset($record->received_date)) ? date('d-m-Y', strtotime($record->received_date)) : '',
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "adjustment"=>$record->adjustment,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
            // "adjustment"=>date('d-m-Y', strtotime($record->due_date)),
             //"priority"=>$level,
             
             //"nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             //"remarks"=>$record->remarks,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
	    
    }
    public function getFollowupNextMc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
       // $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t3.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t3.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t3.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t3.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t3.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t3.client_id = '$searchClient'";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t2.last_follow_up_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' ORDER BY next_followup_date ASC");
         $totalRecords = $query->getNumRows();
         
         $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' AND t2. followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ORDER BY next_followup_date ASC");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t2.remarks,t2.createdBy,t2.createdDate,t2.updatedBy,t2.updatedDate,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.due_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc,t3.critical_level_id FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' AND t2. followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ORDER BY next_followup_date ASC LIMIT $start, $rowperpage");
            $records =$query->getResult();
           $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "amt"=>$record->invoice_amount,
             "amtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             "priority"=>$level,
             "lastfollowupdate"=> (isset($record->last_follow_up_date)) ? date('d-m-Y', strtotime($record->last_follow_up_date)) : '',
             "nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             "remarks"=>$record->remarks,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
    }
     public function getFollowupNextFc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t3.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t3.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t3.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t3.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t3.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t3.client_id = '$searchClient'";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t2.last_follow_up_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' ORDER BY next_followup_date ASC");
         $totalRecords = $query->getNumRows();
         
         $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' AND t2. followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ORDER BY next_followup_date ASC");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t2.remarks,t2.createdBy,t2.createdDate,t2.updatedBy,t2.updatedDate,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.due_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc,t3.critical_level_id FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.last_follow_up_date <='$searchDate' AND t2. followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ORDER BY next_followup_date ASC LIMIT $start, $rowperpage");
            $records =$query->getResult();
           $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            $level = get_critical_level($record->critical_level_id);
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "amt"=>$record->invoice_amount,
             "amtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             "priority"=>$level,
             "lastfollowupdate"=> (isset($record->last_follow_up_date)) ? date('d-m-Y', strtotime($record->last_follow_up_date)) : '',
             "nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             //"sman"=>get_salesman($record->salesman_id),
             "remarks"=>$record->remarks,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
    }
    
    public function getFollowupMissingMc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t3.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t3.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t3.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t3.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t3.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t3.client_id = '$searchClient'";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t2.last_follow_up_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id)");
         $totalRecords = $query->getNumRows();
         
         $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t2.createdBy,t2.createdDate,t2.updatedBy,t2.updatedDate,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
           $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "amt"=>$record->invoice_amount,
             "amtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             
             "lastfollowupdate"=> (isset($record->last_follow_up_date)) ? date('d-m-Y', strtotime($record->last_follow_up_date)) : '',
             "nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             "sman"=>get_salesman($record->salesman_id),
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
    }
    public function getFollowupMissingFc($postData=null, $fyear = 0)
    {
        $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $fyear;
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
        $searchRange= $postData['searchRange'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t3.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t3.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t3.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t3.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t3.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t3.client_id = '$searchClient'";
        }
        
        if(!empty($searchRange)){
        //explode
	        $invdates = explode("-",$searchRange);
	        $date1 = date('Y-m-d', strtotime($invdates[0]));
	        $date2 = date('Y-m-d', strtotime($invdates[1]));
	        $where .= " AND t2.last_follow_up_date BETWEEN '$date1' AND '$date2'";
	    }
	    
	    $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id)");
         $totalRecords = $query->getNumRows();
         
         $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where ");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT t2.followup_details_id,t2.followup_id,t2.last_follow_up_date,t2.expected_amount,t2.expected_payment_date,t2.next_followup_date,t2.createdBy,t2.createdDate,t2.updatedBy,t2.updatedDate,t3.client_id,t3.financial_year_id,t3.company_id,t3.salesman_id,t3.invoice_id,t3.Invoice_date,t3.currency_id,t3.invoice_amount,t3.balance,t3.fc_currency_rate,t3.invoice_amount_in_fc,t3.balance_amount_in_fc FROM `tbl_followup_details` t2 INNER JOIN `tbl_followup` t3 ON t3.followup_id = t2.followup_id WHERE t2.`last_follow_up_date` Not IN (SELECT t1.`next_followup_date` FROM tbl_followup_details t1 WHERE t1.next_followup_date <='$searchDate') AND next_followup_date <= '$searchDate' and followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 GROUP by t0.followup_id) $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
           $data = array();  
	    foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            
            /*$status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }*/
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "currency"=>$currency_data->code,
             "amt"=>$record->invoice_amount,
             "amtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             
             "lastfollowupdate"=> (isset($record->last_follow_up_date)) ? date('d-m-Y', strtotime($record->last_follow_up_date)) : '',
             "nextfollowup"=> (isset($record->next_followup_date)) ? date('d-m-Y', strtotime($record->next_followup_date)) : '',
             "sman"=>get_salesman($record->salesman_id),
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
           ); 
            
	    }
	    
	    ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	    
    }
    
    public function getFollowupAnalysis($postData=null, $fyear = 0)
    {
         $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
       // $columnIndex = $postData['order'][0]['column']; // Column index
       // $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $postData['searchPeriod'];
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
         
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t2.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t2.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t2.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t2.client_id = '$searchClient'";
        }
           /* $groupby = "currency_id, client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }*/
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup t2 WHERE 1=1");
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup t2 WHERE 1=1 $where ");
            $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id,t2.invoice_id,t2.Invoice_date,t2.due_date,t2.payment_terms,t2.followup_id,t2.remarks,DATEDIFF('$searchDate', Invoice_date ) as age, DATEDIFF('$searchDate', due_date ) as agedue FROM tbl_followup t2 WHERE 1=1 $where LIMIT $start, $rowperpage");
            $records =$query->getResult();
            
        //} else {
            /*$query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)");
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) AND t1.last_follow_up_date <= '$searchDate'");
            $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id,t2.invoice_id,t2.Invoice_date,t2.due_date,t2.payment_terms,t2.followup_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) AND t1.last_follow_up_date <= '$searchDate' LIMIT $start, $rowperpage");
            $records =$query->getResult();*/
       // }
                
        $data = array();

        foreach($records as $record ){
            //print_r($record);
            $currency_data = $this->row_currency($record->currency_id);
            
            //if ($searchDate == $today){
                $detailsfirst = $this->row_details_first($record->followup_id, $searchDate, $today);
                $detailslast = $this->row_details_last($record->followup_id, $searchDate, $today);
                $detailstot = $this->row_details_tot($record->followup_id, $searchDate, $today);
                
                $receiptfirst = $this->collection_details_first($record->followup_id, $searchDate, $today);
                $receiptlast = $this->collection_details_last($record->followup_id, $searchDate, $today);
                $receipttot = $this->collection_details_tot($record->followup_id, $searchDate, $today);
            //print_r($detailsfirst);
            //print_r($receiptfirst);
            //echo '=================';
           $followupdays = '';
            if(isset($detailsfirst->last_follow_up_date) && isset($receiptfirst->received_date)){
                //echo "inside";
                 $datef = date('Y-m-d', strtotime($detailsfirst->last_follow_up_date));
                 $datec = date('Y-m-d', strtotime($receiptfirst->received_date));
                $datef=date_create($datef);
                $datec=date_create($datec);
                $diff=date_diff($datef, $datec);
                //print_r($diff);
                
                $followupdays = $diff->days;
            }
            //echo $followupdays; 
             //echo '=================';
            $collectiondays = '';
            
            if(isset($receiptfirst->received_date) && isset($record->Invoice_date)){
                $datef1 = date('Y-m-d', strtotime($record->Invoice_date));
                $datec1 = date('Y-m-d', strtotime($receiptfirst->received_date));
                $datef1=date_create($datef1);
                $datec1=date_create($datec1);
                $diff1=date_diff($datef1,$datec1);
                
                $collectiondays = $diff1->days;
            }
           
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            
            
            
            
           $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
              "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "paymentterms"=>$record->payment_terms,
             //"currency"=>$currency_data->code,
             //"amt"=>$record->invoice_amount,
             "amtfc"=>$record->invoice_amount_in_fc,
             "age"=>$record->age,
             "agedue"=>$record->agedue,
             "firstfollowupdate"=> (isset($detailsfirst->last_follow_up_date)) ? date('d-m-Y', strtotime($detailsfirst->last_follow_up_date)) : '',//date('d-m-Y', strtotime($record->last_follow_up_date))
             "lastfollowupdate"=> (isset($detailslast->last_follow_up_date)) ? date('d-m-Y', strtotime($detailslast->last_follow_up_date)) : '',
             "noofflups"=> (isset($detailstot->cnt)) ? $detailstot->cnt : 0,
             "firstreceiptdate"=> (isset($receiptfirst->received_date)) ? date('d-m-Y', strtotime($receiptfirst->received_date)) : '',
             "lastreceiptdate"=> (isset($receiptlast->received_date)) ? date('d-m-Y', strtotime($receiptlast->received_date)) : '',
             "noofreceipts" => (isset($receipttot->cnt)) ? $receipttot->cnt : 0,
             "followupdays"=>$followupdays,
             "collectiondays"=>$collectiondays,
             "sman"=>get_salesman($record->salesman_id),
             "company"=>$record->company_id,
             "invstatus"=>$status,
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    
    public function collection_details_tot($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND received_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT count(followup_id) as cnt FROM tbl_collection_entry WHERE followup_id = '$fid' $where");
        $row = $query->getRow();
        return $row;
	}
    
    public function collection_details_last($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND received_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT received_date FROM tbl_collection_entry WHERE followup_id = '$fid' $where ORDER BY collection_id DESC LIMIT 0,1");
        $row = $query->getRow();
        return $row;
	}
    public function collection_details_first($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND received_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT received_date FROM tbl_collection_entry WHERE followup_id = '$fid' $where ORDER BY collection_id ASC LIMIT 0,1");
        $row = $query->getRow();
        return $row;
	}
    public function row_details_tot($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND last_follow_up_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT count(followup_id) as cnt FROM tbl_followup_details WHERE followup_id = '$fid' $where");
        $row = $query->getRow();
        return $row;
	}
    public function row_details_last($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND last_follow_up_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT last_follow_up_date FROM tbl_followup_details WHERE followup_id = '$fid' $where ORDER BY followup_details_id DESC LIMIT 0,1");
        $row = $query->getRow();
        return $row;
	}
    
    public function row_details_first($fid, $searchDate, $today)
	{
	    $where = '';
	    if ($searchDate != $today){
	         $where .= " AND last_follow_up_date <='$searchDate'";
	    }
	    $query = $this->db->query("SELECT last_follow_up_date FROM tbl_followup_details WHERE followup_id = '$fid' $where ORDER BY followup_details_id ASC LIMIT 0,1");
        $row = $query->getRow();
        return $row;
	}
    public function getFollowupSummary($postData=null, $fyear = 0)
    {
         $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
         // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCompany = $postData['searchCompany'];
        $searchStatus = $postData['searchStatus'];
        $searchPeriod = $postData['searchPeriod'];
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        $searchInvoice = $postData['searchInvoice'];
         
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        $where = '';
        if(!empty($searchPeriod)){
            $where .= " AND t2.financial_year_id = $searchPeriod";
        }
        if (!empty($searchCompany)){
            $where .= " AND t2.company_id = $searchCompany";
        }
        
        if(!empty($searchStatus)){
            $where .= " AND t2.invoice_status = '$searchStatus'";
        }
        if(!empty($searchSalesman)){
            $where .= " AND t2.salesman_id = '$searchSalesman'";
        }
        if(!empty($searchInvoice)){
            $where .= " AND t2.invoice_id = '$searchInvoice'";
        }
        if(!empty($searchClient)){
            $where .= " AND t2.client_id = '$searchClient'";
        }
           /* $groupby = "currency_id, client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }*/
            
        if ($searchDate == $today){
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)");
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) ");
            $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id,t2.invoice_id,t2.Invoice_date,t2.due_date,t2.payment_terms,t2.followup_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) LIMIT $start, $rowperpage");
            $records =$query->getResult();
        } else {
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)");
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) AND t1.last_follow_up_date <= '$searchDate'");
            $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id,t2.invoice_id,t2.Invoice_date,t2.due_date,t2.payment_terms,t2.followup_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) AND t1.last_follow_up_date <= '$searchDate' LIMIT $start, $rowperpage");
            $records =$query->getResult();
        }
                
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);

            $details = $this->row_details($record->followup_id);
           
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            $lastupdated = '';
            $lastupdatedon= '';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            
            
            
            
           $data[] = array( 
             "client"=>get_client($record->client_id),
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
              "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "paymentterms"=>$record->payment_terms,
             "currency"=>$currency_data->code,
             "amt"=>$record->invoice_amount,
             //"balance"=>$record->balance,
             "followupdate"=> (isset($details->last_follow_up_date)) ? date('d-m-Y', strtotime($details->last_follow_up_date)) : '',//date('d-m-Y', strtotime($record->last_follow_up_date))
             //"nfollowupdate"=> (isset($details->next_followup_date)) ? date('d-m-Y', strtotime($details->next_followup_date)) : '',
             "rmarks"=>(isset($details->remarks)) ? $details->remarks : $record->remarks,
             "sman"=>get_salesman($record->salesman_id),
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             //"invoicestatus"=>$status,
             //"company"=>get_company($record->company_id),
             //"priority"=> $level,
             
            // "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
    }
    public function getFollowupHistory($postData=null, $fyear = 0)
	{
	    $response = array();

        ## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
         
        // Custom search filter 
         $searchClient = $postData['searchClient'];
         $searchCompany = $postData['searchCompany'];
         $searchStatus = $postData['searchStatus'];
         $searchPriority = $postData['searchPriority'];
         $searchFollowdate = $postData['searchFollowdate'];
        ## Search 
        
        $builder = $this->db->table('tbl_followup');
        $builder->select('*');
        //$builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
        $builder->where('tbl_followup.financial_year_id', $fyear);
         $builder->where('tbl_followup.invoice_status', 'O');
        //$builder->where('tbl_followup_details.status', 'A');
         $totalRecords = $builder->countAllResults();
        
        
        
        $builder->select('*');
       
        if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        // $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('tbl_followup.Invoice_date >=', $date1);
	        $builder->where('tbl_followup.Invoice_date <=', $date2);
	        //$builder->where('tbl_followup_details.status', 'A');
	       
	    }
	    $builder->where('tbl_followup.invoice_status', 'O');
        $builder->where('tbl_followup.financial_year_id', $fyear);
        

        $totalRecordwithFilter = $builder->countAllResults();
        
        $builder->select('*');
        
         if($searchClient != ''){
            $builder->where('tbl_followup.client_id', $searchClient);
        }
        if($searchCompany != ''){
            $builder->where('tbl_followup.company_id', $searchCompany);
        }
        if($searchStatus != ''){
            $builder->where('tbl_followup.invoice_status', $searchStatus);
        }
        if($searchPriority != ''){
            $builder->where('tbl_followup.critical_level_id', $searchPriority);
        }
        if(!empty($searchFollowdate)){
	        //explode
	        // $builder->join('tbl_followup_details', 'tbl_followup_details.followup_id = tbl_followup.followup_id', 'left');
	        $followdates = explode("-",$searchFollowdate);
	        $date1 = date('Y-m-d', strtotime($followdates[0]));
	        $date2 = date('Y-m-d', strtotime($followdates[1]));
	        $builder->where('tbl_followup.Invoice_date >=', $date1);
	        $builder->where('tbl_followup.Invoice_date <=', $date2);
	        //$builder->where('tbl_followup_details.status', 'A');
	       
	    }
	    $builder->where('tbl_followup.invoice_status', 'O');
        $builder->where('tbl_followup.financial_year_id', $fyear);
        
        if(!empty($columnName)){
            if($columnName == 'invoice'){
                $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id', 'inner');
                $builder->orderBy('tbl_invoices.code', $columnSortOrder);
            } else if ($columnName == 'invoicedate'){
                $builder->orderBy('tbl_followup.Invoice_date', $columnSortOrder);
            }
            
            
        }
        //$builder->orderBy('updatedDate', 'Desc');
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();
       
        $data = array();

        foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            
            $details = $this->row_details($record->followup_id);
            
            $lastupdated = '';
            $lastupdatedon = '';
            if(isset($details->updatedBy) && $details->updatedBy>0){
                $upduser = $details->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($details->updatedDate));
            } else if(isset($details->createdBy) && $details->createdBy>0){
                $upduser = $details->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($details->createdDate));
            } else if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
           
            $status = '';
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            if($record->critical_level_id == 1){
                $priority = '<span class="badge badge-info">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="badge badge-warning">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="badge badge-danger">'.$level.'</span>';
            }
            //<a href="'. base_url() .'/followup/edit/'. base64_encode($record->followup_id) .'" class="btn btn-primary btn-sm btn-flat">Edit</a>
            $button = '<a href="'. base_url() .'/followup/add/'. base64_encode($record->client_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Add" data-id="'.$record->client_id.'"><i class="fas fa-plus"></i></a><a href="'. base_url() .'/followup/details/'. base64_encode($record->followup_id) .'" class="btn btn-sm btn-flat btn-rms" data-toggle="tooltip" title="Details"><i class="fas fa-file-alt"></i></a>';
            /*<button class="btn btn-danger btn-sm btn-flat btn-followup-delete btn-rms" data-id="'.$record->followup_id.'" data-toggle="tooltip" title="Delete"><i class="far fa-trash-alt"></i></button>*/
           $data[] = array( 
             "invoice"=>get_invoice($record->invoice_id),
             "invoicedate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "amt"=>$record->invoice_amount,
             "balance"=>$record->balance,
             "followupdate"=> (isset($details->last_follow_up_date)) ? date('d-m-Y', strtotime($details->last_follow_up_date)) : '',//date('d-m-Y', strtotime($record->last_follow_up_date))
             "nfollowupdate"=> (isset($details->next_followup_date)) ? date('d-m-Y', strtotime($details->next_followup_date)) : '',
             "sman"=>get_salesman($record->salesman_id),
             "rmarks"=>(isset($details->remarks)) ? $details->remarks : $record->remarks,
             "paymentterms"=>$record->payment_terms,
             "duedate"=>date('d-m-Y', strtotime($record->due_date)),
             "currency"=>$currency_data->code,
             "invoicestatus"=>$status,
             "company"=>get_company($record->company_id),
             "priority"=> $level,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
            // "action"=>$button
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	
	public function row_details($fid)
	{
	    $query = $this->db->query("SELECT * FROM tbl_followup_details WHERE followup_id = '$fid' AND status = 'A'");
        $row = $query->getRow();
        return $row;
	}
    public function getFollowupDetailsFC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchRange= $postData['searchRange'];
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t2.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t2.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t2.invoice_status = '$searchStatus'";
            }
            $groupby = "currency_id, client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }
            if(!empty($searchRange)){
	        //explode
    	        $invdates = explode("-",$searchRange);
    	        $date1 = date('Y-m-d', strtotime($invdates[0]));
    	        $date2 = date('Y-m-d', strtotime($invdates[1]));
    	        $where .= " AND t1.last_follow_up_date BETWEEN '$date1' AND '$date2'";
    	    }
        if ($searchDate == $today){
            
           $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
           
           
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.balance_amount_in_fc,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecords = $query->getNumRows();
                
           
            
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.last_follow_up_date <= '$searchDate' GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedDate,t1.updatedBy,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.balance_amount_in_fc,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id, t2.invoice_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.last_follow_up_date <= '$searchDate' GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon='';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            $rate = ($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate;
            $expamtfc = (float)$record->expected_amount * (float)$rate;
            
           $data[] = array( 
            //"financialyear"=>$record->financial_year_id,
             "inv"=>get_invoice($record->invoice_id),
             //"invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "balfc"=>$record->balance_amount_in_fc,
             "last" => date('d-m-Y', strtotime($record->last_follow_up_date)),
             "expamt"=>$record->expected_amount,
             "expamtfc"=>number_format((float)$expamtfc, 2, '.', ''),
             "expdate"=>date('d-m-Y', strtotime($record->expected_payment_date)),
             "next"=>date('d-m-Y', strtotime($record->next_followup_date)),
             "remarks"=>$record->remarks,
             //"issue"=>$record->payment_terms,
             //"due"=>date('d-m-Y', strtotime($record->due_date)),
             "salesman"=>get_salesman($record->salesman_id),
             //"paymentterms"=>$record->payment_terms,cust_ref_no
             //"cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             //"company"=>get_company($record->company_id),
             //"priority"=> $priority,
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function getFollowupDetailsMC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchCurrency = $postData['searchCurrency']; 
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t2.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t2.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t2.invoice_status = '$searchStatus'";
            }
            $groupby = "currency_id, client_id";
            if(!empty($searchCurrency)){
                $groupby = "client_id";
                $where .= " AND t2.currency_id = $searchCurrency";
            }
        if ($searchDate == $today){
            
           $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
           
           
            $totalRecords = $query->getNumRows();
            
            
        
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
        
            $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id) GROUP BY $groupby");
                $totalRecords = $query->getNumRows();
                
           
            
            $query = $this->db->query("SELECT * FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.last_follow_up_date <= '$searchDate' GROUP BY $groupby");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT t1.last_follow_up_date,t1.expected_amount,t1.expected_payment_date,t1.next_followup_date,t1.remarks,t1.issue_type,t1.createdBy,t1.createdDate,t1.updatedBy,t1.updatedDate,t2.client_id,t2.financial_year_id,t2.company_id,t2.salesman_id,t2.currency_id,t2.invoice_amount,t2.balance,t2.fc_currency_rate,t2.invoice_amount_in_fc,t2.invoice_status,t2.critical_level_id FROM tbl_followup_details t1 INNER JOIN tbl_followup t2 ON t1.followup_id = t2.followup_id WHERE 1=1 $where AND followup_details_id IN (SELECT MAX(t0.followup_details_id) FROM tbl_followup_details t0 WHERE t0.expected_amount > 0 GROUP BY t0.followup_id)  AND t1.last_follow_up_date <= '$searchDate' GROUP BY $groupby LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            
            
           $data[] = array( 
            //"financialyear"=>$record->financial_year_id,
             //"inv"=>$record->code,
             //"invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "last" => date('d-m-Y', strtotime($record->last_follow_up_date)),
             "expamt"=>$record->expected_amount,
             "expdate"=>date('d-m-Y', strtotime($record->expected_payment_date)),
             "next"=>date('d-m-Y', strtotime($record->next_followup_date)),
             "remarks"=>$record->remarks,
             //"issue"=>$record->payment_terms,
             //"due"=>date('d-m-Y', strtotime($record->due_date)),
             "salesman"=>get_salesman($record->salesman_id),
             //"paymentterms"=>$record->payment_terms,cust_ref_no
             //"cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             //"company"=>get_company($record->company_id),
             //"priority"=> $priority,
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
     public function getInvoiceDetailsSalesmanFC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchSalesman = $postData['searchSalesman'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $today = date('Y-m-d');
        if ($searchDate == $today){
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            $totalRecords = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            if(!empty($searchSalesman)){
                $builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            /*if(!empty($searchDate)){
               $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            $totalRecordwithFilter = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            if(!empty($searchSalesman)){
                $builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            /*if(!empty($searchDate)){
                $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            //$builder->orderBy($columnName, $columnSortOrder);
            $builder->limit($rowperpage, $start);
            $query = $builder->get();
            $records =$query->getResult();
        //print_r($this->db->last_query());exit;
        //$query = $this->db->getLastQuery();
        //echo (string)$query;
        } else {
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id");
                $totalRecords = $query->getNumRows();
                
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t1.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t1.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t1.invoice_status = $searchStatus";
            }
            if(!empty($searchCurrency)){
                $where .= " AND t1.currency_id = $searchCurrency";
            }
            if(!empty($searchSalesman)){
                $where .= " AND t1.salesman_id = $searchSalesman";
                //$builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate'");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate' LIMIT $start, $rowperpage");
                $records =$query->getResult();
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon = '';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            /*if($record->critical_level_id == 1){
                $priority = '<span class="badge badge-info">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="badge badge-warning">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="badge badge-danger">'.$level.'</span>';
            }*/
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "inv"=>$record->code,
             "invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "balfc"=>$record->balance_amount_in_fc,
             "term"=>$record->payment_terms,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             /*"salesman"=>get_salesman($record->salesman_id),*/
             /*"paymentterms"=>$record->payment_terms,cust_ref_no*/
             "cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    public function getInvoiceDetailsFC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $today = date('Y-m-d');
        if ($searchDate == $today){
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            $totalRecords = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
               $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            $totalRecordwithFilter = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
                $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            //$builder->orderBy($columnName, $columnSortOrder);
            $builder->limit($rowperpage, $start);
            $query = $builder->get();
            $records =$query->getResult();
        //print_r($this->db->last_query());exit;
        //$query = $this->db->getLastQuery();
        //echo (string)$query;
        } else {
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id");
                $totalRecords = $query->getNumRows();
                
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t1.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t1.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t1.invoice_status = $searchStatus";
            }
            if(!empty($searchCurrency)){
                $where .= " AND t1.currency_id = $searchCurrency";
            }
            
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate'");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate' LIMIT $start, $rowperpage");
                $records =$query->getResult();
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
            $lastupdated = '';
            $lastupdatedon = '';
            
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            /*if($record->critical_level_id == 1){
                $priority = '<span class="badge badge-info">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="badge badge-warning">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="badge badge-danger">'.$level.'</span>';
            }*/
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "inv"=>$record->code,
             "invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "balfc"=>$record->balance_amount_in_fc,
             "term"=>$record->payment_terms,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             /*"salesman"=>get_salesman($record->salesman_id),*/
             /*"paymentterms"=>$record->payment_terms,cust_ref_no*/
             "cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    public function getInvoiceDetailsSalesmanMC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchCurrency = $postData['searchCurrency'];
        $searchSalesman = $postData['searchSalesman'];
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        if ($searchDate == $today){
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            $totalRecords = $builder->countAllResults();
            
            
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
               $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            if(!empty($searchCurrency)){
                $builder->where('tbl_followup.currency_id', $searchCurrency);
            }
            if(!empty($searchSalesman)){
                $builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            $totalRecordwithFilter = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
                $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            if(!empty($searchCurrency)){
                $builder->where('tbl_followup.currency_id', $searchCurrency);
            }
            if(!empty($searchSalesman)){
                $builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            //$builder->orderBy('tbl_followup.currency_id', 'ASC');
            $builder->limit($rowperpage, $start);
            $query = $builder->get();
            $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id");
                $totalRecords = $query->getNumRows();
                
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t1.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t1.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t1.invoice_status = $searchStatus";
            }
            if(!empty($searchCurrency)){
                $where .= " AND t1.currency_id = $searchCurrency";
            }
            if(!empty($searchSalesman)){
                $where .= " AND t1.salesman_id = $searchSalesman";
                //$builder->where('tbl_followup.salesman_id', $searchSalesman);
            }
            
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate'");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate' LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            /*if($record->critical_level_id == 1){
                $priority = '<span class="badge badge-info">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="badge badge-warning">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="badge badge-danger">'.$level.'</span>';
            }*/
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "inv"=>$record->code,
             "invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "term"=>$record->payment_terms,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             /*"salesman"=>get_salesman($record->salesman_id),*/
             /*"paymentterms"=>$record->payment_terms,cust_ref_no*/
             "cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    public function getInvoiceDetailsMC($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchCompany = $postData['searchCompany'];
        $searchPeriod = $postData['searchPeriod'];
        $searchStatus = $postData['searchStatus'];
        $searchDate = $postData['searchDate'];
        $searchCurrency = $postData['searchCurrency']; 
        //$searchAgeingDays = $postData['searchAgeingDays'];
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');
        $today = date('Y-m-d');
        
        if ($searchDate == $today){
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            $totalRecords = $builder->countAllResults();
            
            
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
               $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            if(!empty($searchCurrency)){
                $builder->where('tbl_followup.currency_id', $searchCurrency);
            }
            $totalRecordwithFilter = $builder->countAllResults();
        
            $builder = $this->db->table('tbl_followup');
            $builder->select('*');
            $builder->join('tbl_invoices', 'tbl_invoices.invoice_id = tbl_followup.invoice_id ');
            if(!empty($searchCompany)){
                $builder->where('tbl_followup.company_id', $searchCompany);
            }
            if(!empty($searchPeriod)){
                $builder->where('tbl_followup.financial_year_id', $searchPeriod);
            }
            if(!empty($searchStatus)){
                $builder->where('tbl_followup.invoice_status', $searchStatus);
            }
            /*if(!empty($searchDate)){
                $builder->where('tbl_followup.Invoice_date', date('Y-m-d', strtotime($searchDate)));
            }*/
            if(!empty($searchCurrency)){
                $builder->where('tbl_followup.currency_id', $searchCurrency);
            }
            //$builder->orderBy('tbl_followup.currency_id', 'ASC');
            $builder->limit($rowperpage, $start);
            $query = $builder->get();
            $records =$query->getResult();
            /*$query = $this->db->getLastQuery();
            echo (string)$query;*/
        } else {
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id");
                $totalRecords = $query->getNumRows();
                
            $where = '';
            if(!empty($searchPeriod)){
                $where .= " AND t1.financial_year_id = $searchPeriod";
            }
            if (!empty($searchCompany)){
                $where .= " AND t1.company_id = $searchCompany";
            }
            
            if(!empty($searchStatus)){
                $where .= " AND t1.invoice_status = $searchStatus";
            }
            if(!empty($searchCurrency)){
                $where .= " AND t1.currency_id = $searchCurrency";
            }
            
            $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate'");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT * FROM tbl_temp_followup t1 INNER JOIN tbl_invoices t2 ON t1.invoice_id = t2.invoice_id WHERE 1=1 $where AND temp_id IN (SELECT MAX(t0.temp_id) FROM tbl_temp_followup t0 WHERE t0.received_date <= '$searchDate' AND t0.invoice_amount_in_fc > 0 GROUP BY t0.followup_id)  AND t1.received_date <= '$searchDate' LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
        }
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            //$invoice_data = $this->row_invoice($record->invoice_id);
            $status = '';
            
            if($record->invoice_status == 'O'){
                $status = 'Open';
            }else if($record->invoice_status == 'C'){
                $status = 'Closed';
            }
            
             $lastupdated = '';
            $lastupdatedon='';
            if(isset($record->updatedBy) && $record->updatedBy>0){
                $upduser = $record->updatedBy;
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->updatedDate));
            } else if(isset($record->createdBy) && $record->createdBy>0){
                $upduser = $record->createdBy; 
                $lastupdated = get_user($upduser);
                $lastupdatedon = date('d-m-Y', strtotime($record->createdDate));
            }
            
            $priority = '';
            $level = get_critical_level($record->critical_level_id);
            /*if($record->critical_level_id == 1){
                $priority = '<span class="badge badge-info">'.$level.'</span>';
            } else if($record->critical_level_id == 2){
                $priority = '<span class="badge badge-warning">'.$level.'</span>';
            } else if($record->critical_level_id == 3){
                $priority = '<span class="badge badge-danger">'.$level.'</span>';
            }*/
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "inv"=>$record->code,
             "invdate"=>date('d-m-Y', strtotime($record->Invoice_date)),
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "rate"=>($fcur == $record->currency_id) ? '1.00' : $record->fc_currency_rate,
             "invamt"=>$record->invoice_amount,
             "invamtfc"=>$record->invoice_amount_in_fc,
             "bal"=>$record->balance,
             "term"=>$record->payment_terms,
             "due"=>date('d-m-Y', strtotime($record->due_date)),
             /*"salesman"=>get_salesman($record->salesman_id),*/
             /*"paymentterms"=>$record->payment_terms,cust_ref_no*/
             "cust_ref_no"=>$record->cust_ref_no,
             "priority"=>$level,
             "status"=>$status,
             "lastupdated"=> $lastupdated,
             "lastupdatedon"=> (string)$lastupdatedon,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function row_currency($curid){
	    $query = $this->db->query("SELECT currency_id,name,code,symbol,status,rate,rateDate,createdBy,createdDate,updatedBy,updatedDate FROM tbl_currency_m WHERE currency_id = '$curid'");
        $row = $query->getRow();
        return $row;
	}
    
    public function getAgingDuedateMcStatements($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        //$columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
        //$columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchColumn0 = $postData['searchColumn0'];
        $searchColumn1 = $postData['searchColumn1'];
        $searchColumn2 = $postData['searchColumn2'];
        $searchColumn3 = $postData['searchColumn3'];
        $searchColumn4 = $postData['searchColumn4'];
        $searchColumn5 = $postData['searchColumn5'];
        $searchCompany = $postData['searchCompany'];
        $searchDate    = $postData['searchDate'];
        $searchCurrency = $postData['searchCurrency'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');

        
        $where = " AND financial_year_id = $fyear";
        
        if (!empty($searchCompany)){
            $where .= " AND company_id = $searchCompany";
        }
        
        $groupby = "currency_id, client_id";
        if (!empty($searchCurrency)){
            $where .= " AND currency_id = $searchCurrency";
            $groupby = "client_id";
        }
        
        $today = date('Y-m-d');
        
        //if ($searchCurrency == $fcur) {
            if ($searchColumn0 == $today){
    
                $searchColumn1Start = $searchColumn0 + 1;
                $searchColumn2Start = $searchColumn1 + 1;
                $searchColumn3Start = $searchColumn2 + 1;
                $searchColumn4Start = $searchColumn3 + 1;
                $searchColumn5Start = $searchColumn4 + 1;
    
                
                
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecords = $query->getNumRows();
            
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' $where GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecordwithFilter = $query->getNumRows();
                
                
                $query = $this->db->query("SELECT client_id,currency_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' $where GROUP BY $groupby ORDER BY currency_id DESC LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
            } else {
                $searchColumn1Start = $searchColumn0 + 1;
                $searchColumn2Start = $searchColumn1 + 1;
                $searchColumn3Start = $searchColumn2 + 1;
                $searchColumn4Start = $searchColumn3 + 1;
                $searchColumn5Start = $searchColumn4 + 1;
                
                 $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecords = $query->getNumRows();
            
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' $where AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecordwithFilter = $query->getNumRows();
                
                
                $query = $this->db->query("SELECT client_id,currency_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance > 0 AND invoice_status = 'O' $where AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' GROUP BY $groupby ORDER BY currency_id DESC LIMIT $start, $rowperpage");
                $records =$query->getResult();
            }
            
        

        
        
        $data = array();
        
         foreach($records as $record ){
            $currency_data = $this->row_currency($record->currency_id);
            
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "d0"=>$record->age0,
             "d30"=>$record->age130,
             "d60"=>$record->age3160,
             "d90"=>$record->age6190,
             "d180"=>$record->age91180,
             "d360"=>$record->age181360,
             "d360p"=>$record->age360p,
             /*"paymentterms"=>$record->payment_terms,*/
             "total"=>$record->totalBalance,
             "totalfc"=>$record->totalBalancefc,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function getAgingDuedateFcStatements($postData=null, $fyear = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
       // $columnIndex = $postData['order'][0]['column']; // Column index
       // $columnName = $postData['columns'][$columnIndex]['data']; // Column name
       // $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchColumn0 = $postData['searchColumn0'];
        $searchColumn1 = $postData['searchColumn1'];
        $searchColumn2 = $postData['searchColumn2'];
        $searchColumn3 = $postData['searchColumn3'];
        $searchColumn4 = $postData['searchColumn4'];
        $searchColumn5 = $postData['searchColumn5'];
        $searchCompany = $postData['searchCompany'];
        $searchDate    = $postData['searchDate'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');

        
        $where = " AND financial_year_id = $fyear";
        
        if (!empty($searchCompany)){
            $where = " AND company_id = $searchCompany";
        }
        
        $today = date('Y-m-d');
        if ($searchColumn0 == $today){

            $searchColumn1Start = $searchColumn0 + 1;
            $searchColumn2Start = $searchColumn1 + 1;
            $searchColumn3Start = $searchColumn2 + 1;
            $searchColumn4Start = $searchColumn3 + 1;
            $searchColumn5Start = $searchColumn4 + 1;

            
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0 , balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecords = $query->getNumRows();
        
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecordwithFilter = $query->getNumRows();
            
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY client_id ORDER BY totalBalance DESC LIMIT $start, $rowperpage");
            $records =$query->getResult();
        
        } else {
            $searchColumn1Start = $searchColumn0 + 1;
            $searchColumn2Start = $searchColumn1 + 1;
            $searchColumn3Start = $searchColumn2 + 1;
            $searchColumn4Start = $searchColumn3 + 1;
            $searchColumn5Start = $searchColumn4 + 1;
            
             $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0 , balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecords = $query->getNumRows();
        
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecordwithFilter = $query->getNumRows();
            
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', due_date ) < 0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', due_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', due_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC LIMIT $start, $rowperpage");
            $records =$query->getResult();
        }


        
        
        $data = array();
        
         foreach($records as $record ){
            
            
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "client"=>get_client($record->client_id),
             "d0"=>$record->age0,
             "d30"=>$record->age130,
             "d60"=>$record->age3160,
             "d90"=>$record->age6190,
             "d180"=>$record->age91180,
             "d360"=>$record->age181360,
             "d360p"=>$record->age360p,
             /*"paymentterms"=>$record->payment_terms,*/
             "total"=>$record->totalBalance,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    
    public function getAgingInvoicedateMcStatements($postData=null, $fyear = 0, $fcur = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
       // $columnIndex = $postData['order'][0]['column']; // Column index
        //$columnName = $postData['columns'][$columnIndex]['data']; // Column name
       // $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchColumn0 = $postData['searchColumn0'];
        $searchColumn1 = $postData['searchColumn1'];
        $searchColumn2 = $postData['searchColumn2'];
        $searchColumn3 = $postData['searchColumn3'];
        $searchColumn4 = $postData['searchColumn4'];
        $searchColumn5 = $postData['searchColumn5'];
        $searchCompany = $postData['searchCompany'];
        $searchDate    = $postData['searchDate'];
        $searchCurrency = $postData['searchCurrency'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');

        
        $where = " AND financial_year_id = $fyear";
        
        if (!empty($searchCompany)){
            $where .= " AND company_id = $searchCompany";
        }
        $groupby = "currency_id, client_id";
        if (!empty($searchCurrency)){
            $where .= " AND currency_id = $searchCurrency";
            $groupby = "client_id";
        }
        
        $today = date('Y-m-d');
        
        //if ($searchCurrency == $fcur) {
            if ($searchDate == $today){
    
                $searchColumn1Start = $searchColumn0;
                $searchColumn2Start = $searchColumn1 + 1;
                $searchColumn3Start = $searchColumn2 + 1;
                $searchColumn4Start = $searchColumn3 + 1;
                $searchColumn5Start = $searchColumn4 + 1;
    
                
                
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecords = $query->getNumRows();
            
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecordwithFilter = $query->getNumRows();
                
                
                $query = $this->db->query("SELECT client_id,currency_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY $groupby ORDER BY currency_id DESC LIMIT $start, $rowperpage");
                $records =$query->getResult();
            
            } else {
                $searchColumn1Start = $searchColumn0;
                $searchColumn2Start = $searchColumn1 + 1;
                $searchColumn3Start = $searchColumn2 + 1;
                $searchColumn4Start = $searchColumn3 + 1;
                $searchColumn5Start = $searchColumn4 + 1;
                
                 $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecords = $query->getNumRows();
                
                $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY $groupby ORDER BY totalBalance DESC");
                $totalRecordwithFilter = $query->getNumRows();
                
                $query = $this->db->query("SELECT client_id,currency_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance, 0)) AS age360p, SUM(balance) AS totalBalance, SUM(balance_amount_in_fc) AS totalBalancefc FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY $groupby ORDER BY currency_id DESC LIMIT $start, $rowperpage");
                $records =$query->getResult();
            }
            
       // } 


        
        
        $data = array();
        
         foreach($records as $record ){
            
            $currency_data = $this->row_currency($record->currency_id);
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "client"=>get_client($record->client_id),
             "cur"=>$currency_data->code,
             "d0"=>$record->age0,
             "d30"=>$record->age130,
             "d60"=>$record->age3160,
             "d90"=>$record->age6190,
             "d180"=>$record->age91180,
             "d360"=>$record->age181360,
             "d360p"=>$record->age360p,
             /*"paymentterms"=>$record->payment_terms,*/
             "total"=>$record->totalBalance,
             "totalfc"=>$record->totalBalancefc,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    
    public function getAgingInvoicedateFcStatements($postData=null, $fyear = 0)
    {
        $response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value
        
        $searchColumn0 = $postData['searchColumn0'];
        $searchColumn1 = $postData['searchColumn1'];
        $searchColumn2 = $postData['searchColumn2'];
        $searchColumn3 = $postData['searchColumn3'];
        $searchColumn4 = $postData['searchColumn4'];
        $searchColumn5 = $postData['searchColumn5'];
        $searchCompany = $postData['searchCompany'];
        $searchDate    = $postData['searchDate'];
        $searchClient  = $postData['searchClient'];
        
        $searchDate = (!empty($searchDate)) ? date('Y-m-d', strtotime($searchDate)) : date('Y-m-d');

        
        $where = " AND financial_year_id = $fyear";
        
        if (!empty($searchCompany)){
            $where .= " AND company_id = $searchCompany";
        }
        if (!empty($searchClient)){
            $where .= " AND client_id = $searchClient";
        }
        
        $today = date('Y-m-d');
        if ($searchDate == $today){

            $searchColumn1Start = $searchColumn0 ;
            $searchColumn2Start = $searchColumn1 + 1;
            $searchColumn3Start = $searchColumn2 + 1;
            $searchColumn4Start = $searchColumn3 + 1;
            $searchColumn5Start = $searchColumn4 + 1;

            
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecords = $query->getNumRows();
        
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecordwithFilter = $query->getNumRows();
            
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) = $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' $where GROUP BY client_id ORDER BY totalBalance DESC LIMIT $start, $rowperpage");
            $records =$query->getResult();
        
        } else {
            $searchColumn1Start = $searchColumn0 ;
            $searchColumn2Start = $searchColumn1 + 1;
            $searchColumn3Start = $searchColumn2 + 1;
            $searchColumn4Start = $searchColumn3 + 1;
            $searchColumn5Start = $searchColumn4 + 1;
            
            
           // echo "SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 0 AND $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC";exit;
            
             $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 0 AND $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecords = $query->getNumRows();
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 0 AND $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC");
            $totalRecordwithFilter = $query->getNumRows();
            
            $query = $this->db->query("SELECT client_id, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN 0 AND $searchColumn0, balance_amount_in_fc, 0)) AS age0, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn1Start AND $searchColumn1, balance_amount_in_fc, 0)) AS age130, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn2Start AND $searchColumn2, balance_amount_in_fc, 0)) AS age3160, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn3Start AND $searchColumn3, balance_amount_in_fc, 0)) AS age6190, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn4Start AND $searchColumn4, balance_amount_in_fc, 0)) AS age91180, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) BETWEEN $searchColumn5Start AND $searchColumn5, balance_amount_in_fc, 0)) AS age181360, SUM(IF(DATEDIFF('$searchDate', Invoice_date ) > $searchColumn5, balance_amount_in_fc, 0)) AS age360p, SUM(balance_amount_in_fc) AS totalBalance FROM tbl_temp_followup bill WHERE bill.balance_amount_in_fc > 0 AND invoice_status = 'O' AND temp_id IN (SELECT MAX(t1.temp_id) FROM tbl_temp_followup t1 WHERE t1.received_date <= '$searchDate' AND invoice_amount_in_fc > 0 GROUP BY t1.followup_id)  AND received_date <= '$searchDate' $where GROUP BY client_id ORDER BY totalBalance DESC LIMIT $start, $rowperpage");
            $records =$query->getResult();
        }


        
        
        $data = array();
        
         foreach($records as $record ){
            
            
            
           $data[] = array( 
             /*"financialyear"=>$record->financial_year_id,*/
             "client"=>get_client($record->client_id),
             "d0"=>$record->age0,
             "d30"=>$record->age130,
             "d60"=>$record->age3160,
             "d90"=>$record->age6190,
             "d180"=>$record->age91180,
             "d360"=>$record->age181360,
             "d360p"=>$record->age360p,
             /*"paymentterms"=>$record->payment_terms,*/
             "total"=>$record->totalBalance,
             /*"company"=>get_company($record->company_id),
             "priority"=> $priority,*/
           ); 
        }
        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 

    }
    public function active_period()
    {
        $query = $this->db->query("SELECT financialYear_id,startDate,endDate,financialYear,status,createdBy,createdDate,updatedBy,updatedDate FROM tbl_financialYear_m WHERE status = 1");
        $row = $query->getRow();
        return 'Period : From '.date('d-m-Y',strtotime($row->startDate)).' To '.date('d-m-Y',strtotime($row->endDate));
    }
    public function getSalesmanStatements($postData=null, $fyear = 0)
	{
		$response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value

        // Custom search filter 
        //$searchClient = $postData['searchClient'];
        //$searchCountry= $postData['searchCountry'];

        $builder = $this->db->table('tbl_salesman_m');
        $builder->select('*');
        $builder->join('tbl_user_m', 'tbl_user_m.user_id = tbl_salesman_m.user_id');
        $totalRecords = $builder->countAllResults();

        $builder->select('*');
        $builder->join('tbl_user_m', 'tbl_user_m.user_id = tbl_salesman_m.user_id');
        /*if($searchClient != ''){
            $builder->where('tbl_client_m.Parent_client', $searchClient);
        }
        if($searchCountry != ''){
            $builder->where('tbl_client_m.country_id ', $searchCountry);
        }*/
        $totalRecordwithFilter = $builder->countAllResults();

        $builder->select('*');
        $builder->join('tbl_user_m', 'tbl_user_m.user_id = tbl_salesman_m.user_id'); 
        /*if($searchClient != ''){
            $builder->where('tbl_client_m.Parent_client', $searchClient);
        }
        if($searchCountry != ''){
            $builder->where('tbl_client_m.country_id ', $searchCountry);
        }*/       
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();

        $data = array();

        foreach($records as $record ){
        	if($record->isActive == 1){
                $status = 'Active';
            }else if($record->isActive == 0){
                $status = 'Inactive';
            }
            if($record->loginStatus == 1){
                $cc = 'Yes';
            }else if($record->loginStatus == 0){
                $cc = 'No';
            }
        	$data[] = array( 
             "name"=>$record->sales_man_name,
             "email"=>$record->email,
             "status"=>$status,
             "loginsta"=>$cc,
           ); 
        }

        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
	public function getClientsStatements($postData=null, $fyear = 0)
	{
		$response = array();

		## Read value
        $draw = $postData['draw'];
        $start = $postData['start'];
        $rowperpage = $postData['length']; // Rows display per page
        $columnIndex = $postData['order'][0]['column']; // Column index
        $columnName = $postData['columns'][$columnIndex]['data']; // Column name
        $columnSortOrder = $postData['order'][0]['dir']; // asc or desc
        $searchValue = $postData['search']['value']; // Search value

        // Custom search filter 
        $searchClient = $postData['searchClient'];
        $searchCountry= $postData['searchCountry'];

        $builder = $this->db->table('tbl_client_m');
        $builder->select('*');
        $builder->join('tbl_country_m', 'tbl_country_m.country_id = tbl_client_m.country_id ');
        $totalRecords = $builder->countAllResults();

        $builder->select('*');
        $builder->join('tbl_country_m', 'tbl_country_m.country_id = tbl_client_m.country_id');
        if($searchClient != ''){
            $builder->where('tbl_client_m.Parent_client', $searchClient);
        }
        if($searchCountry != ''){
            $builder->where('tbl_client_m.country_id ', $searchCountry);
        }
        $totalRecordwithFilter = $builder->countAllResults();

        $builder->select('*');
        $builder->join('tbl_country_m', 'tbl_country_m.country_id = tbl_client_m.country_id'); 
        if($searchClient != ''){
            $builder->where('tbl_client_m.Parent_client', $searchClient);
        }
        if($searchCountry != ''){
            $builder->where('tbl_client_m.country_id ', $searchCountry);
        }       
        //$builder->orderBy($columnName, $columnSortOrder);
        $builder->limit($rowperpage, $start);
        $query = $builder->get();
        $records =$query->getResult();

        $data = array();

        foreach($records as $record ){
        	if($record->status == 1){
                $status = 'Active';
            }else if($record->status == 0){
                $status = 'Inactive';
            }
            if($record->is_same_parent == 1){
                $cc = 'Yes';
            }else if($record->is_same_parent == 0){
                $cc = 'No';
            }
        	$data[] = array( 
             "name"=>$record->name,
             "code"=>$record->code,
             "country"=>$record->country_name,
             "address"=>$record->address,
             "phone"=>$record->phone,
             "phone2"=>$record->Phone2,
             "email"=>$record->email,
             "whatsapp"=> $record->whatsAppNo,
             "cc"=> $cc,
             "status"=>$status
           ); 
        }

        ## Response
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $totalRecords,
           "iTotalDisplayRecords" => $totalRecordwithFilter,
           "aaData" => $data
        );
    
        return $response; 
	}
}