<?php
use App\Models\CompanyModel;
use App\Models\PriorityModel;
use App\Models\ClientsModel;
use App\Models\InvoiceModel;
use App\Models\SalesmanModel;
use App\Models\CountryModel;
use App\Models\UsersModel;
use App\Models\CurrencyModel;
use App\Models\PermissionModel;
// Function: used to convert a string to revese in order

if (!function_exists("get_currency")) {
    function get_currency(int $id)
    {
        if (empty($id)){
            return null;
        }
        $cmodel = new CurrencyModel();
        $cdata = $cmodel->where('currency_id', $id)->first();
        return $cdata['code'];
    }
}

if (!function_exists("get_user")) {
    function get_user(int $id)
    {
        if (empty($id)){
            return null;
        }
        $umodel = new UsersModel();
        $udata = $umodel->where('user_id', $id)->first();
        return $udata['userName'];
    }
}
if (!function_exists("get_company")) {
    function get_company(int $id)
    {
        if (empty($id)){
            return null;
        }
        $compmodel = new CompanyModel();
        $compdata = $compmodel->where('company_id', $id)->first();
        return $compdata['companyName'];
    }
}

if (!function_exists("get_critical_level")) {
    function get_critical_level(int $id)
    {
        if (empty($id)){
            return null;
        }
        $priomodel = new PriorityModel();
        $priodata = $priomodel->where('id', $id)->first();
        return $priodata['level'];
    }
}

if (!function_exists("get_client")) {
    function get_client(int $id)
    {
        if (empty($id)){
            return null;
        }
        $clientmodel = new ClientsModel();
        $clientdata = $clientmodel->where('client_id', $id)->first();
        return $clientdata['name'];
    }
}

if (!function_exists("get_salesman")) {
    function get_salesman(int $id)
    {
        if (empty($id)){
            return null;
        }
        $salesmodel = new SalesmanModel();
        $salesdata = $salesmodel->where('salesman_id', $id)->first();
        return $salesdata['sales_man_name'];
    }
}

if (!function_exists("get_invoice")) {
    function get_invoice(int $id)
    {
        if (empty($id)){
            return null;
        }
        $invmodel = new InvoiceModel();
        $invdata = $invmodel->where('invoice_id', $id)->first();
        return $invdata['code'];
    }
}

if (!function_exists("get_country")) {
    function get_country(int $id)
    {
        if (empty($id)){
            return null;
        }
        $cmodel = new CountryModel();
        $cdata = $cmodel->where('country_id', $id)->first();
        return $cdata['country_name'];
    }
}
if (!function_exists("getUserPrivilegeById")) {
    function getUserPrivilegeById(int $userid,int $sub_module_id)
    {
        
        /*if (empty($id)){
            return null;
        }*/
        $pmodel = new PermissionModel();
        
        $pdata = $pmodel->getUserPrivilege($userid, $sub_module_id);
        //print_r($pdata);
        return $pdata;
    }
}

if (!function_exists("hasPermission")) {
    function hasPermission(int $userid,int $sub_module_id)
    {
        
        /*if (empty($id)){
            return null;
        }*/
        $pemodel = new PermissionModel();
        
        $pdata = $pemodel->getUserPrivilege($userid, $sub_module_id);
        $permission = false;
        if(!empty($pdata)){
            if($pdata->addStatus == 1 || $pdata->editStatus == 1 || $pdata->deleteStatus == 1){
                $permission = true;
            } else {
                $permission = false;
            }
        } else {
            $permission = false;
        }
        return $permission;
    }
}