
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminLTE 3 | Invoice Print</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/dist/css/adminlte.min.css">
  
  <link rel="stylesheet" href="<?php echo base_url() ?>/public/dist/custom.css">
  
</head>
<body>
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
    <!--<div class="row">
      <div class="col-12">
        <h2 class="page-header">
          <i class="fas fa-globe"></i> AdminLTE, Inc.
          <small class="float-right">Date: 2/10/2014</small>
        </h2>
      </div>
      
    </div>-->
    <!-- info row -->
    <div class="row invoice-info borderline">
      <div class="col-sm-4 invoice-col prin-text-cen Centered">
          <img class="p-5" src="<?= base_url().$headcomp['logo']?>" width="300px">
        <!--From
        <address>
          <strong>Admin, Inc.</strong><br>
          795 Folsom Ave, Suite 600<br>
          San Francisco, CA 94107<br>
          Phone: (804) 123-5432<br>
          Email: info@almasaeedstudio.com
        </address>-->
      </div>
      <!-- /.col -->
      <div class="col-sm-4 invoice-col">
        <!--To
        <address>
          <strong>John Doe</strong><br>
          795 Folsom Ave, Suite 600<br>
          San Francisco, CA 94107<br>
          Phone: (555) 539-1037<br>
          Email: john.doe@example.com
        </address>-->
      </div>
      <!-- /.col -->
      <div class="col-sm-4 invoice-col">
        <h2><?=$headcomp['companyName']?></h2><br>
     
        <b><?=$headcomp['companyAddress']?></b><br>
        <b><?= get_country($headcomp['country_id'])?></b><br>
        <b><?=$headcomp['phoneNo']?></b> <br>
        <b><?=$headcomp['email']?></b>   <br>
      
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
    
    <?php
    $paymode = '';
    if($printdata[0]['payment_mode'] == 'C'){
        $paymode = 'Cash';
    } else if($printdata[0]['payment_mode'] == 'CA'){
        $paymode = 'Card';
    } else if($printdata[0]['payment_mode'] == 'Q'){
        $paymode = 'Cheque';
    } else if($printdata[0]['payment_mode'] == 'B'){
        $paymode = 'Bank';
    }
    //payment_mode
    $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
    ?>
    <div class="row">
        <div class="col-md-12">
            <h3 class="prin-text-cen text-stye">RECEIPT</h3>
        </div>
    </div>
    <div class="row borderline">
        <div class="col-10">
        
        <div class="table-responsive ">
          <table class="table">
            <tr>
              <th style="  border: none;  ">Client:</th>
              <td style="  border: none;"><?= get_client($printdata[0]['client_id'])?></td>
            </tr>
            <tr>
              <th style="border: none;">Amount in Figures:</th>
              <td style="border: none;"> 
              <!---- --->
               <div class="box1 "><?= get_currency($printdata[0]['currency_id'])?> :<strong class="b-l"><?=$printsum[0]['total']?></strong></div>
              </td>
            </tr>
            <tr>
              <th style="border: none;">Amount in Words:</th>
              <td style="border: none;">
                  
                  
                 <?= get_currency($printdata[0]['currency_id'])?> <?=ucfirst($f->format($printsum[0]['total']));?>
                  </td>
            </tr>
            <tr>
              <th style="border: none;">Payment Mode:</th>
              <td style="border: none;"><?=$paymode?></td>
            </tr>
           
          </table>
        </div>
      </div>
      
      
      <div class="col-md-2 ">
          
          Date:<?=date('d-m-Y')?><br>
          Ref :<?=$refno?>
          
      </div>
    </div>

    <!-- Table row -->
    <div class="row">
        <div class="col-md-12">
            <h3 class="text-pay">Payment For</h3>
        </div>
    </div>
    <div class="row">
      <div class="col-12 table-responsive">
        <table class="table table-striped">
          <thead>
          <tr>
            <th class="border-box">Inv.No</th>
            <th class="border-box">Inv.Date</th>
            <th class="border-box">Cur</th>
            <th class="border-box">Inv.Amount</th>
            <th class="border-box">Received Amount</th>
          </tr>
          </thead>
          <tbody>
              <?php if(!empty($printdata)): 
                  foreach($printdata as $data):
              ?>
          <tr>
            <td class="border-box"><?= get_invoice($data['invoice_id'])?></td>
            <td class="border-box"><?= date('d-m-Y', strtotime($data['Invoice_date']));?></td>
            <td class="border-box"><?=get_currency($data['currency_id'])?></td>
            <td class="border-box" style="text-align:right"><?=$data['invoice_amount']?></td>
            <td class="border-box" style="text-align:right"><?=$data['received_amount']?></td>
          </tr>
          <?php 
          endforeach;
          endif; ?>
          </tbody>
        </table>
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->

    <!--<div class="row">
      
      <div class="col-6">
        <p class="lead">Payment Methods:</p>
        <img src="../../dist/img/credit/visa.png" alt="Visa">
        <img src="../../dist/img/credit/mastercard.png" alt="Mastercard">
        <img src="../../dist/img/credit/american-express.png" alt="American Express">
        <img src="../../dist/img/credit/paypal2.png" alt="Paypal">

        <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
          Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango imeem plugg dopplr
          jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
        </p>
      </div>
     
      <div class="col-6">
        <p class="lead">Amount Due 2/22/2014</p>

        <div class="table-responsive">
          <table class="table">
            <tr>
              <th style="width:50%">Subtotal:</th>
              <td>$250.30</td>
            </tr>
            <tr>
              <th>Tax (9.3%)</th>
              <td>$10.34</td>
            </tr>
            <tr>
              <th>Shipping:</th>
              <td>$5.80</td>
            </tr>
            <tr>
              <th>Total:</th>
              <td>$265.24</td>
            </tr>
          </table>
        </div>
      </div>
     
    </div>-->
    <!-- /.row -->
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
<!-- Page specific script -->
<script>
  window.addEventListener("load", window.print());
</script>
</body>
</html>
